#ifndef __PARAMETERS_INCLUDED__
	#define __PARAMETERS_INCLUDED__
	//The above is so that we don't redefine and reinclude multiple times, and to account for the fact that all files need these
	// #include "localConfig.txt"
	#define COGNATE_ANTIGEN_RATIO_LOOKUP_TABLE_PREFIX "/scratch/brown/LNModelPreprocessedProbs/activationProbabilityVersusCognateAntigenRatio"
		//Previously, was in self-directory. However, as file numbers get large, this takes lots of space.
	//Parameters for all versions of code
		// #define _GAUSS_
		#define DEFAULT_RADIUS (500)
			//in micrometres
		#define DEFAULT_CONTACT_RADIUS (20)
		#define T_CELL_DENSITY (1E6)
			//per mm^3.
		#define TOTAL_TNUM (T_CELL_DENSITY*4.0*0.3333*3.1415926 * radius*radius*radius * 1E-9)
			//2.6E7
		#define DEFAULT_AGSPEC_FREQ (1E-5)
		#define DEFAULT_DENDNUM (720)
		#define DEFAULT_SEED (6)
		#define DEFAULT_NUM_REPEATS (1)
		#define DEFAULT_NUM_CHUNKS (1)

		#define DEFAULT_NUM_BINS (100)
		#define DEFAULT_NUM_TIME_MEASUREMENTS (300)
		#define DEFAULT_T_VELOCITY_MEAN (10.06354)
		#define DEFAULT_T_VELOCITY_STDEV (0.5) //Only for gauss
		#define T_GAMMA_SHAPE (2.28567314561) //Only for gamma
		#define T_GAMMA_SCALE(v) (v/DEFAULT_T_VELOCITY_MEAN*4.40287799651)
			//Mean SHAPE*SCALE = 10.06354 * v/defaultV;
			//Variance SHAPE*SCALE*SCALE = 44.308538833 * v^2/defaultV^2 -> s.d. 6.66 * v/defaultV
		#define DEFAULT_T_FREE_PATH_MEAN (25)
		#define DEFAULT_T_FREE_PATH_STDEV (3)		
		#define DEFAULT_NUM_ANTIGEN_IN_CONTACT_AREA (500)
			//around 100k receptors on surface area, about 100% occupancy; contact area is about 7.8 / 2000 of the total surface area
		#define DEFAULT_NUM_ANTIGEN_ON_DC (100000)
		// #define DEND_SURF_AREA (2000) //These are not needed if the other values are defined as being in the contact area. The surface area and contact area were chosen from Beltman et al (2007).
		// #define CONTACT_AREA (10)
		#define DEFAULT_TCELL_ACTIVATION_THRESHOLD (20)
			//Density around 2.5 complexes / mumetre^2; so 8*2.5 ~ 20; 10 from "T cell activation is determined by the number of presentated ags" [2013] & ~10 from "functional anatomy of T cell activation and synapse formation" [2010]
		#define DEFAULT_FIRST_DC_ARRIVAL (1080)
		#define DEFAULT_DC_ARRIVAL_DURATION (360)
		#define DEFAULT_ANTIGEN_DECAY_RATE (0.0013872817502659875)
			//Per minute, from k2=ln(2)/650mins + MHCturnover=ln(2)/36hrs. w/ MHC turnover of 7hours:  0.002716730707689163
		#define MINIMUM_ANTIGEN_DECAY_RATE (0.00032090147248145615)
			//Set by MHC turnover.
		#define DEFAULT_COGNATE_RATIO_MEAN_AT_DERMIS (0.2)
		#define PROBABILITY_TOLERANCE (1e-8)
			//Set probabilities below this to 0
		#define TIME_TOLERANCE (1e-6)
		#define ANTIGEN_OOB_TOLERANCE (0.1*numDCells)
		#define POSITION_OOB_TOLERANCE (100*numDCells)
		#define MINIMUM_CONTACT_GRID_MEMORY_REDUCTION_FACTOR (0.25)

	//Stationary DC version
		#define DEFAULT_TIMESTEP (0.05)
		#define NUM_TIMESTEPS_HOUR(ts) (60 / ts)
		#define NUM_TIMESTEPS_DAY(ts) (1440 / ts)
		#define NUM_TIMESTEPS_2DAY(ts) (2880 / ts)
				//600,000 and 14,400,000
		#define DEFAULT_TIME_STEPS_PER_GRAPHICAL_UPDATE (10)	
	
	//Random movement of DC version
		#define MAX_TIME_HOUR (60)
		#define MAX_TIME_DAY (1440)
		#define MAX_TIME_2DAY (2880)
		#define DEFAULT_TIME_PER_GRAPHICAL_UPDATE (1)
		#define DEFAULT_D_VELOCITY_MEAN (7)
		#define DEFAULT_D_VELOCITY_STDEV (6)
		#define D_GAMMA_SHAPE (3.30260074388)
		#define D_GAMMA_SCALE(v) (v/DEFAULT_D_VELOCITY_MEAN*2.15423557122)
		#define DEFAULT_D_FREE_PATH_MEAN (4)
		#define DEFAULT_D_FREE_PATH_STDEV (0.5)

	using namespace std;
	#include <iostream>
	#include <fstream>
	#include <sstream>
	#include <string>
	#include <algorithm>
	#include <cmath>
	// #include <boost/math/distributions/pareto.hpp>
	#include <boost/math/distributions/hypergeometric.hpp>
	#include <boost/math/distributions/binomial.hpp>
	#include <boost/format.hpp>
	#include <random> //needs c++11
	#include <sys/stat.h> //For checking existence of file
	#include <ctime>
	#include "GPMoments.h"

	#if defined(__linux__)
		#include <unistd.h>
	#elif defined(__WIN32) || defined(__CYGWIN__)
		#include <windows.h>
		typedef unsigned int uint;
	#else
		#error "Unknown platform"
		return 1
	#endif

#endif //__PARAMETERS_INCLUDED__

//Default parameters
	//Volume V = 4/3piR^3
	//Timestep dt
	//Cell types:
	//	T cells
	//		Diffuse w/ constant D from gaussian distribution, mean 0, variance 2*D*dt
	//		Reflect from boundary of volume, pass through T cells
	//		Contact w/ dendritic cell when cell centres < b
	//		Density present = rho
	//	Dendritic  cells
	//		Stationary
	//		Number present = A
	//		Randomly distributed & immobile
	//	Parameters
	//		R = 400 mu m
	//		D = 10 mu m^2/min
	//		b = 12mu m
	//		A variable but take A = 20000
	//			-> volume taken up by DCs is 144691200 (mu m)^3 = 54% of sphere volume
	//		Number of T cells ~ 10^6; rho = 10^6 / V. T_CELL_DENSITY = rho * phi = 1/V, where phi = 10^{-4} ~ 10^{-6} is the freq of T-cells that are specific to our Ag. So,
	//		rho variable but take rho = 10^{-6}
	//		time in units of minutes, maxtime is 1 day
	//Mean free path is ~20-30mu m or about 2-3 mins.
	//Have variable velocity and variable free distance, hope that the bounds are about 2-3 mins (can check).
	//Average velocity ~10-12m/s. So, use equipartition of energy <v^2> ~ 121m/s and so <vx^2> ~ 40.3m/s and <vx> = 0, so vx_stddev = sqrt(40.3) ~ 6.35m/s
