// #define GNUPLOT (0)
#ifdef GNUPLOT
	#include "gnuplot-iostream.h"
	/* ****** **
	*  Static  *
	** ****** */
	#if !defined(__LINEAR_FUNCTIONS_INCLUDED__) && !defined(__RANDOM_FUNCTIONS_INCLUDED__)
		#define PLOT_CELLS																										\
			gp << "splot '-' u 1:2:3:(2*distToPoint($1,$2,$3)/radius) w points pointtype 6 lc \"blue\" ps variable, "					\
			<< "'-' u 1:2:3:(distToPoint($1,$2,$3)/radius) w points pointtype 7 lc \"red\" ps variable; "							\
			<< "set xlabel '" << int(t*timeStep) << "'\n";																			\
			dCellPartialList=vector<dCell>(dCellList.begin(), dCellList.begin()+dCellsPresentPerWave[waveNumber]);						\
			for(uint w=waveNumber+1; w<numWaves; w++){																					\
				dCellPartialList.insert(dCellPartialList.end(), dCellList.begin()+(w-waveNumber)*numDCells, dCellList.begin()+(w-waveNumber)*numDCells+dCellsPresentPerWave[w]);\
			}																															\
			gp.send1d(dCellPartialList);																								\
			gp.send1d(tCellList);
			//The "distToPoint" function calculates the distance to a given point, in order to choose its size. 
			// we splot (data) 1:2:3:size; this is the x,y and z coordinates, and the size of the point respectively. 
	#endif

	/* ****** **
	*  Linear  *
	** ****** */
	#if defined(__LINEAR_FUNCTIONS_INCLUDED__)
		#define PLOT_CELLS																											\
		gp << "splot '-' u 1:2:3:(2*distToPoint($1,$2,$3)/radius) w points pointtype 6 lc \"blue\" ps variable, "						\
		<< "'-' u 1:2:3:(distToPoint($1,$2,$3)/radius) w points pointtype 7 lc \"red\" ps variable; "								\
		<< "set xlabel '" << int(t*timeStep) << "'\n";																				\
		for(int gpmi=1; gpmi<=dCellsPresent; gpmi++){																					\
			if( t>dCellList[gpmi].get_entry_time()) {																					\
				dendx=dCellList[gpmi].get_dest_x(); dendy=dCellList[gpmi].get_dest_y(); dendz=dCellList[gpmi].get_dest_z();				\
				sourceX=dCellList[gpmi].get_source_x(); sourceY=dCellList[gpmi].get_source_y(); sourceZ=dCellList[gpmi].get_source_z();	\
				timeTaken = MAGNITUDE( (dendx-sourceX),(dendy-sourceY),(dendz-sourceZ) )/(timeStep*dCellVelocity);						\
				if(t-dCellList[gpmi].get_entry_time()<timeTaken) {UPDATE_POSITION_OF_MOVING_DC(gpmi);}									\
			}																															\
		}																																\
		dCellPartialList=vector<dCell>(dCellList.begin()+1, dCellList.begin()+dCellsPresentPerWave[waveNumber]+1);						\
		for(uint w=waveNumber+1; w<numWaves; w++){																									\
			dCellPartialList.insert(dCellPartialList.end(), dCellList.begin()+(w-waveNumber)*numDCells+1, dCellList.begin()+(w-waveNumber)*numDCells+dCellsPresentPerWave[w]+1);\
		}																																\
		gp.send1d(dCellPartialList);																									\
		gp.send1d(tCellList);
		//The "distToPoint" function calculates the distance to a given point, in order to choose its size. 
		// we splot (data) 1:2:3:size; this is the x,y and z coordinates, and the size of the point respectively. 
	#endif

	/*              ******             **
	*  Extra bits for static or linear  *
	**              ******             */
	#ifndef __RANDOM_FUNCTIONS_INCLUDED__
		//GNUPlot functions
			namespace gnuplotio { //Indicate to gnuplotio how it should handle objects of type "dCell" or "tCell"
			template<>
			struct BinfmtSender<dCell> {
				static void send(std::ostream &stream) {
					BinfmtSender<double>::send(stream);
					BinfmtSender<double>::send(stream);
					BinfmtSender<double>::send(stream);
				}
			};

			template<>
			struct BinfmtSender<tCell> {
				static void send(std::ostream &stream) {
					BinfmtSender<double>::send(stream);
					BinfmtSender<double>::send(stream);
					BinfmtSender<double>::send(stream);
				}
			};

			template<>
			struct BinarySender<dCell> {
				static void send(std::ostream &stream, const dCell &c) {
					BinarySender<double>::send(stream, c.get_x());
					BinarySender<double>::send(stream, c.get_y());
					BinarySender<double>::send(stream, c.get_z());
				}
			};

			template<>
			struct BinarySender<tCell> {
				static void send(std::ostream &stream, const tCell &c) {
					BinarySender<double>::send(stream, c.get_x());
					BinarySender<double>::send(stream, c.get_y());
					BinarySender<double>::send(stream, c.get_z());
				}
			};

			template<>
			struct TextSender<dCell> {
				static void send(std::ostream &stream, const dCell &c) {
					TextSender<double>::send(stream, c.get_x());
					stream << " ";
					TextSender<double>::send(stream, c.get_y());
					stream << " ";
					TextSender<double>::send(stream, c.get_z());
				}
			};

			template<>
			struct TextSender<tCell> {
				static void send(std::ostream &stream, const tCell &c) {
					TextSender<double>::send(stream, c.get_x());
					stream << " ";
					TextSender<double>::send(stream, c.get_y());
					stream << " ";
					TextSender<double>::send(stream, c.get_z());
				}
			};
		}
		#define PLOT_OPEN																											\
			Gnuplot gp;																												\
			vector<dCell> dCellPartialList;																							\
			if(plot){																												\
				gp << "thetax=60; thetaz=45; phix=thetax*pi/180; phiz=thetaz*pi/180;\n";											\
				gp << "distToPoint(x,y,z)=sqrt( (1.01+z)**2 * cos(phix)**2 + ((1.01+x)**2+(1.01-y)**2) * sin(phix)**2);\n";			\
				gp << "unset key; unset border; unset xtics; unset ytics; unset ztics; unset ylabel; unset zlabel\n";				\
				gp << "set ticslevel 0.0\n"; /*move z-axis down to join the x and y axes*/											\
				gp << "set view thetax,thetaz\n";																					\
				gp << "radius=" << radius << "\n";																					\
				gp << "set xrange [-radius:radius]; set yrange [-radius:radius]; set zrange [-radius:radius];\n";					\
				gp << "set parametric; set size ratio -1;\n";																		\
			}
	#endif

	/* ****** **
	*  Random  *
	** ****** */
	#if defined(__RANDOM_FUNCTIONS_INCLUDED__)
		//GNUPlot functions
		namespace gnuplotio { //Indicate to gnuplotio how it should handle objects of type "dCell" or "tCell"
			template<>
			struct BinfmtSender<cell> {
				static void send(std::ostream &stream) {
					BinfmtSender<double>::send(stream);
					BinfmtSender<double>::send(stream);
					BinfmtSender<double>::send(stream);
				}
			};

			template<>
			struct BinarySender<cell> {
				static void send(std::ostream &stream, const cell &c) {
					BinarySender<double>::send(stream, c.get_x());
					BinarySender<double>::send(stream, c.get_y());
					BinarySender<double>::send(stream, c.get_z());
				}
			};

			template<>
			struct TextSender<cell> {
				static void send(std::ostream &stream, const cell &c) {
					TextSender<double>::send(stream, c.get_x());
					stream << " ";
					TextSender<double>::send(stream, c.get_y());
					stream << " ";
					TextSender<double>::send(stream, c.get_z());
				}
			};
		}
		#define PLOT_OPEN																										\
			Gnuplot gp;																												\
			vector<cell> dCellPartialList;																							\
			if(plot){																												\
				gp << "thetax=60; thetaz=45; phix=thetax*pi/180; phiz=thetaz*pi/180;\n";											\
				gp << "distToPoint(x,y,z)=sqrt( (1.01+z)**2 * cos(phix)**2 + ((1.01+x)**2+(1.01-y)**2) * sin(phix)**2);\n";			\
				gp << "unset key; unset border; unset xtics; unset ytics; unset ztics; unset ylabel; unset zlabel\n";	\
				gp << "set ticslevel 0.0\n"; /*move z-axis down to join the x and y axes*/											\
				gp << "set view thetax,thetaz\n";																					\
				gp << "radius=" << radius << "\n";																					\
				gp << "set xrange [-radius:radius]; set yrange [-radius:radius]; set zrange [-radius:radius];\n";					\
				gp << "set parametric; set size ratio -1;\n";																		\
			}
		#define PLOT_CELLS																										\
			gp << "splot '-' u 1:2:3:(2*distToPoint($1,$2,$3)/radius) w points pointtype 6 lc \"blue\" ps variable, "					\
				<< "'-' u 1:2:3:(distToPoint($1,$2,$3)/radius) w points pointtype 7 lc \"red\" ps variable; "							\
				<< "set xlabel '" << int(t) << "'\n";																					\
			dCellPartialList=vector<cell>(dCellList.begin(), dCellList.begin()+dCellsPresentPerWave[waveNumber]);						\
			for(uint w=waveNumber+1; w<numWaves; w++){																					\
				dCellPartialList.insert(dCellPartialList.end(), dCellList.begin()+(w-waveNumber)*numDCells, dCellList.begin()+(w-waveNumber)*numDCells+dCellsPresentPerWave[w]);\
			}																															\
			gp.send1d(dCellPartialList);																								\
			gp.send1d(tCellList);
			//The "distToPoint" function calculates the distance to a given point, in order to choose its size. 
			// we splot (data) 1:2:3:size; this is the x,y and z coordinates, and the size of the point respectively. 
	#endif
//end IF GNUPLOT  
#else
	#include "glsc3d_3.h"
	#define WINDOW_SIZE 720
	#define T_RADIUS 5
	#define D_RADIUS 6
	G_COLOR DC_COLOUR (0.8705,0.8118,0.2471,1); //yellow. Note the numbers are 222,207,63 / 255
	G_COLOR DC_CONTACT_COLOUR (0.8705,0.8118,0.2471,0.3);
	G_COLOR T_COLOUR (0.9414,0.0313,0.3281,1); //red: 241,8,84 / 255
	G_COLOR ACTIVATED_COLOUR (0.3765,0.7412,0.4078,1); //Green: 96, 189, 104. Note that there's no variable in the class to use this :(.
	
	#define PLOT_MODE_TWO_SETUP																		\
		g_cls(); PLOT_DCS;																			\
		g_text_standard(0,20,"t: (FRZN). T-cell plot mode: %d. Zoom: %.1f. Theta: %.1fpi%s.|| Options: (1,2,up,down,r)",	\
		plotMode,ogl_zoom,fmod((ogl_theta/M_PI),2.),rotation_on?"++":"");								\
		// g_sphere_3D(0,0,0,radius, G_NO,G_YES);

	#define PARSE_INPUT																					\
		if (g_key_state('1') == G_DOWN){ 																\
			plotMode=1;																					\
		}																								\
		if (g_key_state('2') == G_DOWN){																\
			plotMode=2; PLOT_MODE_TWO_SETUP;															\
			for(uint ogt=0; ogt<numTCells; ogt++){														\
				oldTPos[ogt][0]=tCellList[ogt].get_x(); oldTPos[ogt][1]=tCellList[ogt].get_y(); oldTPos[ogt][2]=tCellList[ogt].get_z();\
			}																							\
		}																								\
		if (g_key_state(G_KEY_UP) == G_DOWN){															\
			ogl_zoom+=0.5;																				\
			g_vision(0, 6*radius*sin(ogl_theta), 4*radius, 6*radius*cos(ogl_theta), 0, 1, 0, ogl_zoom);	\
			if (plotMode==2) {PLOT_MODE_TWO_SETUP;}														\
		}																								\
		if (g_key_state(G_KEY_DOWN) == G_DOWN && ogl_zoom>1){											\
			ogl_zoom-=0.5;																				\
			g_vision(0, 6*radius*sin(ogl_theta), 4*radius, 6*radius*cos(ogl_theta), 0, 1, 0, ogl_zoom);	\
			if (plotMode==2) {PLOT_MODE_TWO_SETUP;}														\
		}																								\
		if (g_key_state('r') == G_DOWN){																\
			rotation_on=!rotation_on;																	\
		}																								\
		if (g_key_state(' ') == G_DOWN){																\
			g_paused=!g_paused;																			\
		}

	#define PLOT_OPEN                                               		\
		uint plotMode=1; /*1: re-plot all cells. 						*/	\
						 /*2: update plot with T-cell movement as paths.*/	\
		uint g_paused=0;													\
		if(plot==2){plot=1; g_paused=1;}									\
		double ogl_zoom=1.0, rotation_on=false;								\
		double ogl_theta=0;													\
		vector<vector<double> > oldTPos(numTCells,vector<double>(3));		\
		double go_ox,go_oy,go_oz, go_nx,go_ny,go_nz;						\
																			\
		if (plot){															\
			g_enable_highdpi(); 											\
			g_init("LN visualisation", WINDOW_SIZE, WINDOW_SIZE);       	\
																			\
			g_def_scale_3D(0,                                           	\
				-radius, radius, -radius, radius, -radius, radius, /*x0,x1,y0,y1,z0,z1*/ \
				-radius, radius, -radius, radius, -radius, radius, /*x,x1,y0,y1,z0,z1*/  \
				0, 0, WINDOW_SIZE, WINDOW_SIZE /*pos in openGL window*/ 	\
			);                                                          	\
			g_vision(0,                                                 	\
				6*radius*sin(ogl_theta), 4*radius, 6*radius*cos(ogl_theta), /*observer position*/ \
				0, 1, 0, /*direction observer faces*/						\
			ogl_zoom); /*zoom*/												\
																			\
			g_marker_type(G_MARKER_SPHERE);									\
			g_line_width(2); g_text_size(18);								\
			g_area_color(1,0.99,0.95,0.05); g_sel_scale(0);					\
		}
	// g_def_scale_2D(0, -radius, radius, -radius, radius,/*x0,x1,y0,y1*/	
	// 	0, 0, WINDOW_SIZE, WINDOW_SIZE); /*screen left,top,width,height*/
	// g_def_line(0, 0,0,0,1, 2, 0);/*id,rgba,width,type*/				
	// g_sel_scale(0); g_sel_line(0); /*selects scale for both 2D and 3D*/	
// in PLOT_CELLS -->	g_move_2D(-radius,1.1*radius); g_plot_2D(0,1.1*radius);/*'move' to start pos, 'plot' to end pos*/
	
	#define PLOT_CELLS																						\
		do{																									\
			PARSE_INPUT; /*Turn on/off rotation, change view, etc*/											\
																											\
			if (plotMode==1){																				\
				g_cls();																					\
				PLOT_DCS;																					\
				g_marker_radius(T_RADIUS); g_marker_color_s(T_COLOUR);										\
				for(uint ogt=0; ogt<numTCells; ogt++){														\
					if(OGL_IS_ACTIVATED(ogt)){g_marker_color_s(ACTIVATED_COLOUR);}							\
					else					{g_marker_color_s(T_COLOUR);}									\
					g_marker_3D(tCellList[ogt].get_x(), tCellList[ogt].get_y(), tCellList[ogt].get_z());	\
				}																							\
																											\
				g_sphere_3D(0,0,0,radius,/*centre (x,y,z) and radius)*/										\
				G_NO,G_YES); /*edge, fill*/																	\
				g_text_standard(0,20,"%st: %.1f. T-cell plot mode: %d. Zoom: %.1f. Theta: %.1fpi%s. || Options: (1,2,up,down,r)",	\
					(g_paused?"Paused. ":""),TIME,plotMode,ogl_zoom,fmod((ogl_theta/M_PI),2.),rotation_on?"++":"");			\
			}																								\
																											\
			else /*if (plotMode==2)*/{																		\
				g_line_color_s(T_COLOUR); g_line_width(3);													\
				for(uint ogt=0; ogt<numTCells; ogt++){														\
					go_ox=oldTPos[ogt][0]; go_oy=oldTPos[ogt][1]; go_oz=oldTPos[ogt][2];					\
					go_nx=tCellList[ogt].get_x(); go_ny=tCellList[ogt].get_y(); go_nz=tCellList[ogt].get_z();	\
					g_arrow_3D(go_ox,go_oy,go_oz, go_nx,go_ny,go_nz,/*start pos & direction*/				\
						MAGNITUDE((go_nx-go_ox),(go_ny-go_oy),(go_nz-go_oz)), 0, /*tail and head sizes*/	\
						G_NO,G_NO); /*wire frame and fill for head*/										\
					oldTPos[ogt][0]=go_nx; oldTPos[ogt][1]=go_ny; oldTPos[ogt][2]=go_nz; 					\
				}																							\
				g_line_color(0,0,0,1); g_line_width(2);														\
			}																								\
																											\
			if (rotation_on){																				\
				ogl_theta += M_PI/200;																		\
				g_vision(0,                                                 								\
					6*radius*sin(ogl_theta), 4*radius, 6*radius*cos(ogl_theta), /*observer position*/ 		\
					0, 1, 0, /*direction observer faces*/													\
				ogl_zoom); /*zoom*/																			\
			}																								\
			g_finish();																						\
		}while(g_paused);/*This runs at least once, even if g_paused is false*/	

	/* ****** **
	*  Static  *
	** ****** */
	#if !defined(__LINEAR_FUNCTIONS_INCLUDED__) && !defined(__RANDOM_FUNCTIONS_INCLUDED__)
		#define PLOT_DCS																				\
			g_marker_radius(D_RADIUS); g_marker_color_s(DC_COLOUR);										\
			for(int ogd=0; ogd<dCellsPresent; ogd++){													\
				/* double ogdca=dCellList[ogd].get_cog_antigen_ratio();		*/							\
				/* g_marker_color(0.8705*ogdca,0.8118*ogdca,0.2471*ogdca,1);*/							\
				g_marker_3D(dCellList[ogd].get_x(), dCellList[ogd].get_y(), dCellList[ogd].get_z());	\
			}																							\
			g_marker_radius(contactRadius); g_marker_color_s(DC_CONTACT_COLOUR);						\
			for(int ogd=0; ogd<dCellsPresent; ogd++){													\
				g_marker_3D(dCellList[ogd].get_x(), dCellList[ogd].get_y(), dCellList[ogd].get_z());	\
			}

		#define TIME (t*timeStep)
		#define OGL_IS_ACTIVATED(tCellNum) (!IS_IN_VECTOR(cellMovementOrder,tCellNum))
	#endif

	/* ****** **
	*  Linear  *
	** ****** */
	#if defined(__LINEAR_FUNCTIONS_INCLUDED__)
		#define PLOT_DCS																													\
			g_marker_radius(D_RADIUS); g_marker_color_s(DC_COLOUR);																			\
			for(int ogd=1; ogd<=dCellsPresent; ogd++){																						\
				if( t>dCellList[ogd].get_entry_time()) {																					\
					dendx=dCellList[ogd].get_dest_x(); dendy=dCellList[ogd].get_dest_y(); dendz=dCellList[ogd].get_dest_z();				\
					sourceX=dCellList[ogd].get_source_x(); sourceY=dCellList[ogd].get_source_y(); sourceZ=dCellList[ogd].get_source_z();	\
					timeTaken = MAGNITUDE( (dendx-sourceX),(dendy-sourceY),(dendz-sourceZ) )/(timeStep*dCellVelocity);						\
					if(t-dCellList[ogd].get_entry_time()<timeTaken) {UPDATE_POSITION_OF_MOVING_DC(ogd);}									\
				}																															\
																																			\
				g_marker_3D(dCellList[ogd].get_x(), dCellList[ogd].get_y(), dCellList[ogd].get_z());										\
			}																																\
																																			\
			g_marker_radius(contactRadius); g_marker_color_s(DC_CONTACT_COLOUR);															\
			for(int ogd=1; ogd<=dCellsPresent; ogd++){																						\
				g_marker_3D(dCellList[ogd].get_x(), dCellList[ogd].get_y(), dCellList[ogd].get_z());										\
			}
		
		#define TIME (t*timeStep)
		#define OGL_IS_ACTIVATED(tCellNum) (!IS_IN_VECTOR(cellMovementOrder,tCellNum))
	#endif

	/* ****** **
	*  Random  *
	** ****** */
	#if defined(__RANDOM_FUNCTIONS_INCLUDED__)
		#define PLOT_DCS																				\
			g_marker_radius(D_RADIUS); g_marker_color_s(DC_COLOUR);										\
			for(uint ogd=0; ogd<dCellsPresent; ogd++){													\
				g_marker_3D(dCellList[ogd].get_x(), dCellList[ogd].get_y(), dCellList[ogd].get_z());	\
			}																							\
			g_marker_radius(contactRadius); g_marker_color_s(DC_CONTACT_COLOUR);						\
			for(uint ogd=0; ogd<dCellsPresent; ogd++){													\
				g_marker_3D(dCellList[ogd].get_x(), dCellList[ogd].get_y(), dCellList[ogd].get_z());	\
			}
		
		#define TIME (t)
		#define OGL_IS_ACTIVATED(tCellNum) (tCellList[tCellNum].get_prob_activation())
			//n.b. recall that probActivation actually does mean activation state for T-cells, unlike for DCs
	#endif
#endif //end IF(GNUPLOT) ... ELSE