#include "parametersAndLibraries.h"
#include "randomFunctions.h"
// #include "graphicalOutput.h"

int simulation(double maxTime, uint numTimeMeasurements, vector<double> waveTimes, double radius, double contactRadius, double tCellAgSpecFreq, uint numTCells, uint numDCells, int numAntigenInContactArea, int numAntigenOnDC, int tCellActivationThreshold, double cogAgInDermis, double cogAgOnArrival, 
				double firstDCArrival, double DCArrivalDuration, double antigenDecayRate, double tVelocityMean, double tVelocityStDev, double tGammaShape, double tGammaScale, double dVelocityMean, double dVelocityStDev, double dGammaShape, 
				double dGammaScale, double tFreePathMean, double tFreePathStDev, double dFreePathMean, double dFreePathStDev, int seed, int numRepeats, int numChunks, MOMENT_TYPE *mom_numActivated, 
				int mom_max_numActivated, const int mom_tm_maxnumActivated, MOMENT_TYPE *mom_tCellDisplacementFromStart, int mom_max_tCellDisplacementFromStart, const int mom_tm_maxtCellDisplacementFromStart, 
				MOMENT_TYPE *mom_realTimeTaken, int mom_max_realTimeTaken, MOMENT_TYPE *mom_atLeastOneActivated, int mom_max_atLeastOneActivated, double *timeUntilFirstActivation, double *timeUntil25pcActivation, double *timeUntil50pcActivation, double *timeUntil75pcActivation, 
				double *timeUntil90pcActivation, double *timeUntil100pcActivation, int *numActivationsPerRepeat, int plot=0, double time_per_graphical_update=10) {
	int DEBUG_numCounts=0;
	//Output for analysis scripts' sake
	cout << "#Info: radius="					<< radius << endl;
	cout << "#Info: contactRadius=" 			<< contactRadius << endl;
	cout << "#Info: tCellAgSpecFreq="			<< tCellAgSpecFreq << endl;
	cout << "#Info: numTCells=" 				<< numTCells << endl;
	cout << "#Info: numDCells=" 				<< numDCells << endl;
	cout << "#Info: numAntigenInContactArea="	<< numAntigenInContactArea << endl;
	cout << "#Info: numAntigenOnDC="			<< numAntigenOnDC << endl;
	cout << "#Info: tCellActivationThreshold="	<< tCellActivationThreshold << endl;
	cout << "#Info: cogAgInDermis="				<< cogAgInDermis << endl;
	cout << "#Info: cogAgOnArrival="			<< cogAgOnArrival << endl;
	// cout << "#Info: cognateAgRatioStDev="		<< cognateAntigenRatioStDev << endl;
	cout << "#Info: firstDCArrival="			<< firstDCArrival << endl;
	cout << "#Info: DCArrivalDuration="			<< DCArrivalDuration << endl;
	cout << "#Info: antigenDecayRate="			<< antigenDecayRate << endl;
	#ifdef _GAUSS_
		cout << "#Info: VelocityDistribution: gaussian" << endl;
		cout << "#Info: tVelocityMean="				<< tVelocityMean << endl;
		cout << "#Info: tVelocityStDev="			<< tVelocityStDev << endl;
		cout << "#Info: dVelocityMean="				<< dVelocityMean << endl;
		cout << "#Info: dVelocityStDev="			<< dVelocityStDev << endl;
	#else
		cout << "#Info: VelocityDistribution: gamma" << endl;
		cout << "#Info: tVelocityMean="				<< tVelocityMean << endl;
		cout << "#Info: tVelocityStDev="			<< sqrt(tGammaShape*tGammaScale*tGammaScale) << endl;
		cout << "#Info: dVelocityMean="				<< dVelocityMean << endl;
		cout << "#Info: dVelocityStDev="			<< sqrt(dGammaShape*dGammaScale*dGammaScale) << endl;
	#endif
	cout << "#Info: tFreePathMean="				<< tFreePathMean << endl;
	cout << "#Info: tFreePathStDev="			<< tFreePathStDev << endl;
	cout << "#Info: dFreePathMean="				<< dFreePathMean << endl;
	cout << "#Info: dFreePathStDev="			<< dFreePathStDev << endl;
	cout << "#Info: seed=" 						<< seed << endl;
	cout << "#Info: numTimeMeasurements="		<< numTimeMeasurements << endl;
	cout << "#Info: maxTime="					<< maxTime << endl;
	cout << "#Info: numWaves="					<< waveTimes.size() << endl;
	cout << "#Info: waveTimes=";				for (auto e: waveTimes) cout << e << ","; cout << endl;
	cout << "#Info: numRepeats=" 				<< numRepeats << endl;
	cout << "#Info: numChunks=" 				<< numChunks << endl;

	//More parameters used to hold data later
	double t=0,told=0, x=0,y=0,z=0, dx,dy,dz, dx2,dy2,dz2, ox,oy,oz, l_ox,l_oy,l_oz, unx,uny,unz, M_q=0,M_r=0, vx,vy,vz, dvx,dvy,dvz, ovx,ovy,ovz, l_ovx,l_ovy,l_ovz, sourceX,sourceY,sourceZ,
			M_vp, vmag,theta,phi, magsq, dist, cognateAgPrecision, minimumCognateAg=0, 
			cellSide=4*contactRadius, /*WARNING: this "4*" is used in a hard-coded fashion elsewhere*/ leftOverlap=1.0*contactRadius/cellSide, rightOverlap=1.0*(cellSide-contactRadius)/cellSide, 
			diffFromCoord, mfp=0, xivi,vivi, etime, etime2, spheretime,
			activationTimeLimit=maxTime, timeBetweenDCArrival = (numDCells>1)?1.0*(DCArrivalDuration)/(numDCells-1):0;//e.g. with a time gap of 6 hours, 11 DCs will arrive at 0, 0.6, 1.2, ... 5.4, 6.0.
	int inContact=0, cognateAgProbabilityTable_size, cx=0,cy=0,cz=0, ocx,ocy,ocz, M_cp,M_cq,M_cr, printProgressIndicator=0, numPositions= 2*radius/cellSide+1, 
		numPositionsSq=numPositions*numPositions, occupiedPositionsArraySize = numPositions*numPositions*numPositions, ind;
	unsigned int cellNum, oCellNum, eventType,cellType,dir,wav,oldEventListSize, inddist, dCellsPresent=0, posFailures=0, this_numActivated=0, timeMeasurementsTaken=0,
		maxSimultaneousDCs=numDCells, numWaves=waveTimes.size(), waveNumber=0, numWavesToRegen=0;
	vector<uint> dCellsPresentPerWave(numWaves); for(uint i=0; i<numWaves; i++) dCellsPresentPerWave[i]=0;
	vector<double> radialVec, parallel, reflectedVec, position, velocity;
	double *cognateAgProbabilityTable;
	clock_t repeatStart, repeatEnd;
	vector<vector<uint> > dSites(occupiedPositionsArraySize), tSites(occupiedPositionsArraySize); vector<vector<uint> > *otherSites=NULL, *cellSites=NULL; 
	eventTime *thisEvent;

	vector<uint> *vecIt, nearbyPartners, nearbyDCs; vector<eventTime> eventList;
	vector<double> tCellInitialX(numTCells),tCellInitialY(numTCells),tCellInitialZ(numTCells);
	int localNeighbourhood[27], Ones[27]; for(int i=0; i<27; i++) Ones[i]=1;
	int localNeigh2D[9], Ones2D[9]; for(int i=0; i<9; i++) Ones2D[i]=1; 
	auto entryExitLam = [&] (int j,int k){
		if(dir==X_POS)		return THREED_TO_ONED(M_cp,M_cq+j-1,M_cr+k-1);
	 	else if(dir==X_NEG)	return THREED_TO_ONED(M_cp,M_cq+j-1,M_cr+k-1);
	 	else if(dir==Y_POS)	return THREED_TO_ONED(M_cq+j-1,M_cp,M_cr+k-1);
	 	else if(dir==Y_NEG)	return THREED_TO_ONED(M_cq+j-1,M_cp,M_cr+k-1);
	 	else if(dir==Z_POS)	return THREED_TO_ONED(M_cq+j-1,M_cr+k-1,M_cp);
	 	else if(dir==Z_NEG)	return THREED_TO_ONED(M_cq+j-1,M_cr+k-1,M_cp);
	 	else return -1;//For compiler warnings.
	 };
	
	//Declare variables for plotting, then send commands if needed
	PLOT_OPEN;

	//Find lookup table for the probability of activation given ratio of cognate antigen; make one if it is not present
	char CALTFilename[400]; snprintf(CALTFilename, sizeof(CALTFilename), "%s_%d_%d.dat", COGNATE_ANTIGEN_RATIO_LOOKUP_TABLE_PREFIX, numAntigenInContactArea, tCellActivationThreshold);
	if(fileExists(CALTFilename)){
		cout << "#Reading file " << CALTFilename << " for cognate antigen ratio probability table." << endl;
		if(readLookupTable(CALTFilename, cognateAgPrecision, cognateAgProbabilityTable_size, &cognateAgProbabilityTable)) return 1;
	}
	else{
		cout << "#Could not find file " << CALTFilename << ", generating cognate antigen ratio probability table." << endl;
		if(generateLookupTable(CALTFilename, numAntigenOnDC, numAntigenInContactArea, tCellActivationThreshold)) return 1;
		if(readLookupTable(CALTFilename, cognateAgPrecision, cognateAgProbabilityTable_size, &cognateAgProbabilityTable)) return 1; //A waste of time, but the time involved is miniscule so I care not	
	}
	for(int i=0; i<cognateAgProbabilityTable_size; i++) if(cognateAgProbabilityTable[i]<PROBABILITY_TOLERANCE) minimumCognateAg=cognateAgPrecision*i; //Find also the cognate ag ratio corresponding to our effective zero probability

	//We have the value for the largest amount of cognate antigen on any DC. We can use this to say when the LN cannot activate any T cells anymore.
	if(cogAgOnArrival>minimumCognateAg && minimumCognateAg!=0 && antigenDecayRate!=0) activationTimeLimit = log(cogAgOnArrival/minimumCognateAg)/(antigenDecayRate); 
	else if(cogAgOnArrival<minimumCognateAg)		activationTimeLimit = 0;
	else					activationTimeLimit = maxTime;
	cout << "#Data_cognateAntigenThresholdAndTime: " << minimumCognateAg << " " << activationTimeLimit << "/" << maxTime << endl;

	//If multiple doses are being administered, check if any of them will overlap. If so, the memory required to place all the DCs at once will be increased.
	uint maxOverlap=0;
	for(uint s1=0; s1<waveTimes.size(); s1++){
		for(uint s2=s1+1; s2<waveTimes.size(); s2++){
			if (waveTimes[s2]-waveTimes[s1] > activationTimeLimit) break;
			maxOverlap = (s2-s1>maxOverlap) ? s2-s1 : maxOverlap;
		}
	}
	maxSimultaneousDCs=(maxOverlap+1)*numDCells;

	//Cell arrays
	vector<cell> tCellList(numTCells, cell(TCELL_TYPE)); vector<cell> dCellList(maxSimultaneousDCs, cell(DCELL_TYPE)); vector <cell> *cellList=NULL, *otherList=NULL;

	//Start random num generator
	mt19937_64 engine(seed); //Random number generator (Mersenne Twister) initialised with seed
	uniform_int_distribution<int> genrand_int(0,1); //generates 1 or 0
	uniform_real_distribution<double> genrand_uniform_posneg(-1,1); //generates doubles between -1 and 1
	uniform_real_distribution<double> genrand_uniform_pos(0,1);
	#ifdef _GAUSS_
		normal_distribution<double> genrand_tc_velocity(tVelocityMean, tVelocityStDev);
		normal_distribution<double> genrand_dc_velocity(dVelocityMean, dVelocityStDev);
	#else
		gamma_distribution<double> genrand_tc_velocity(tGammaShape,tGammaScale);
		gamma_distribution<double> genrand_dc_velocity(dGammaShape,dGammaScale);
	#endif
	normal_distribution<double> genrand_tc_freepath(tFreePathMean, tFreePathStDev);
	normal_distribution<double> genrand_dc_freepath(dFreePathMean, dFreePathStDev);
	
	//Loop over "chunks": we will output data after each of these, in case of many repeats.
	for(int chunk=0; chunk<numChunks; chunk++){
		//Reinitialise moments once per chunk
		MOMENT_TM_INIT(numActivated);
		MOMENT_TM_INIT(tCellDisplacementFromStart);
		MOMENT_INIT(realTimeTaken);
		MOMENT_INIT(atLeastOneActivated);

		for(int repeat=0; repeat<numRepeats; repeat++){
			repeatStart=clock();
			if(numChunks>1 && numRepeats>1) {cerr << "#c=" << chunk << "/" << numChunks << ",";}
			if(numRepeats>1) {cerr << "r=" << repeat << "/" << numRepeats << "\t";}
			//Reinitialise number of activated t-cells and positions of all cells
			this_numActivated=0; t=0; timeMeasurementsTaken=0; waveNumber=0; eventList.clear();
			if(repeat>0){
				for(int i=0; i<occupiedPositionsArraySize; i++){
					tSites[i].clear(); //clear() is marginally faster than setting equality to an empty container. This loop still makes it slow, however.
					dSites[i].clear();
				}
			}

			REGENERATE_CELL_POSITIONS_AND_ANTIGEN(int(maxSimultaneousDCs/numDCells))

			// cout << "Initial events list: " << endl;
			// for (auto e: eventList) cout << "\t" << e << endl; cout << "*" << endl;
			//Move cells until end of time
			while (t<maxTime){
				//Progress indicator
				if(t/(0.01*maxTime)>printProgressIndicator){
					cerr << t << "\t"; printProgressIndicator++;
				}
				
				//Get details of current event
				oldEventListSize=eventList.size();
				t=eventList.back().getTime(); 
				eventType=eventList.back().getEventType();
				cellType=eventList.back().getCellType();
				cellNum=eventList.back().getCellNum();
				
				//Error checking
				if(t<0){
					cout << "Time of next event is less than 0. Aborting." << endl;
					for (auto e: eventList) {cout << "\t" << e << endl;} cerr << endl;
					return 5;
				}
	
				// cout << (cellType==TCELL_TYPE?"T":"D") << cellNum << " event: ";
				// switch (eventType){
				// 	case VEL_CHANGE_EVENT:
				// 		cout << "Velocity change" << endl;
				// 		break;

				// 	case SPHERE_EDGE_EVENT:
				// 		cout << "Sphere reflection" << endl;
				// 		break;

				// 	case INTERACT_EVENT:
				// 		cout << "Interaction w/" << eventList.back().getPartnerCellNum() << endl;
				// 		break;

				// 	case DC_INTERACT_EVENT:
				// 		cout << "DC interaction w/" << eventList.back().getPartnerCellNum() << endl;
				// 		break;

				// 	case ENTER_POS_EVENT:
				// 		cout << "Enter new site" << endl;
				// 		break;

				// 	case LEAVE_POS_EVENT:
				// 		cout << "Leave site" << endl;
				// 		break;

				// 	case DC_ENTRY_EVENT:
				// 		cout << "New DC" << endl;
				// 		break;

				// case UNSET_FAILURE_ID_EVENT:
				// 	cout << "Unset failure ID" << endl;
				// 	break;

				// 	case MEASURE_OBSERVABLES_EVENT:
				// 		cout << "Measuring observables" << endl;
				// 		break;

				// 	case GRAPHICAL_UPDATE_EVENT:
				// 		cout << "Graphical update" << endl;
				// 		break;

				// 	default:
				// 		cout << "???";
				// 		return 2;	
				// }
				
				if(cellType!=NOTCELL_TYPE){
					if(cellType==TCELL_TYPE){cellList=&tCellList; otherList=&dCellList; cellSites=&tSites; otherSites=&dSites;}
					else					{cellList=&dCellList; otherList=&tCellList; cellSites=&dSites; otherSites=&tSites;}
					
					//Get current position and velocity.
					told=(*cellList)[cellNum].get_time_position_updated();
					x=(*cellList)[cellNum].get_x(); 	y=(*cellList)[cellNum].get_y();	z=(*cellList)[cellNum].get_z();
					vx=(*cellList)[cellNum].get_vx();	vy=(*cellList)[cellNum].get_vy();	vz=(*cellList)[cellNum].get_vz();

					//Calculate change, then update position & remaining MFP.
					dx=vx*(t-told);  dy=vy*(t-told); dz=vz*(t-told);
					x+=dx; y+=dy; z+=dz; (*cellList)[cellNum].set_position(t,x,y,z); cx=COORD(x);cy=COORD(y);cz=COORD(z);
					mfp=(*cellList)[cellNum].reduce_free_path_remaining(MAGNITUDE(dx,dy,dz));
				}

				if(eventType==VEL_CHANGE_EVENT){
					CHANGE_VELOCITY((*cellList), cellType,cellNum, vx,vy,vz,mfp,vmag);
					ADD_EVENTS_AFTER_VELOCITY_CHANGE((*cellList),(*otherList),(*cellSites),(*otherSites), cellType,cellNum, t, x,y,z,cx,cy,cz, vx,vy,vz,mfp,vmag);
				}
				else if(eventType==SPHERE_EDGE_EVENT){
					REFLECT_FROM_SPHERE_EDGE((*cellList), cellType, cellNum, x,y,z,vx,vy,vz,mfp);
					ADD_EVENTS_AFTER_VELOCITY_CHANGE((*cellList),(*otherList),(*cellSites),(*otherSites), cellType,cellNum, t, x,y,z,cx,cy,cz, vx,vy,vz,mfp,vmag);
				}
				else if(eventType==INTERACT_EVENT){
					etime=t+0.001; //Nudge to avoid issues with numerical accuracy
					x+=vx*(etime-t); y+=vy*(etime-t); z+=vz*(etime-t);

					//Get position and velocity of the partner cell
					oCellNum=eventList.back().getPartnerCellNum();
					told=(*otherList)[oCellNum].get_time_position_updated();
					ox=(*otherList)[oCellNum].get_x();		oy=(*otherList)[oCellNum].get_y();		oz=(*otherList)[oCellNum].get_z();
					ovx=(*otherList)[oCellNum].get_vx();	ovy=(*otherList)[oCellNum].get_vy();	ovz=(*otherList)[oCellNum].get_vz();

					//Update them
					dx=ovx*(etime-told);  dy=ovy*(etime-told); dz=ovz*(etime-told);
					ox+=dx; oy+=dy; oz+=dz; (*otherList)[oCellNum].set_position(etime,ox,oy,oz);
					mfp=(*otherList)[oCellNum].reduce_free_path_remaining(MAGNITUDE(dx,dy,dz));
					if( SQMAGNITUDE(ox-x, oy-y, oz-z)<=contactRadius*contactRadius){
						//The distinction between cell types is now important, so define the DC as the 'partner' cell
						ocx=COORD(ox); ocy=COORD(oy); ocz=COORD(oz);
						if(cellType==TCELL_TYPE) 	ATTEMPT_INTERACTION(tCellList,dCellList,tSites,dSites, cellNum,oCellNum, x,y,z,ox,oy,oz, cx,cy,cz, ocx,ocy,ocz, vx,vy,vz)
						else 						ATTEMPT_INTERACTION(tCellList,dCellList,tSites,dSites, oCellNum,cellNum, ox,oy,oz,x,y,z, ocx,ocy,ocz, cx,cy,cz, vx,vy,vz)
					}
				}
				else if(eventType==DC_INTERACT_EVENT){
					etime=t+0.001; //Nudge to avoid issues with numerical accuracy
					//Get position and velocity of the partner cell
					oCellNum=eventList.back().getPartnerCellNum();
					told=(*cellList)[oCellNum].get_time_position_updated();
					ox=(*cellList)[oCellNum].get_x();	oy=(*cellList)[oCellNum].get_y();	oz=(*cellList)[oCellNum].get_z();
					ovx=(*cellList)[oCellNum].get_vx();	ovy=(*cellList)[oCellNum].get_vy();	ovz=(*cellList)[oCellNum].get_vz();

					//Update them
					dx=ovx*(etime-told);  dy=ovy*(etime-told); dz=ovz*(etime-told);
					ox+=dx; oy+=dy; oz+=dz; (*cellList)[oCellNum].set_position(etime,ox,oy,oz);
					mfp=(*cellList)[oCellNum].reduce_free_path_remaining(MAGNITUDE(dx,dy,dz));
					
					if( SQMAGNITUDE(ox-x, oy-y, oz-z)<=contactRadius*contactRadius){
						//The distinction between cell types is now important, so define the DC as the 'partner' cell
						ocx=COORD(ox); ocy=COORD(oy); ocz=COORD(oz);
						DC_INTERACTION(dCellList,dSites, cellNum,oCellNum, x,y,z,ox,oy,oz, cx,cy,cz, ocx,ocy,ocz, vx,vy,vz);
					}
				}
				else if(eventType==ENTER_POS_EVENT){
					dir=eventList.back().getSiteChangeDirection();
					vmag=MAGNITUDE(vx,vy,vz);
					CONTACT_NEW_GRID_CELLS((*cellList),(*otherList),(*cellSites),(*otherSites), cellType,cellNum, t, x,y,z, vx,vy,vz, dir,mfp,vmag);
				}
				else if(eventType==LEAVE_POS_EVENT){
					dir=eventList.back().getSiteChangeDirection();
					vmag=MAGNITUDE(vx,vy,vz);
					LEAVE_GRID_CELLS((*cellSites), cellType,cellNum, t, x,y,z, vx,vy,vz, dir,mfp,vmag);
				}
				else if(eventType==DC_ENTRY_EVENT){
					wav=eventList.back().getCellNum(); cellNum=(wav-waveNumber)*numDCells+dCellsPresentPerWave[wav]; //e.getCellNum() is not actually a cellNum here, we used it to hold the value of the wave
					if(USING_SOURCE) {ADD_DC_TO_SIMULATION_AT_SOURCE(dCellList,tCellList,dSites,tSites, cellNum, t, x,y,z,cx,cy,cz, vx,vy,vz, mfp,vmag);}
					else {ADD_DC_TO_SIMULATION_AT_RANDOM(dCellList,tCellList,dSites,tSites, cellNum, t, x,y,z,cx,cy,cz, vx,vy,vz, mfp,vmag);}
					dCellsPresent++; dCellsPresentPerWave[wav]++;
					dCellList[cellNum].set_timeAntigenUpdated(waveTimes[wav]);	
					if(dCellsPresentPerWave[wav]<numDCells) eventList.push_back(eventTime(t+timeBetweenDCArrival,DC_ENTRY_EVENT,wav));
				}
				else if(eventType==DC_DEATH_EVENT){
					wav=eventList.back().getCellNum();
					numWavesToRegen=int((dCellsPresent-1)/numDCells)+1; //Needed if we are going to be skipping time. e.g. have only a single complete wave -> get 0+1. have an incomplete wave -> also get 0+1. have two simultaneous waves -> get 1+1.
					dCellsPresent-=dCellsPresentPerWave[wav]; 
					dCellsPresentPerWave[wav]=0; //the overall dCellsPresent number will be reduced below
					//Check consecutive waves until we've found we're not passed the activation limit of
					while(t>=waveTimes[waveNumber]+activationTimeLimit-1e-6 && waveNumber<numWaves) waveNumber++; 
					
					//If we haven't already begun this wave, increase time and regenerate all cells
					if (waveNumber!=numWaves && t<waveTimes[waveNumber]){ 
						for(; timeMeasurementsTaken<=waveTimes[waveNumber]*numTimeMeasurements/maxTime; timeMeasurementsTaken++){
							MOMENT_TM(numActivated, this_numActivated, timeMeasurementsTaken);
						}
						for(int i=0; i<occupiedPositionsArraySize; i++){
							tSites[i].clear(); //clear() is marginally faster than setting equality to an empty container. This loop still makes it slow, however.
							dSites[i].clear();
						}
						eventList.clear();	
						REGENERATE_CELL_POSITIONS_AND_ANTIGEN(numWavesToRegen); //Regen DC positions and randomise T-cells to avoid them
						continue;
						// t=waveTimes[waveNumber]; //-1 because it will suffer a t++ at the end of this loop
					}

					//Else, remove the old cells and continue as before
					else if(waveNumber!=numWaves){
						//Loop through all events and remove the ones corresponding to the cells we just deleted, else reduce the cell index on other events
						vector<cell>(dCellList.begin()+numDCells,dCellList.end()).swap(dCellList); //Form a temporary vector which is missing the first numDCells elements and swap with our own
						dCellList.resize(dCellList.size()+numDCells, cell(DCELL_TYPE)); //add back empty elements onto the end
						for(int i=0; i<occupiedPositionsArraySize; i++) dSites[i].clear(); //Clear discrete grid and form it anew
						while((inddist=uint(distance(
								eventList.begin(), find_if(
									eventList.begin()+inddist,eventList.end(),[=](eventTime &et){
										return et.getCellType()==DCELL_TYPE || et.getEventType()==INTERACT_EVENT;
									}
								)
							)
						))!=eventList.size()) {
							thisEvent=&eventList[inddist];
							//If the event is concerning a now-dead DC, or is an interaction with one, delete it 
							if( ((*thisEvent).getEventType()==INTERACT_EVENT && (*thisEvent).getPartnerCellNum()<numDCells) || ((*thisEvent).getCellNum()<numDCells) ){
								if(inddist+1==oldEventListSize) {inddist++; continue;}/*Note that we do NOT remove the event if it is the current (last) one, as it will be removed at the end of the time loop.*/
								if(eventList.size()==oldEventListSize) oldEventListSize=inddist+1; /*If we move the current event, keep track of it for deletion later*/
								(*thisEvent)=eventList.back(); eventList.pop_back();
							}
							//Else, reduce index of interaction partners that are still-living DCs...
							else if((*thisEvent).getEventType()==INTERACT_EVENT){
								(*thisEvent).changePartnerCellNum((*thisEvent).getPartnerCellNum()-numDCells);
								if ((*thisEvent).getCellType()==DCELL_TYPE) (*thisEvent).changeCellNum((*thisEvent).getCellNum()-numDCells);
							}
							//...and reduce the index of all events concerning the still-living DCs. 
							else (*thisEvent).changeCellNum((*thisEvent).getCellNum()-numDCells);
						}
						//Reform discrete grid
						for(uint dcnum=0; dcnum<dCellsPresent; dcnum++){
							x=dCellList[dcnum].get_x(); y=dCellList[dcnum].get_y(); z=dCellList[dcnum].get_z(); 
							cx=COORD(x); cy=COORD(y); cz=COORD(z);
							CALCULATE_CONTACTABLE_GRID_SITES(x,y,z,cx,cy,cz);
							for(int i=0; i<3; i++){
								if(cx+i-1 >= numPositions) {break;}
								else if(cx+i-1 < 0) {continue;}

								for(int j=0; j<3; j++){
									if(cy+j-1 >= numPositions) {break;}
									else if(cy+j-1 < 0) {continue;}

									for(int k=0; k<3; k++){
										if(cz+k-1 >= numPositions) {break;}
										else if(cz+k-1 < 0) {continue;}
										if(localNeighbourhood[i+3*j+9*k]==1){
											dSites[THREED_TO_ONED(cx+i-1,cy+j-1,cz+k-1)].push_back(dcnum);
										}
									}
								}
							}
							//ADD_EVENTS_AFTER_VELOCITY_CHANGE(dCellList,tCellList,dSites,tSites, DCELL_TYPE,dcnum, tim, x,y,z,cx,cy,cz, vx,vy,vz,mfp,vmag);
						}
					}
				}
				else if(eventType==UNSET_FAILURE_ID_EVENT){
					(*cellList)[cellNum].unset_failed_interaction_ID();
				}
				else if(eventType==MEASURE_OBSERVABLES_EVENT){
					MOMENT_TM(numActivated, this_numActivated, timeMeasurementsTaken);
					for(uint tc=0; tc<numTCells; tc++){
						if(tCellList[tc].TC_get_activation_state()==0){
							told=tCellList[tc].get_time_position_updated();
							x=tCellList[tc].get_x();	y=tCellList[tc].get_y();	z=tCellList[tc].get_z();
							vx=tCellList[tc].get_vx();	vy=tCellList[tc].get_vy();	vz=tCellList[tc].get_vz();
							x+=vx*(t-told);  y+=vy*(t-told); z+=vz*(t-told);
							dist = MAGNITUDE( x-tCellInitialX[tc],y-tCellInitialY[tc],z-tCellInitialZ[tc] );
							MOMENT_TM(tCellDisplacementFromStart, dist, timeMeasurementsTaken);
						}
					}
					timeMeasurementsTaken++; //Can't do this inside a macro, or it would happen multiple times
					eventList.push_back(eventTime(t+maxTime/numTimeMeasurements,MEASURE_OBSERVABLES_EVENT));
				}
				else if(eventType==GRAPHICAL_UPDATE_EVENT){
					PLOT_CELLS;
					eventList.push_back(eventTime(t+time_per_graphical_update,GRAPHICAL_UPDATE_EVENT));
				}
				else{ cerr << "Critical error: unknown event type " << eventType << ". Aborting." << endl; return 2; }
				
				//Remove this event by overwriting its position in the list with the end element, before popping the end of the list.
				// cout << "Old event list size == " << oldEventListSize << "-> deleting element [" << oldEventListSize-1 << "] == " << eventList[oldEventListSize-1] << " by popping " << eventList.back() << endl;
				eventList[oldEventListSize-1]=eventList.back(); eventList.pop_back();
				sort(eventList.begin(), eventList.end());
				// cout << "Events list: " << endl;
				// for (auto e: eventList) cout << "\t" << e << endl; cout << endl << "*" << endl;	

				//Break if we have exhausted all of the t-cells or the DCs are out of cognate antigen
				if(this_numActivated==numTCells || t>waveTimes.back()+activationTimeLimit){
					for(; timeMeasurementsTaken<numTimeMeasurements; timeMeasurementsTaken++){
						MOMENT_TM(numActivated, this_numActivated, timeMeasurementsTaken);
					}
					cerr << "exitTime=" << t << "/" << activationTimeLimit << "/" << maxTime;
					break;
				}

				//Error checking
				if (t/0.05 > DEBUG_numCounts && dCellList.size()>0){
					DEBUG_numCounts++;
					//Make sure the first T and D cells aren't in contact
					x=tCellList[0].get_x(); y=tCellList[0].get_y(); z=tCellList[0].get_z(); ox=dCellList[0].get_x(); oy=dCellList[0].get_y(); oz=dCellList[0].get_z();
					vx=tCellList[0].get_vx(); vy=tCellList[0].get_vy(); vz=tCellList[0].get_vz(); ovx=dCellList[0].get_vx(); ovy=dCellList[0].get_vy(); ovz=dCellList[0].get_vz();				
					told=tCellList[0].get_time_position_updated(); x+=vx*(t-told); y+=vy*(t-told); z+=vz*(t-told);
					told=dCellList[0].get_time_position_updated(); ox+=ovx*(t-told); oy+=ovy*(t-told); oz+=ovz*(t-told); 
					dx=x-ox; dy=y-oy; dz=z-oz; dvx=vx-ovx; dvy=vy-ovy; dvz=vz-ovz;
					if(SQMAGNITUDE(x-ox,y-oy,z-oz)<=contactRadius*contactRadius){
						if(t>0 && tCellList[0].TC_get_activation_state()==0 && tCellList[0].get_failed_interaction_ID()!=0 //It is possible for this to occur legitimately at t=0 on a repeat after the first, since the first MEASURE_OBSERVABLES event is before the first DC is placed, so need t>0
							&& (t-tCellList[0].get_time_position_updated())*MAGNITUDE(vx,vy,vz) < tCellList[0].get_free_path_remaining() //If the mean free path ran out before this contact would occur, there's a good reason the program did not detect it
							&& (t-told)*MAGNITUDE(ovx,ovy,ovz) < dCellList[0].get_free_path_remaining()){ 
								cout << "Cells are in contact at chunk " << chunk << ", repeat " << repeat << ", time " << t << ", with positions " << x << "," << y << "," << z << " and " << ox << "," << oy << "," << oz << "; however, the program did not detect this. Aborting." << endl;
								for(auto e: eventList) {cout << "\t" << e << endl;} cout << endl;
								return 4;
						}
					}
					
				// //Make sure that the first T and D cell are contacting the sites to the their left and right (in x) when they should be
				// 	//Output time and events
				// 	bool DEBUG_exit=false;
				// 	cout << "***********************************************"<<endl<<"t="<<t<<endl;
				// 	for(auto e: eventList) cout << "\t" << e << endl; cout << endl;
				// 	x=tCellList[0].get_x(); y=tCellList[0].get_y(); z=tCellList[0].get_z();
				// 	cx=COORD(x); cy=COORD(y); cz=COORD(z);
				// 	cout << "T: " << x << "," << y << "," << z << "(" << cx << "," << cy << "," << cz << ")" << endl;
				// 	if(cx!=0 && (cellSide*(cx+0.25)-x-radius)>0 && !IS_IN_VECTOR(tSites[THREED_TO_ONED(cx-1,cy,cz)],0)){
				// 		if( !( abs(cellSide*(cx+0.25)-x-radius)<1E-6) && tCellList[0].get_vx()>0 ){
				// 			cout << "T not entered site to left at t=" << t << " and coordinates " << x << "," << y << "," << z << "(" << cx << "," << cy << "," << cz << ")" << endl;
				// 			DEBUG_exit=true;
				// 		}
				// 	}
				// 	else if(cx!=numPositions-1 && (cellSide*(cx+0.75)-x-radius)<0 && !IS_IN_VECTOR(tSites[THREED_TO_ONED(cx+1,cy,cz)],0)){
				// 		if( !( abs(cellSide*(cx+0.75)-x-radius)<1E-6) && tCellList[0].get_vx()<0 ){
				// 			cout << "T not entered site to right at t=" << t << " and coordinates " << x << "," << y << "," << z << "(" << cx << "," << cy << "," << cz << ")" << endl;
				// 			DEBUG_exit=true;
				// 		}
				// 	}
				// 	for (int cq=cy-1; cq<=cy+1; cq++){
				// 		if (cq>=numPositions) break;
				// 		else if(cq<0) continue;
				// 		for(int cr=cz-1; cr<=cz+1; cr++){
				// 			if (cr>=numPositions) break;
				// 			else if(cr<0) continue;
				// 			for(int cp=cx-1; cp<=cx+1; cp++){
				// 				if (cp>=numPositions) break;
				// 				else if(cp<0) continue;
				// 				if(!IS_IN_VECTOR(tSites[THREED_TO_ONED(cp,cq,cr)],0)){
				// 					if (cp==cx && cq==cy && cr==cz){
				// 						DEBUG_exit=true;
				// 						cout << "! ";
				// 					}
				// 					else cout << "* "; 
				// 				} 
				// 				else cout << "T ";
				// 			}
				// 			cout << "\t";
				// 		}
				// 		cout << "\n";
				// 	}
				// 	if(DEBUG_exit){
				// 		cout << "---\nT not in a site at t=" << t << " and coordinates " << x << "," << y << "," << z << "(" << cx << "," << cy << "," << cz << ")" << endl;
				// 		for(auto e: eventList) cout << "\t" << e << endl; cout << endl;
				// 		return 1;
				// 	}
				// 	cout << "\n";

				// 	x=dCellList[0].get_x(); y=dCellList[0].get_y(); z=dCellList[0].get_z();
				// 	cx=COORD(x); cy=COORD(y); cz=COORD(z);
				// 	cout << "D: " << x << "," << y << "," << z << "(" << cx << "," << cy << "," << cz << ")" << endl;
				// 	if(cx!=0 && (cellSide*(cx+0.25)-x-radius)>0 && !IS_IN_VECTOR(dSites[THREED_TO_ONED(cx-1,cy,cz)],0)){
				// 		if ( !( abs(cellSide*(cx+0.25)-x-radius)<1E-6) && dCellList[0].get_vx()>0 ){
				// 			cout << "D not entered site to left at t=" << t << " and coordinates " << x << "," << y << "," << z << "(" << cx << "," << cy << "," << cz << ")" << endl;
				// 			DEBUG_exit=true;
				// 		}
				// 	}
				// 	else if(cx!=numPositions-1 && (cellSide*(cx+0.75)-x-radius)<0 && !IS_IN_VECTOR(dSites[THREED_TO_ONED(cx+1,cy,cz)],0)) {
				// 		if ( !( abs(cellSide*(cx+0.75)-x-radius)<1E-6) && dCellList[0].get_vx()<0 ){
				// 			cout << "D not entered site to right at t=" << t << " and coordinates " << x << "," << y << "," << z << "(" << cx << "," << cy << "," << cz << ")" << endl;
				// 			DEBUG_exit=true;
				// 		}
				// 	}
				// 	for (int cq=cy-1; cq<=cy+1; cq++){
				// 		if (cq>=numPositions) break;
				// 		else if(cq<0) continue;
				// 		for(int cr=cz-1; cr<=cz+1; cr++){
				// 			if (cr>=numPositions) break;
				// 			else if(cr<0) continue;
				// 			for(int cp=cx-1; cp<=cx+1; cp++){
				// 				if (cp>=numPositions) break;
				// 				else if(cp<0) continue;
				// 				if(!IS_IN_VECTOR(dSites[THREED_TO_ONED(cp,cq,cr)],0)){
				// 					if (cp==cx && cq==cy && cr==cz){
				// 						DEBUG_exit=true;
				// 						cout << "! ";
				// 					}
				// 					else cout << "* ";
				// 				} 
				// 				else cout << "D ";
				// 			}
				// 			cout << "\t";
				// 		}
				// 		cout << "\n";
				// 	}
				// 	if(DEBUG_exit){
				// 		cout << "---\nD not in a site at t=" << t << " and coordinates " << x << "," << y << "," << z << "(" << cx << "," << cy << "," << cz << ")" << endl;
				// 		for(auto e: eventList) cout << "\t" << e << endl; cout << endl;
				// 		return 1;
				// 	}
				// 	cout << "\n";
				// 	cout << "***********************************************"<<endl;
				}

			}//End of time loop
			//Record data for final time
			cerr << "\tnumActivated=" << this_numActivated << "/" << numTCells; if(this_numActivated==numTCells){cerr << "*" << endl;} else {cerr << endl;}
			MOMENT_TM(numActivated, this_numActivated, numTimeMeasurements);
			numActivationsPerRepeat[chunk*numRepeats+repeat]=this_numActivated;
			MOMENT(atLeastOneActivated, (this_numActivated>0));
			repeatEnd=clock(); MOMENT(realTimeTaken, 1.*(repeatEnd-repeatStart)/(CLOCKS_PER_SEC));
		}//End of repeat loop

		cout << "#data_start " << chunk << endl;
		OUTPUT_MOMENT_DATA; //If in C++, this goes to stdout
		
	} //End of chunk loop
	//Free all memory we took
	free(cognateAgProbabilityTable);
	return 0;
}