/*From Gunnar Pruessner: macros related to moments and stacks.*/
	#include <string.h>
	#define MOMENT_TYPE double   /*@\colabel{moment_type}@*/
	#define MOMENT_FMT "%10.20g"
	MOMENT_TYPE mom_pow;
	int	 mom_cnt, mom_tm;

	//Declare a new moment: long double mom_ ##(name): n is the name. [(m)+1] is the total number of elements, including 0, so m is the last index.
	#define MOMENT_DECL(n,m) MOMENT_TYPE mom_ ##n[(m) + 1]; int mom_max_ ##n = m;
	#define MOMENT_TM_DECL(n,m,t) MOMENT_TYPE mom_ ##n[(t)*((m)+1)]; int mom_max_ ##n = m; const int mom_tm_max ##n= t;
	//#define MOMENT_TM_MALLOC(n) {for (mom_cnt=0; mom_cnt<=mom_max_ ##n; mom_cnt++) { MALLOC(mom_ ##n[mom_cnt], mom_tm_max ##n, MOMENT_TYPE);}}

	//Initialise moment: loop over mom_ ##(name) and set all its elements to 0, up to the last index (mom_max ##(name)).
	#define MOMENT_INIT(n) {for (mom_cnt=0; mom_cnt<=mom_max_ ##n; mom_cnt++) mom_ ##n [mom_cnt]=0;}
	#define MOMENT_TM_INIT(n) {for (mom_cnt=0; mom_cnt<(1+mom_max_ ##n)*mom_tm_max ##n; mom_cnt++) { mom_ ##n[mom_cnt]=0;}}

	//Each time this is called, increase the first element by 1, increase the second element by x, increase the third element by x^2...
	#define MOMENT(n,x) {mom_ ##n [0]++; for (mom_pow=1, mom_cnt=1; mom_cnt<=mom_max_ ##n; mom_cnt++) {mom_pow*=((MOMENT_TYPE)(x)); mom_ ##n[mom_cnt]+=mom_pow;}}
	#define MOMENT_TM(n,x,t) {mom_ ##n [t]++; for (mom_pow=1, mom_cnt=1; mom_cnt<=mom_max_ ##n; mom_cnt++) {mom_pow*=((MOMENT_TYPE)(x)); mom_ ##n[t+mom_cnt*mom_tm_max ##n]+=mom_pow;}}

	//Header
	#define MOMENT_HEADER    {fprintf(stdout, "#name chunk maxPowerOfVar radius contactRadius tCellAgSpecFreq numTCells numDCells seed numRepeats (=)measurementsTaken x^0 x^1 x^2\n");}
	#define MOMENT_TM_HEADER {fprintf(stdout, "#name chunk timeIndex actualTime maxPowerOfVar maxTimePts radius contactRadius tCellAgSpecFreq numTCells numDCells seed numRepeats (=)measurementsTaken x^0 x^1 x^2\n");}

	//Prints a moment out, given its name. The divisor at the end reads if(mom[0]!=0){divide by mom[0];} else{divide by -1} -- this ensures the moment is averaged over # of elements.
	#define MOMENT_OUT(n) {fprintf(stdout, "#M_%s %i %i %g %g %g %d %d %d %d" MOMENT_FMT, #n, chunk, mom_max_ ##n, radius, contactRadius, tCellAgSpecFreq, numTCells, numDCells, seed, numRepeats, mom_ ##n [0]); \
							for(mom_cnt=0; mom_cnt<=mom_max_ ##n; mom_cnt++) fprintf(stdout, MOMENT_FMT" ", mom_ ##n [mom_cnt]/((mom_ ##n [0]) ? mom_ ##n [0] : -1)); fputc('\n', stdout);}
	#define MOMENT_TM_OUT_TD(n) for (mom_tm=0; mom_tm<mom_tm_max ##n; mom_tm++) if (mom_ ##n[mom_tm]) {fprintf(stdout, "#M_%s %i %i %g %i %i %g %g %g %d %d %d %d" MOMENT_FMT, #n, chunk, mom_tm, mom_tm*timeStep*numTimeSteps/numTimeMeasurements, mom_max_ ##n, mom_tm_max ##n, radius, contactRadius, tCellAgSpecFreq, numTCells, numDCells, seed, numRepeats, mom_ ##n [mom_tm]); \
							for(mom_cnt=0; mom_cnt<=mom_max_ ##n; mom_cnt++) fprintf(stdout, MOMENT_FMT" ", mom_ ##n [mom_cnt*mom_tm_max ##n+mom_tm]/((mom_ ##n [mom_tm]) ? mom_ ##n [mom_tm] : -1)); fputc('\n', stdout);}
	#define MOMENT_TM_OUT_TC(n) for (mom_tm=0; mom_tm<mom_tm_max ##n; mom_tm++) if (mom_ ##n[mom_tm]) {fprintf(stdout, "#M_%s %i %i %g %i %i %g %g %g %d %d %d %d" MOMENT_FMT, #n, chunk, mom_tm, mom_tm*maxTime/numTimeMeasurements, mom_max_ ##n, mom_tm_max ##n, radius, contactRadius, tCellAgSpecFreq, numTCells, numDCells, seed, numRepeats, mom_ ##n [mom_tm]); \
							for(mom_cnt=0; mom_cnt<=mom_max_ ##n; mom_cnt++) fprintf(stdout, MOMENT_FMT" ", mom_ ##n [mom_cnt*mom_tm_max ##n+mom_tm]/((mom_ ##n [mom_tm]) ? mom_ ##n [mom_tm] : -1)); fputc('\n', stdout);}

	//Derived from above: for histograms
	#define HISTOGRAM_TYPE long long int
	#define HISTOGRAM_FMT "%Ld"
	#define HISTOGRAM_DECL(name,numBins,min,max) HISTOGRAM_TYPE hst_ ##name [(numBins)+3]; int hst_bins_ ##name = numBins; double hst_min_ ##name = min; double hst_max_ ##name = max;
	#define HISTOGRAM_INIT(name) {for(mom_cnt=0; mom_cnt<=(hst_bins_ ##name)+2; mom_cnt++) hst_ ##name [mom_cnt]=0;}
	#define HISTOGRAM(name, value) {hst_ ##name [0]++; 																						\
								if(value>=hst_max_ ##name) {hst_ ##name [(hst_bins_ ##name )+2]++;}											\
								else if(value<hst_min_ ##name) {hst_ ##name [(hst_bins_ ##name)+1]++;}										\
								else hst_ ##name [(int)((value-hst_min_ ##name)/(hst_max_ ##name - hst_min_ ##name)*hst_bins_ ##name+1)]++;}
	#define HISTOGRAM_HEADER(name)  {fprintf(stdout, "#name chunk numBins histMin histMax radius contactRadius tCellAgSpecFreq numTCells numDCells seed numRepeats measurementsTaken "); \
									for(mom_cnt=0; mom_cnt<(hst_bins_ ##name); mom_cnt++) fprintf(stdout, "%g<x<%g,",hst_min_ ##name + mom_cnt*(hst_max_ ##name-hst_min_ ##name)/hst_bins_ ##name, hst_min_ ##name + (1+mom_cnt)*(hst_max_ ##name-hst_min_ ##name)/hst_bins_ ##name );\
									fprintf(stdout,"underflow,overflow\n");}
	#define HISTOGRAM_OUT(name) {fprintf(stdout, "#H_%s %i %i %g %g %g %g %g %d %d %d %d " HISTOGRAM_FMT" ", #name, chunk, hst_bins_ ##name, hst_min_ ##name, hst_max_ ##name, radius, contactRadius, tCellAgSpecFreq, numTCells, numDCells, seed, numRepeats, hst_ ##name [0]); \
									for(mom_cnt=1; mom_cnt<=(hst_bins_ ##name)+2; mom_cnt++) fprintf(stdout, HISTOGRAM_FMT",", hst_ ##name [mom_cnt]); fputc('\n', stdout);}
									
	//For a set of histograms e.g for each cell
	// #define HISTOGRAM_SET_DECL(name,numBins,max,setSize) HISTOGRAM_TYPE *hst_set_ ##name[(numBins)+2]; int hst_set_bins_ ##name = numBins; int hst_set_max_ ##name = max; const int hst_set_size_ ##name = setSize;
	// #define HISTOGRAM_SET_MALLOC(name) {for (mom_cnt=0; mom_cnt<=hst_set_bins_ ##name+1; mom_cnt++) {MALLOC(hst_set_ ##name[mom_cnt], hst_set_size_ ##name, HISTOGRAM_TYPE);}}
	// #define HISTOGRAM_SET_INIT(name) {for(mom_cnt=0; mom_cnt<=(hst_set_bins_ ##name)+1; mom_cnt++) { for(mom_tm=0; mom_tm<hst_set_size_ ##name; mom_tm++) hst_set_ ##name [mom_cnt][mom_tm]=0;}}
	// #define HISTOGRAM_SET(name,value,setIndex) {hst_set_ ##name [0][setIndex]++; if(value<hst_set_max_ ##name) {hst_set_ ##name [(int)((value*(hst_set_bins_ ##name)/(hst_set_max_ ##name))+1)][setIndex]++;} else{hst_set_ ##name [(hst_set_bins_ ##name)+1][setIndex]++;}}
	// #define HISTOGRAM_SET_HEADER    {fprintf(stdout, "#name chunk numBins histMax maxPowerOfVar radius contactRadius tCellAgSpecFreq numTCells numDCells seed numRepeats (=)measurementsTaken x^0 x^1 x^2\n");}
	/* #define HISTOGRAM_SET_OUT(name) for(mom_tm=0; mom_tm<hst_set_size_ ##name; mom_tm++) {fprintf(stdout, "#H_%s-%i %i %i %i %g %g %g %d %d %d %d " HISTOGRAM_FMT" ", #name, mom_tm, chunk, hst_set_bins_ ##name, hst_set_max_ ##name, radius,, contactRadius, tCellAgSpecFreq, numTCells, numDCells, seed, numRepeats, (HISTOGRAM_TYPE)hst_set_ ##name [0][mom_tm]); \
									for(mom_cnt=1; mom_cnt<=(hst_set_bins_ ##name)+1; mom_cnt++) fprintf(stdout, HISTOGRAM_FMT",", hst_set_ ##name [mom_cnt][mom_tm]); fputc('\n', stdout);}
	*/
//Malloc macro
long long int total_malloced=0LL;
#define MALLOC(a,n, type) {if ((a=(type*)malloc((n)*sizeof(*(a))))==NULL) \
   {fprintf(stderr, "Fatal error (%s::%i) malloc(3)ing %i bytes for variable %s: %i (%s).\n", \
      __FILE__, __LINE__, (int)(n*sizeof(*(a))), #a, errno, strerror(errno)); exit(EXIT_FAILURE);} else { \
    total_malloced+=((long long int)((n)*sizeof(*a))); \
    fprintf(stdout, "#Info: Malloc(3)ed %lli bytes for %i items variable %s; total %gMB\n", ((long long int)((n)*sizeof(*a))), (int)(n), #a, 1.0*total_malloced/1E6);}}

/*Gunnar Pruessner's code ends here*/
