graphics_toolkit("fltk")
unix("rm aparams.csv")
unix("rm cparams.csv")

fh = figure;

for f = 1:size(list)(1); % input data found in file wavlist.m which lists all the wav files to be analyzed

base = list(f,:);
base = base(base>32); % get rid of trailing spaces

f0 = load([base '.f0.txt']); % to run the script the corresponding .f0.txt file is needed for each .wav file to be analyzed


x = [params(f,2):length(f0)]'; % this line selects the starting time of the stressed V in the region of interest, which is the 2nd column of file startlist.m--this should be adapted if a different region of interest is used, e.g. with data in a different column
y = f0(params(f,2):length(f0));

contour = [x y];
sel = [(contour(:,2)>0).*contour(:,1) (contour(:,2)>0).*contour(:,2)];
sel1 = sel(:,1);
sel2 = sel(:,2);
xsel = [sel1(sel1<0)
0
sel1(sel1>0)];
ysel = sel2(sel2>0);
if(length(xsel)==length(ysel)+1)
xsel = [sel1(sel1<0)
sel1(sel1>0)];
endif

xn = ((1:length(ysel))-length(ysel)/2)/(length(ysel)/2); % Mary 23/11/2020
xn = xn';

meanf0 = params(f,1); % utterance mean f_0, in Hz-- this is found in the 1st column of file startlist.m

%Rescale to semitones above the utterance mean
yst = 12/log10(2)*log10(ysel/meanf0);

%Normalize for polynomial fitting

yn = yst/max(abs(yst));   % normalize yst to [1 -1]

[a,S] = polyfit(xn,yn,4); to fit a cubic, change the 4 in the parenthesis to 3

% Orthogonalize a cubic-- choose this for cubic fitting (i.e., remove % from line 46 and add % to the quartic fitting command on line 49)
% c = [0.4*a(1) 2*a(2)/3 a(3)+6*a(1)/5 a(4)];

% Orthogonalize a quartic-- choose this for quartic fitting
c = [8/35*a(1) 2/5*a(2) 2/3*(a(3)-30/35*a(1)) a(4)+3/5*a(2) a(5)-3/35*a(1)+2/3*(a(3)-30/35*(a(1)))];

fit = getfield(S,'yf');

ysynth = max(abs(yst))*fit;   % having normalized yst to [1 -1]

fit2 = sum((ones(length(xn),1) * a) .* [xn.^4 xn.^3 xn.^2 xn ones(length(xn),1)],2);

ysynth = max(abs(yst))*fit; % having normalized yst to [1 -1]

subplot(2,1,1)
hold off
plot(xsel,yst);
hold on
plot(xsel,ysynth,'r--');
titl = strrep([base '.f0.txt'],'_','\_');

title(titl);
xlabel('time (cs)');
ylabel('f_0 above utterance mean (semitones)');

subplot(2,1,2)
hold off
ysyn2 = max(abs(yst))*fit2;

plot(xn,ysyn2);
xlim([-1 1]);
hold on
rs = real(roots(polyder(a)));

for j = 1:length(rs)
  text(rs(j),13,num2str(round(rs(j))),'rotation',90);
endfor

title('Modelled f_0, maxima and minima')
xlabel('normalised time') 
ylabel('f_0 above utterance mean (semitones)')

picname = [base '_refit.eps'];

eval(["print '-depsc2' " picname]);

avals = num2str([a rs']);
cmd = ["echo " base " " avals " " num2str(meanf0) " >>aparams.csv"];
unix(cmd);
                 
cvals = num2str([c rs']);
cmd = ["echo " base " " cvals " " num2str(meanf0) " >>cparams.csv"];
unix(cmd);

endfor
