graphics_toolkit("fltk")

fh = figure; % ('Visible','off');

for l = 1:size(list)(1)

base = list(l,:);
base = base(base>32); % get rid of trailing spaces

f0 = load([base '.f0.txt']);

x = [1:length(f0)]';

contour = [x f0];
sel = [(contour(:,2)>0).*contour(:,1) (contour(:,2)>0).*contour(:,2)];
sel1 = sel(:,1);
sel2 = sel(:,2);
xsel = [sel1(sel1<0)
0
sel1(sel1>0)];
ysel = sel2(sel2>0);
if(length(xsel)==length(ysel)+1)
xsel = [sel1(sel1<0)
sel1(sel1>0)];
endif

y = f0;
xn = ((1:length(ysel))-length(ysel)/2)/(length(ysel)/2);
xn = xn';

meanf0 = mean(ysel); % utterance mean f_0, in Hz

%Rescale to semitones above the utterance mean
yst = 12/log10(2)*log10(ysel/meanf0);

ydiff = yst - [yst(1); yst(1:length(yst)-1)];

%Normalize for polynomial fitting
yn = yst/mean(yst)-1;

[a,S] = polyfit(xsel,yn,10);

fit = getfield(S,'yf');

ysynth = mean(yst)*(fit+1);   % transformed back into semitones

subplot(2,1,1)
hold off
plot(xsel,yst)
hold on
plot(xsel,ysynth,'r--')
plot(xsel,ydiff,'g')
plot([xsel(1) xsel(length(xsel))],[12 12],'g--')
plot([xsel(1) xsel(length(xsel))],[-12 -12],'g--')

titl = strrep([base '.f0.txt'],'_','\_');

title(titl);

xlabel('time (cs)')
ylabel('f_0 above utterance mean (semitones)')

subplot(2,1,2)
hold off
fit2 = sum((ones(length(x),1) * a) .* [x.^10 x.^9 x.^8 x.^7 x.^6 x.^5 x.^4 x.^3 x.^2 x ones(length(x),1)],2);

ysyn2 = mean(yst)*(fit2+1);   % transformed back into semitones

plot(x,ysyn2)
hold on
rs = round(real(roots(polyder(a))));
plot(rs,15*ones(length(rs)),'r*')
for i = 1:length(rs)
  text(rs(i),16,num2str(rs(i)),'rotation',90)
endfor

title('Modelled f\_0, maxima and minima')
xlabel('time (cs)')
ylabel('f_0 above utterance mean (semitones)')

% save figures as .ps files
picname = [base '_errs.ps'];
eval(["print '-dpsc2' " picname])

vals = num2str([mean(ysynth) rs']);

endfor

