graphics_toolkit("fltk")
unix("rm maxmin_NaN.csv")


fh = figure; % ('Visible','off');

for l = 1:size(list)(1) % input data found in file wavlist.m which lists all the wav files to be analyzed

base = list(l,:);
base = base(base>32); % get rid of trailing spaces

f0 = load([base '.f0.txt']);

x = [1:length(f0)]';

contour = [x f0];
sel = [(contour(:,2)>0).*contour(:,1) (contour(:,2)>0).*contour(:,2)];
sel1 = sel(:,1);
sel2 = sel(:,2);
xsel = [sel1(sel1<0)
0
sel1(sel1>0)];
ysel = sel2(sel2>0);
if(length(xsel)==length(ysel)+1)
xsel = [sel1(sel1<0)
sel1(sel1>0)];
endif

y = f0;
xn = ((1:length(y))-length(y)/2)/(length(y)/2);
xn = xn';

yn = ysel/mean(ysel)-1;

% for 10th order polynomial fitting
[a,S] = polyfit(xsel,yn,10);

fit = getfield(S,'yf');
ysynth = mean(ysel)*(fit+1);  % transformed back into Hz

subplot(2,1,1)
hold off
plot(x,f0)
f0lim = max(f0);
hold on
plot(xsel,ysel,'--')
plot(xsel,ysynth,'r')
xlim([0 length(x)])
ylim([0 f0lim+100])
titl = strrep([base '.f0.txt'],'_','\_');

title(titl);

xlabel('time (cs)')
ylabel('f_0 (Hz)')

subplot(2,1,2)
hold off
fit2 = sum((ones(length(x),1) * a) .* [x.^10 x.^9 x.^8 x.^7 x.^6 x.^5 x.^4 x.^3 x.^2 x ones(length(x),1)],2);
ysyn2 = mean(ysel)*(fit2+1);  % transformed back into Hz

plot(x,ysyn2)
xlim([0 length(x)])
ylim([0 f0lim+100])
hold on
rs = round(real(roots(polyder(a))));
plot(rs,f0lim*ones(length(rs)),'r*')

for i = 1:length(rs)
  text(rs(i),f0lim+10,num2str(rs(i)),'rotation',90)
endfor

title('Modelled f\_0, maxima and minima')
xlabel('time (cs)')
ylabel('f_0 (Hz)')
                            
picname = [base '.NaN.eps'];

eval(["print '-depsc2' " picname]);

% select those roots that are in the bounds of x
rs2 = rs(rs >= min(x));
rs3 = rs2(rs2 <= max(x));

vals = num2str([mean(ysynth) sort(rs3)' NaN ysyn2(sort(rs3))']);  

cmd = ["echo " base " " vals " >> maxmin_NaN.csv"];
unix(cmd);

endfor
