function dt=lhist(a,b,n);
% lhist takes as inputs the .dat files of the syllable and tap locations
% produced by ticktime.py and syllabletime.py and produces a histogram
% of the differences between the closest syllable and tap. n denotes the
% number of bins.
[s,oa,pa]=rmhdr(a,17);
[t,ob,pb]=rmhdr(b,21);
if size(s,1)==1
k=size(s,2);
else
    k=size(s,1);
end
k
if size(t,1)==1
  l=size(t,2);
else
    l=size(t,1);
end
l
dt=[];
for i=1:k
    dtn=[];
    for j=1:l
dtne=abs(s(i)-t(j));
dtn=[dtn dtne];
    end
dtnew=min(dtn);
dt=[dt dtnew];
end
hist(dt,n)