load('colmap.dat','-ascii','colmap');

figures_to_plot = [9:17]; %add figures to the list to plot them. 
% To plot all use
% figures_to_plot = 1:17;
% This will plot the data in Figs. 2, 4, 5, 6, 7, 8, 9, 10, 14, 16 and 17.
% Figs. 1, 3, 11, 12, 13, and 15 are schematics so data is not included.

fprintf(['[\bBy default, this script will plot all 50 panels \n]\b' ...
    '[\bin individual figures. This may some time.\n]\b'])


if any(figures_to_plot==2)
    %% fig 2a
    f=figure;
    fits=importdata('fig2a.xy');
    eyeguidepb=fits(fits(:,3)==3,:);
    plot(eyeguidepb(:,1),eyeguidepb(:,2),'k--','LineWidth',2);
    hold on;
    Cm=fits(fits(:,3)==1,:);
    h1=scatter(Cm(:,1),Cm(:,2),100,[0 0.7 0],'s','MarkerFaceColor',[1 1 1],'LineWidth',2);
    M=fits(fits(:,3)==2,:);
    h2=scatter(M(:,1),M(:,2),100,'bo','MarkerFaceColor',[1 1 1],'LineWidth',2);
    INS=fits(fits(:,3)==4,:);
    h3=scatter(INS(:,1),INS(:,2),36,[0.5 0.5 0.5],'*','LineWidth',1.5);
    eyeguidegap=fits(fits(:,3)==5,:);
    plot(eyeguidegap(:,1),eyeguidegap(:,2),'r--','LineWidth',2);
    data=importdata('fig2a.xye'); %Error bars are included in data file but not in plot
    h4=scatter(data(:,1),11.605*data(:,2),100,'r^','LineWidth',2,'MarkerFaceColor',[1 1 1]);%convert gap to temperature

    xlim([0 2.3])
    ylim([0 0.65])

    [ll]=legend([h1 h2 h4 h3],{'M','C_M','Gap','INS'},'Location','northeast','Box','off');
    xlabel('B(T) \perp z')
    ylabel('Temperature (K)')
    a=gca;
    a.PlotBoxAspectRatio=[1 0.77535 0.77535];
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    set(gca,'Layer','top')
    a.LineWidth=1.5;
    f.Position(3:4)=[560 420];
    box on;
    a.FontSize=18;
    a.XTick=0:0.5:2;
    a.YTick=0:0.1:0.6;

    set(f,'Name','Paper Figure 2a')
    movegui('north')
    drawnow;
end


if any(figures_to_plot==4)
    %% fig 4a
    f=figure;
    plot_color_fig('fig4a.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig4a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig4a.dat',1,-1) %Plots errors

    colormap(colmap);
    format_fig4;
    text(0.9,0.95,sprintf('%.2gT',1.7),'FontSize',32,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 
    hold on;
    data=importdata('fig4a.xy');
    plot(data(:,1),data(:,2),'w-','LineWidth',3)

    set(f,'Name','Paper Figure 4a')
    movegui('north')
    drawnow;

    %% fig 4b
    f=figure;
    plot_color_fig('fig4b.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig4b.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig4b.dat',1,-1) %Plots errors

    colormap(colmap);
    format_fig4;
    text(0.9,0.95,sprintf('%.2gT',3.5),'FontSize',32,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 
    hold on;
    data=importdata('fig4b.xy');
    plot(data(:,1),data(:,2),'w-','LineWidth',3)

    set(f,'Name','Paper Figure 4b')
    movegui('north')
    drawnow;

end
   

if any(figures_to_plot==5)
    %% fig  5a
     f=figure;
     data=importdata('fig5.xye');
     h1=errorbar(data(data(:,6)==1,7),data(data(:,6)==1,4),data(data(:,6)==1,5),'.','MarkerSize',20,'CapSize',6,'Color',[0.8 0 0.6]);
     hold on;
     h2=errorbar(data(data(:,6)==2,7),data(data(:,6)==2,4),data(data(:,6)==2,5),'.','MarkerSize',20,'CapSize',6,'Color',[0.7451 0.7451 0.7451]);
     h3=errorbar(data(data(:,6)==3,7),data(data(:,6)==3,4),data(data(:,6)==3,5),'.','MarkerSize',20,'CapSize',6,'Color',[0 0 0.8]);
     h4=errorbar(data(data(:,6)==4,7),data(data(:,6)==4,4),data(data(:,6)==4,5),'.','MarkerSize',20,'CapSize',6,'Color',[0 0.5 0.3]);

     plot([0 2],[0 2],'k-','LineWidth',3);
     xlim([0 1.8581])
     ylim([0 1.8581])

     [ll]=legend([h1 h2 h3 h4],{'7T//b*','3.5T//b*','1.7T//b*','3.5T//c'},'Location','northwest','Box','off');
     xlabel('Calculated energy (meV)')
     ylabel('Observed energy (meV)')
     a=gca;
     a.PlotBoxAspectRatio=[1 1 1];
     f.Color=[1 1 1];
     a.Color=[1 1 1];
     a.XAxis.Color=[0 0 0];
     a.YAxis.Color=[0 0 0];
     set(gca,'Layer','top')
     a.LineWidth=1.5;
     f.Position(3:4)=[583 461];
     box on;
     a.FontSize=22;
     a.XTick=0:0.5:2;
     a.YTick=0:0.5:2;
    
     set(f,'Name', 'Paper Figure 5a')
     movegui('north')
     drawnow;
    
    %% fig  5b
     f=figure;
     data=importdata('fig5.xye');
     h1=errorbar(data(data(:,6)==1,8),data(data(:,6)==1,4),data(data(:,6)==1,5),'.','MarkerSize',20,'CapSize',6,'Color',[0.8 0 0.6]);
     hold on;
     h2=errorbar(data(data(:,6)==2,8),data(data(:,6)==2,4),data(data(:,6)==2,5),'.','MarkerSize',20,'CapSize',6,'Color',[0.7451 0.7451 0.7451]);
     h3=errorbar(data(data(:,6)==3,8),data(data(:,6)==3,4),data(data(:,6)==3,5),'.','MarkerSize',20,'CapSize',6,'Color',[0 0 0.8]);
     h4=errorbar(data(data(:,6)==4,8),data(data(:,6)==4,4),data(data(:,6)==4,5),'.','MarkerSize',20,'CapSize',6,'Color',[0 0.5 0.3]);

     plot([0 2],[0 2],'k-','LineWidth',3);
     xlim([0 1.8581])
     ylim([0 1.8581])

     [ll]=legend([h1 h2 h3 h4],{'7T//b*','3.5T//b*','1.7T//b*','3.5T//c'},'Location','northwest','Box','off');
     xlabel('Calculated energy (meV)')
     ylabel('Observed energy (meV)')
     a=gca;
     a.PlotBoxAspectRatio=[1 1 1];
     f.Color=[1 1 1];
     a.Color=[1 1 1];
     a.XAxis.Color=[0 0 0];
     a.YAxis.Color=[0 0 0];
     set(gca,'Layer','top')
     a.LineWidth=1.5;
     f.Position(3:4)=[583 461];
     box on;
     a.FontSize=22;
     a.XTick=0:0.5:2;
     a.YTick=0:0.5:2;
    
     set(f,'Name', 'Paper Figure 5b')
     movegui('north')
     drawnow;
end  
  

if any(figures_to_plot==6)

    %% fig 6a
    f=figure;
    plot_color_fig('fig6a.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig6a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig6a.dat',1,-1) %Plots errors

    colormap(colmap);
    text(0.8,0.57,sprintf('%.2g T',0),'FontSize',32,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 
    format_fig6;

    set(f,'Name','Paper Figure 6a')
    movegui('north')
    drawnow;

    %% fig 6b
    f=figure;
    plot_color_fig('fig6b.dat',0)

    colormap(colmap);
    text(0.65,0.57,sprintf('%.2g T',0),'FontSize',32,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 
    hold on;
    data=importdata('fig6b.xy');
    plot(data(:,1),data(:,2:4),'w-','LineWidth',3)
    xline(-2/3,'w:')
    xline(2/3,'w:','LineWidth',2)
    format_fig6;
    
    set(f,'Name','Paper Figure 6b')
    movegui('north')
    drawnow;

    %% fig 6c
    f=figure;
    plot_color_fig('fig6c.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig6c.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig6c.dat',1,-1) %Plots errors

    colormap(colmap);
    text(0.8,0.57,sprintf('%.2g T',1.0),'FontSize',32,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 
    format_fig6;

    set(f,'Name','Paper Figure 6c')
    movegui('north')
    drawnow;

    %% fig 6d
    f=figure;
    plot_color_fig('fig6d.dat',0)

    colormap(colmap);
    text(0.65,0.57,sprintf('%.2g T',1.0),'FontSize',32,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 
    hold on;
    data=importdata('fig6d.xy');
    plot(data(:,1),data(:,2:4),'w-','LineWidth',3)
    xline(-2/3,'w:')
    xline(2/3,'w:','LineWidth',2)
    format_fig6;
    
    set(f,'Name','Paper Figure 6d')
    movegui('north')
    drawnow;

    %% fig 6e
    f=figure;
    plot_color_fig('fig6e.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig6e.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig6e.dat',1,-1) %Plots errors

    colormap(colmap);
    text(0.8,0.57,sprintf('%.2g T',0.25),'FontSize',32,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 
    format_fig6;

    set(f,'Name','Paper Figure 6e')
    movegui('north')
    drawnow;

    %% fig 6f
    f=figure;
    plot_color_fig('fig6f.dat',0)

    colormap(colmap);
    text(0.65,0.57,sprintf('%.2g T',0.25),'FontSize',32,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 
    hold on;
    data=importdata('fig6f.xy');
    plot(data(:,1),data(:,2:4),'w-','LineWidth',3)
    xline(-2/3,'w:')
    xline(2/3,'w:','LineWidth',2)
    format_fig6;
    
    set(f,'Name','Paper Figure 6f')
    movegui('north')
    drawnow;

    %% fig 6g
    f=figure;
    plot_color_fig('fig6g.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig6g.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig6g.dat',1,-1) %Plots errors

    colormap(colmap);
    text(0.8,0.57,sprintf('%.2g T',1.4),'FontSize',32,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 
    format_fig6;

    set(f,'Name','Paper Figure 6g')
    movegui('north')
    drawnow;

    %% fig 6h
    f=figure;
    plot_color_fig('fig6h.dat',0)

    colormap(colmap);
    text(0.65,0.57,sprintf('%.2g T',1.4),'FontSize',32,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 
    hold on;
    data=importdata('fig6h.xy');
    plot(data(:,1),data(:,2:4),'w-','LineWidth',3)
    xline(-2/3,'w:')
    xline(2/3,'w:','LineWidth',2)
    format_fig6;
    
    set(f,'Name','Paper Figure 6h')
    movegui('north')
    drawnow;

    %% fig 6i
    f=figure;
    plot_color_fig('fig6i.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig6i.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig6i.dat',1,-1) %Plots errors

    colormap(colmap);
    text(0.8,0.57,sprintf('%.2g T',0.7),'FontSize',32,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 
    format_fig6;

    set(f,'Name','Paper Figure 6i')
    movegui('north')
    drawnow;

    %% fig 6j
    f=figure;
    plot_color_fig('fig6j.dat',0)

    colormap(colmap);
    text(0.65,0.57,sprintf('%.2g T',0.7),'FontSize',32,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 
    hold on;
    data=importdata('fig6j.xy');
    plot(data(:,1),data(:,2:4),'w-','LineWidth',3)
    xline(-2/3,'w:')
    xline(2/3,'w:','LineWidth',2)
    format_fig6;
    
    set(f,'Name','Paper Figure 6j')
    movegui('north')
    drawnow;

    %% fig 6k
    f=figure;
    plot_color_fig('fig6k.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig6i.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig6i.dat',1,-1) %Plots errors

    colormap(colmap);
    text(0.8,0.57,sprintf('%.2g T',1.7),'FontSize',32,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 
    format_fig6;

    set(f,'Name','Paper Figure 6k')
    movegui('north')
    drawnow;

    %% fig 6l
    f=figure;
    plot_color_fig('fig6l.dat',0)

    colormap(colmap);
    
    text(0.65,0.57,sprintf('%.2g T',1.7),'FontSize',32,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 
    hold on;
    data=importdata('fig6l.xy');
    plot(data(:,1),data(:,2),'w-','LineWidth',3)
    plot(data(:,1),data(:,3:4),'w--','LineWidth',3)
    xline(-2/3,'w:')
    xline(2/3,'w:','LineWidth',2)
    format_fig6;
    
    set(f,'Name','Paper Figure 6j')
    movegui('north')
    drawnow;

end

if any(figures_to_plot==7)
    %% fig 7a
    f=figure;
    data=importdata('fig7a.xye');
    fits=importdata('fig7a.xy');
    %0.7T
    patch([fits(1,1);fits(end,1);flipud(fits(:,1))],[0;0;2*flipud(fits(:,2))],[1 0.7 1],'LineStyle','--','LineWidth',1.5,'EdgeColor',[1 0 1])
    hold on;
    plot(fits(:,1),2*fits(:,2),'m-','LineWidth',1.5)
    errorbar(data(:,1),2*data(:,2),2*data(:,3),'mp','MarkerFaceColor',[1 0 1],'MarkerSize',9,'CapSize',0,'LineWidth',1.5)
    text(0.4,0.15,'0.7 T (x2)','FontSize',24,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 0 1])
    %1T
    patch([fits(1,1);fits(end,1);flipud(fits(:,1))],[0.3;0.3;0.3+2*flipud(fits(:,3))],[0.8 0.8 1],'LineStyle','--','LineWidth',1.5,'EdgeColor',[0 0 1])
    plot(fits(:,1),0.3+2*fits(:,3),'b-','LineWidth',1.5)
    errorbar(data(:,1),0.3+2*data(:,4),2*data(:,5),'bd','MarkerFaceColor',[0 0 1],'MarkerSize',9,'CapSize',0,'LineWidth',1.5)
    text(0.5,0.45,'1.0 T (x2)','FontSize',24,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[0 0 1])
    %1.4T
    patch([fits(1,1);fits(end,1);flipud(fits(:,1))],[0.6;0.6;0.6+flipud(fits(:,4))],[0.7 0.7 0.7],'LineStyle','--','LineWidth',1.5,'EdgeColor',[0 0 0])
    plot(fits(:,1),0.6+fits(:,4),'k-','LineWidth',1.5)
    errorbar(data(:,1),0.6+data(:,6),data(:,7),'ks','MarkerFaceColor',[0 0 0],'MarkerSize',9,'CapSize',0,'LineWidth',1.5)
    text(0.52,0.72,'1.4 T','FontSize',24,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[0 0 0])
    %1.7T
    patch([fits(1,1);fits(end,1);flipud(fits(:,1))],[0.9;0.9;0.9+flipud(fits(:,5))],[1 0.7 0.7],'LineStyle','--','LineWidth',1.5,'EdgeColor',[1 0 0])
    plot(fits(:,1),0.9+fits(:,5),'r-','LineWidth',1.5)
    errorbar(data(:,1),0.9+data(:,8),data(:,9),'ro','MarkerFaceColor',[1 0 0],'MarkerSize',9,'CapSize',0,'LineWidth',1.5)
    text(0.557,1.21,'1.7 T','FontSize',24,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 0 0])

    %format
    xlim([0.11 0.56])
    ylim([-0.05 1.6])
    xlabel('Energy (mev)')
    ylabel('Intensity (arb. units)')
    box on;
    a=gca;
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    a.FontSize=22;
    a.LineWidth=1.5;
    f.Position(3:4)=[617 684];

    set(f,'Name','Paper Figure 7a')
    movegui('north')
    drawnow;

    %% fig 7a (inset)

    f=figure;
    data=importdata('fig7a_inset.xye');
    h=plot([0 0.5],[0.032 0.032],'k--','LineWidth',1.5);
    hold on;
    errorbar(data(1,1),data(1,2),data(1,4),data(1,4),data(1,3),data(1,3),'mp','MarkerFaceColor',[1 0 1],'LineWidth',1.5,'CapSize',0,'MarkerSize',9)
    errorbar(data(2,1),data(2,2),data(2,4),data(2,4),data(2,3),data(2,3),'bd','MarkerFaceColor',[0 0 1],'LineWidth',1.5,'CapSize',0,'MarkerSize',9)
    errorbar(data(3,1),data(3,2),data(3,4),data(3,4),data(3,3),data(3,3),'ks','MarkerFaceColor',[0 0 0],'LineWidth',1.5,'CapSize',0,'MarkerSize',9)
    errorbar(data(4,1),data(4,2),data(4,4),data(4,4),data(4,3),data(4,3),'ro','MarkerFaceColor',[1 0 0],'LineWidth',1.5,'CapSize',0,'MarkerSize',9)

    %format
    xlim([0.15 0.5])
    ylim([0 0.13])
    xlabel('Peak center (mev)')
    ylabel('Peak FWHM (meV)')
    box on;
    a=gca;
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    a.FontSize=17;
    a.LineWidth=1.5;
    f.Position(3:4)=[297 250];
    ll=legend(h,sprintf('Estimated\nresolution'));
    ll.Location='southwest';
    ll.Box='off';

    set(f,'Name','Paper Figure 7a (inset)')
    movegui('north')
    drawnow;

    %% fig 7b
    f=figure;
    data=importdata('fig7b.xye');
    fits=importdata('fig7b.xy');
    plot([-0.2 0.8],[0 0],'k--','LineWidth',1.5)
    %0T
    hold on;
    plot(fits(:,1),fits(:,2),'k-','LineWidth',1.5)
    errorbar(data(:,1),data(:,2),data(:,3),'ko','MarkerFaceColor',[1 1 1],'MarkerSize',9,'CapSize',0,'LineWidth',1.5)
    text(0.13,0.4,'0 T','FontSize',24,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[0 0 0])
    %0.25T
    plot(fits(:,1),fits(:,3),'r-','LineWidth',1.5)
    errorbar(data(:,1),data(:,4),data(:,5),'rs','MarkerFaceColor',[1 1 1],'MarkerSize',9,'CapSize',0,'LineWidth',1.5)
    text(0.25,0.18,'0.25 T','FontSize',24,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 0 0])
    %3.5T
    errorbar(data(:,1),data(:,6),data(:,7),'bd','MarkerFaceColor',[1 1 1],'MarkerSize',9,'CapSize',0,'LineWidth',1.5)
    text(0.16,0.04,'3.5 T','FontSize',24,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[0 0 1])

    %format
    xlim([-0.045 0.4])
    ylim([-0.05 0.599])
    xlabel('Energy (mev)')
    ylabel('Intensity (arb. units)')
    box on;
    a=gca;
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    a.FontSize=22;
    a.LineWidth=1.5;
    f.Position(3:4)=[599 450];

    set(f,'Name','Paper Figure 7b')
    movegui('north')
    drawnow;

    %% fig 7c
    f=figure;
    data=importdata('fig7c.xye');
    fits=importdata('fig7c.xy');
    plot([-0.2 0.8],[0 0],'k--','LineWidth',1.5)
    hold on
    plot([-0.2 0.8],[0.4 0.4],'k--','LineWidth',1.5)
    plot([-0.2 0.8],[0.7 0.7],'k--','LineWidth',1.5)
    plot([-0.2 0.8],[0.9 0.9],'k--','LineWidth',1.5)
    plot([-0.2 0.8],[1.05 1.05],'k--','LineWidth',1.5)

    %0T
    plot(fits(:,1),fits(:,2),'k-','LineWidth',1.5)
    errorbar(data(:,1),data(:,2),data(:,3),'ko','MarkerFaceColor',[1 1 1],'MarkerSize',9,'CapSize',0,'LineWidth',1.5)
    text(0.21,0.15,'0 T','FontSize',20,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[0 0 0])
    %0.25T
    plot(fits(:,1),0.4+fits(:,3),'r-','LineWidth',1.5)
    errorbar(data(:,1),0.4+data(:,4),data(:,5),'rs','MarkerFaceColor',[1 1 1],'MarkerSize',9,'CapSize',0,'LineWidth',1.5)
    text(0.29,0.53,'0.25 T','FontSize',20,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 0 0])
    %0.7T
    plot(fits(:,1),0.7+fits(:,4),'m-','LineWidth',1.5)
    errorbar(data(:,1),0.7+data(:,6),data(:,7),'mp','MarkerFaceColor',[1 0 1],'MarkerSize',9,'CapSize',0,'LineWidth',1.5)
    text(0.37,0.78,'0.7 T','FontSize',20,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 0 1])
    %1.0T
    plot(fits(:,1),0.9+fits(:,5),'b-','LineWidth',1.5)
    errorbar(data(:,1),0.9+data(:,8),data(:,9),'bd','MarkerFaceColor',[0 0 1],'MarkerSize',9,'CapSize',0,'LineWidth',1.5)
    text(0.27,0.98,'1.0 T','FontSize',20,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[0 0 1])
    %1.4T
    plot(fits(:,1),1.05+fits(:,6),'k-','LineWidth',1.5)
    errorbar(data(:,1),1.05+data(:,10),data(:,11),'ks','MarkerFaceColor',[0 0 0],'MarkerSize',9,'CapSize',0,'LineWidth',1.5)
    text(0.2,1.12,'1.4 T','FontSize',20,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[0 0 0])
    %1.7T
    plot(fits(:,1),fits(:,7),'r-','LineWidth',1.5)
    errorbar(data(:,1),data(:,12),data(:,13),'ro','MarkerFaceColor',[1 0 0],'MarkerSize',9,'CapSize',0,'LineWidth',1.5)
    text(0.16,0.35,'1.7 T','FontSize',20,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 0 0])

    %format
    xlim([-0.01 0.65])
    ylim([-0.04 1.24])
    xlabel('Energy (mev)')
    ylabel('Intensity (arb. units)')
    box on;
    a=gca;
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    a.FontSize=22;
    a.LineWidth=1.5;
    f.Position(3:4)=[665 1120];
    a.PlotBoxAspectRatio=[0.56462 1 0.56462];

    set(f,'Name','Paper Figure 7c')
    movegui('north')
    drawnow;

end


if any(figures_to_plot==8)
    %% fig 8a
    f=figure;
    s=plot_color_fig('fig8a.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig8a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig8a.dat',1,-1) %Plots errors
    s.CData=8*s.CData;
    colormap(colmap);
    format_fig8;
    bz=importdata('BZ.xy');
    hold on;
    plot(bz(:,1),bz(:,2),'--','Color',[0.5 0.5 0.5],'LineWidth',3)
    text(-0.97,-0.10,'x8','FontSize',26,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 
    text(1.13,-0.11,sprintf('%.2g meV',0.41),'FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 

    set(f,'Name','Paper Figure 8a')
    movegui('north')
    drawnow;

    %% fig 8b
    f=figure;
    s=plot_color_fig('fig8b.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig8b.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig8b.dat',1,-1) %Plots errors
    colormap(colmap);
    format_fig8;
    bz=importdata('BZ.xy');
    hold on;
    plot(bz(:,1),bz(:,2),'--','Color',[0.5 0.5 0.5],'LineWidth',3)
    text(1.13,-0.11,sprintf('%.2g meV',0.41),'FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 

    set(f,'Name','Paper Figure 8b')
    movegui('north')
    drawnow;

    %% fig 8c
    f=figure;
    s=plot_color_fig('fig8c.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig8c.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig8c.dat',1,-1) %Plots errors
    s.CData=3*s.CData;
    colormap(colmap);
    format_fig8;
    bz=importdata('BZ.xy');
    hold on;
    plot(bz(:,1),bz(:,2),'--','Color',[0.5 0.5 0.5],'LineWidth',3)
    text(-0.97,-0.10,'x3','FontSize',26,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 
    text(1.13,-0.11,sprintf('%.2g meV',0.31),'FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 

    set(f,'Name','Paper Figure 8c')
    movegui('north')
    drawnow;

    %% fig 8d
    f=figure;
    s=plot_color_fig('fig8d.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig8d.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig8d.dat',1,-1) %Plots errors
    colormap(colmap);
    format_fig8;
    bz=importdata('BZ.xy');
    hold on;
    plot(bz(:,1),bz(:,2),'--','Color',[0.5 0.5 0.5],'LineWidth',3)
    text(1.13,-0.11,sprintf('%.2g meV',0.31),'FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 

    set(f,'Name','Paper Figure 8d')
    movegui('north')
    drawnow;
    
    %% fig 8e
    f=figure;
    s=plot_color_fig('fig8e.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig8e.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig8e.dat',1,-1) %Plots errors
    s.CData=1.5*s.CData;
    colormap(colmap);
    format_fig8;
    bz=importdata('BZ.xy');
    hold on;
    plot(bz(:,1),bz(:,2),'--','Color',[0.5 0.5 0.5],'LineWidth',3)
    text(-0.9,-0.11,'x1.5','FontSize',26,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[0 0 0]); 
    text(1.13,-0.11,sprintf('%.2g meV',0.21),'FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 

    set(f,'Name','Paper Figure 8e')
    movegui('north')
    drawnow;

    %% fig 8f
    f=figure;
    s=plot_color_fig('fig8f.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig8f.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig8f.dat',1,-1) %Plots errors
    colormap(colmap);
    format_fig8;
    bz=importdata('BZ.xy');
    hold on;
    plot(bz(:,1),bz(:,2),'--','Color',[0.5 0.5 0.5],'LineWidth',3)
    text(1.13,-0.11,sprintf('%.2g meV',0.21),'FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 

    set(f,'Name','Paper Figure 8f')
    movegui('north')
    drawnow;

     %% fig 8g
    f=figure;
    s=plot_color_fig('fig8g.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig8g.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig8g.dat',1,-1) %Plots errors
    s.CData=1.4*s.CData;
    colormap(colmap);
    format_fig8;
    bz=importdata('BZ.xy');
    hold on;
    plot(bz(:,1),bz(:,2),'--','Color',[0.5 0.5 0.5],'LineWidth',3)
    text(-0.9,-0.11,'x1.4','FontSize',26,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[0 0 0]); 
    text(0.27,-0.11,sprintf('%.2g meV',0.15),'FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 

    set(f,'Name','Paper Figure 8g')
    movegui('north')
    drawnow;
    
    %% fig 8h
    f=figure;
    s=plot_color_fig('fig8h.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig8h.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig8h.dat',1,-1) %Plots errors
    colormap(colmap);
    format_fig8;
    bz=importdata('BZ.xy');
    hold on;
    plot(bz(:,1),bz(:,2),'--','Color',[0.5 0.5 0.5],'LineWidth',3)
    text(0.27,-0.11,sprintf('%.2g meV',0.15),'FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 

    set(f,'Name','Paper Figure 8h')
    movegui('north')
    drawnow;

    %% fig 8i
    f=figure;
    s=plot_color_fig('fig8i.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig8i.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig8i.dat',1,-1) %Plots errors
    s.CData=0.8*s.CData;
    colormap(colmap);
    format_fig8;
    bz=importdata('BZ.xy');
    hold on;
    plot(bz(:,1),bz(:,2),'--','Color',[0.5 0.5 0.5],'LineWidth',3)
    text(-0.9,-0.11,'x0.8','FontSize',26,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 
    text(0.27,-0.11,sprintf('%.2g meV',0.09),'FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 

    set(f,'Name','Paper Figure 8i')
    movegui('north')
    drawnow;

    %% fig 8j
    f=figure;
    s=plot_color_fig('fig8j.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig8j.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig8j.dat',1,-1) %Plots errors
    colormap(colmap);
    format_fig8;
    bz=importdata('BZ.xy');
    hold on;
    plot(bz(:,1),bz(:,2),'--','Color',[0.5 0.5 0.5],'LineWidth',3)
    text(0.27,-0.11,sprintf('%.2g meV',0.09),'FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 

    set(f,'Name','Paper Figure 8j')
    movegui('north')
    drawnow;

    %% fig 8k
    f=figure;
    s=plot_color_fig('fig8k.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig8k.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig8k.dat',1,-1) %Plots errors
    s.CData=0.5*s.CData;
    colormap(colmap);
    format_fig8;
    bz=importdata('BZ.xy');
    hold on;
    plot(bz(:,1),bz(:,2),'--','Color',[0.5 0.5 0.5],'LineWidth',3)
    text(-0.9,-0.11,'x0.5','FontSize',26,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 
    text(0.27,-0.11,sprintf('%.2g meV',0.05),'FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 

    set(f,'Name','Paper Figure 8k')
    movegui('north')
    drawnow;

    %% fig 8l
    f=figure;
    s=plot_color_fig('fig8l.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig8l.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig8l.dat',1,-1) %Plots errors
    colormap(colmap);
    format_fig8;
    bz=importdata('BZ.xy');
    hold on;
    plot(bz(:,1),bz(:,2),'--','Color',[0.5 0.5 0.5],'LineWidth',3)
    text(0.27,-0.11,sprintf('%.2g meV',0.05),'FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 

    set(f,'Name','Paper Figure 8l')
    movegui('north')
    drawnow;
    

end

if any(figures_to_plot==9)
    %% fig 9a 
    f=figure;
    data=importdata('fig9a.xy');
    patch([data(:,1);flipud(data(:,1))],[data(:,2);flipud(data(:,5))],[0.5 1 1],'LineStyle','None')
    hold on;
    patch([data(:,1);flipud(data(:,1))],[data(:,3);flipud(data(:,6))],[1 0.7 1],'LineStyle','None')
    patch([data(:,1);flipud(data(:,1))],[data(:,4);flipud(data(:,7))],[0.85 0.85 0.85],'LineStyle','None')
    plot(data(:,1),data(:,2),'Color',[0 0.5 0.5],'LineWidth',2)
    plot(data(:,1),data(:,3),'Color',[0.7 0 0.7],'LineWidth',2)
    plot(data(:,1),data(:,4),'Color',[0.55 0.55 0.55],'LineWidth',2)
    plot(data(:,1),data(:,5),'--','Color',[0 0.5 0.5],'LineWidth',2)
    plot(data(:,1),data(:,6),'--','Color',[0.7 0 0.7],'LineWidth',2)
    plot(data(:,1),data(:,7),'--','Color',[0.55 0.55 0.55],'LineWidth',2) 

    xlim([-1.06 1.06]);
    ylim([0 0.6]);
    a=gca;
    a.PlotBoxAspectRatio=[1 1 1];
    f=gcf;
    f.Position(3:4)=[598   518];
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    a.XLabel.String='(\ith\rm,-0.5\ith\rm)(r.l.u.)';
    a.YLabel.String='Energy (meV)';
    a.LineWidth=1.5;
    a.FontSize=22;
    a.YLabel.FontSize=24;
    a.XLabel.FontSize=24;
    a.XTick=[-1 0 1];
    box on;
    set(gca,'Layer','top')
    
    a2=copyobj(gca,gcf);
    a2.XAxisLocation='top';
    a2.YTick=[];
    ylabel(a2,'');
    xlabel(a2,'')
    a2.Color='none';
    a2.XTick=[-1 -2/3 0 2/3 1];
    a2.XTickLabels={'M','K^{\prime}','\Gamma','K','M'};
    delete(a2.Children)
    a2.Position=a.Position;

    set(f,'Name','Paper Figure 9a')
    movegui('north')
    drawnow;
    
    %% fig 9b
    f=figure;
    plot_color_fig('fig9b.dat',0)

    colormap(colmap);
    format_fig6;
       
    set(f,'Name','Paper Figure 9b')
    movegui('north')
    drawnow;

    %% fig 9c
    f=figure;
    data=importdata('fig9c.xye');
    fits=importdata('fig9c.xy');
   
    plot([-0.2 0.8],[0 0],'k--','LineWidth',1.5) %refline
    hold on;
    plot(fits(:,1),fits(:,2),'k-','LineWidth',2); %eyeguide
    h1=errorbar(data(:,1),data(:,4),data(:,5),'ko','MarkerFaceColor',[0 0 0],'MarkerSize',12,'CapSize',0,'LineWidth',1.5);%1.7T data
    h2=errorbar(data(:,1),data(:,6),data(:,7),'ks','MarkerFaceColor',[0 0 0],'MarkerSize',12,'CapSize',0,'LineWidth',1.5);%3.5T data
    h3=plot(data(:,1),data(:,9),'r-','LineWidth',1.5); %manifold average
    h4=plot(data(:,1),data(:,8),'b--','LineWidth',1.5); %Y phase
    h5=errorbar(data(:,1),data(:,2),data(:,3),'ko','MarkerFaceColor',[1 1 1],'MarkerSize',12,'CapSize',0,'LineWidth',1.5);%0T data

    %format
    xlim([-0.05 0.45])
    ylim([-0.05 1.25])
    xlabel('Energy (mev)')
    ylabel('Intensity (arb. units)')
    box on;
    a=gca;
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    a.FontSize=30;
    a.LineWidth=1.5;
    f.Position(3:4)=[984 593];
    a.PlotBoxAspectRatio=[1 0.60918 0.60918];

    ll=legend([h5 h4 h3 h2 h1],{'0 T','Y phase','GS manifold','3.5 T','1.7 T'});
    ll.Box='off';
    
    set(f,'Name','Paper Figure 9c')
    movegui('north')
    drawnow;

    %% fig 9c (inset)

    f=figure;
    data=importdata('fig9c.xye');
    fits=importdata('fig9c.xy');
   
    plot([-0.2 0.8],[0 0],'k--','LineWidth',1.5) %refline
    hold on;
    plot(fits(:,1),fits(:,2),'k-','LineWidth',2); %eyeguide
    h1=errorbar(data(:,1),data(:,4),data(:,5),'ko','MarkerFaceColor',[0 0 0],'MarkerSize',12,'CapSize',0,'LineWidth',1.5);%1.7T data
    h2=errorbar(data(:,1),data(:,6),data(:,7),'ks','MarkerFaceColor',[0 0 0],'MarkerSize',12,'CapSize',0,'LineWidth',1.5);%3.5T data
    h3=plot(data(:,1),data(:,9),'r-','LineWidth',1.5); %manifold average
    h4=plot(data(:,1),data(:,8),'b--','LineWidth',1.5); %Y phase
    h5=errorbar(data(:,1),data(:,2),data(:,3),'ko','MarkerFaceColor',[1 1 1],'MarkerSize',12,'CapSize',0,'LineWidth',1.5);%0T data

    %format
    xlim([0.2 0.59])
    ylim([-0.005 0.07])
    xlabel('Energy (mev)')
    ylabel('Intensity (arb. units)')
    box on;
    a=gca;
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    a.FontSize=28;
    a.LineWidth=1.5;
    f.Position(3:4)=[554 412];
    a.PlotBoxAspectRatio=[1 0.7707 0.7707];

    ll=legend([h5 h4 h3 h2 h1],{'0 T','Y phase','GS manifold','3.5 T','1.7 T'});
    ll.Box='off';


    set(f,'Name','Paper Figure 9c (inset)')
    movegui('north')
    drawnow;



end

if any(figures_to_plot==10)
    %% fig 10a
    f=figure;
    s=plot_color_fig('fig10a.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig10a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig10a.dat',1,-1) %Plots errors
    colormap(colmap);
    format_fig10;
    text(-0.56,-0.56,sprintf('%.2g T',0),'FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 

    set(f,'Name','Paper Figure 10a')
    movegui('north')
    drawnow;

    %% fig 10b
    f=figure;
    s=plot_color_fig('fig10b.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig10b.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig10b.dat',1,-1) %Plots errors
    colormap(colmap);
    format_fig10;
    text(-0.56,-0.56,sprintf('%.2g T',0.25),'FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 

    set(f,'Name','Paper Figure 10b')
    movegui('north')
    drawnow;

    %% fig 10c
    f=figure;
    s=plot_color_fig('fig10c.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig10c.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig10c.dat',1,-1) %Plots errors
    colormap(colmap);
    format_fig10;
    text(-0.56,-0.56,sprintf('%.2g T',0.7),'FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 

    set(f,'Name','Paper Figure 10c')
    movegui('north')
    drawnow;

    %% fig 10d
    f=figure;
    s=plot_color_fig('fig10d.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig10d.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig10d.dat',1,-1) %Plots errors
    colormap(colmap);
    format_fig10;
    text(-0.56,-0.56,sprintf('%.2g T',1.0),'FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 

    set(f,'Name','Paper Figure 10d')
    movegui('north')
    drawnow;

    %% fig 10e
    f=figure;
    s=plot_color_fig('fig10e.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig10e.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig10e.dat',1,-1) %Plots errors
    colormap(colmap);
    format_fig10;
    text(-0.56,-0.56,sprintf('%.2g T',1.4),'FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 

    set(f,'Name','Paper Figure 10e')
    movegui('north')
    drawnow;

    %% fig 10f
    f=figure;
    s=plot_color_fig('fig10f.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig10f.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig10f.dat',1,-1) %Plots errors
    colormap(colmap);
    format_fig10;
    text(-0.56,-0.56,sprintf('%.2g T',1.7),'FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 

    set(f,'Name','Paper Figure 10f')
    movegui('north')
    drawnow;

end

if any(figures_to_plot==14)
    %% fig 14a
    f=figure;
    data=importdata('fig14a.xye');
    plot([0 120],[0 120],'k-','LineWidth',1.5)
    hold on;
    errorbar(data(:,6),data(:,4),data(:,5),'r.','CapSize',0)
    format_fig14;
    text(75,102,'100 K Sample I','FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[0 0 0]);
    text(25,93,'$P\bar{3}m1$','Interpreter','latex','FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[0 0 0]);

    set(f,'Name','Paper Figure 14a')
    movegui('north')
    drawnow;

    %% fig 14b
    f=figure;
    data=importdata('fig14b.xye');
    plot([0 120],[0 120],'k-','LineWidth',1.5)
    hold on;
    errorbar(data(:,6),data(:,4),data(:,5),'r.','CapSize',0)
    format_fig14;
    text(75,102,'100 K Sample I','FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[0 0 0]);
    text(25,93,'$P\bar{3}$','Interpreter','latex','FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[0 0 0]);

    set(f,'Name','Paper Figure 14b')
    movegui('north')
    drawnow;

    %% fig 14c
    f=figure;
    data=importdata('fig14c.xye');
    plot([0 120],[0 120],'k-','LineWidth',1.5)
    hold on;
    errorbar(data(:,6),data(:,4),data(:,5),'r.','CapSize',0)
    format_fig14;
    text(75,102,'300 K Sample II','FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[0 0 0]);
    text(25,93,'$P\bar{3}$','Interpreter','latex','FontSize',22,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[0 0 0]);

    set(f,'Name','Paper Figure 14c')
    movegui('north')
    drawnow;

end

if any(figures_to_plot==16)
    %%  fig 16
    f=figure;
    plot_color_fig('fig16.dat',0)

    colormap(colmap);
    text(0.65,0.57,sprintf('%.2g T',1.4),'FontSize',32,'FontName','Arial','FontWeight','Normal','HorizontalAlignment','right','Color',[1 1 1]); 
    hold on;
    data=importdata('fig16.xy');
    plot(data(:,1),data(:,2:4),'w-','LineWidth',3)
    xline(-2/3,'w:')
    xline(2/3,'w:','LineWidth',2)
    a=gca;
    format_fig6;
    a.XTick=[-1 -0.5 0 0.5 1];
    
    set(f,'Name','Paper Figure 16')
    movegui('north')
    drawnow;

end


if any(figures_to_plot==17)
    %% fig 17a
    f=figure;
    s=plot_color_fig('fig17a.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig17a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig17a.dat',1,-1) %Plots errors
    colormap(colmap);
    
    xlabel('(-2/3, 1/3, \itl\rm) (r.l.u.)')
    ylabel('Energy (meV)')
    xlim([-0.85 0.4])
    ylim([0.35 0.6])
    caxis([0 0.35])
    a=gca;
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    a.PlotBoxAspectRatio=[1 1 1];
    a.FontSize=18;
    a.XTick=-0.75:0.25:0.25;
    a.YTick=0.35:0.05:0.6;
    a.LineWidth=1.5;
    cb=colorbar;
    cb.LineWidth=1.5;
    ylabel(cb,'Intensity (arb. units)')

    set(f,'Name','Paper Figure 17a')
    movegui('north')
    drawnow;

    %% fig 17b
    f=figure;
    s=plot_color_fig('fig17b.dat',0);
    colormap(colmap);
    fits=importdata('fig17b.xy');
    hold on;
    plot(fits(:,1),fits(:,2),'w-','LineWidth',3);
    plot(fits(:,1),fits(:,3),'k-','LineWidth',3);

    xlabel('(-2/3, 1/3, \itl\rm) (r.l.u.)')
    ylabel('Energy (meV)')
    xlim([-0.85 0.4])
    ylim([0.35 0.6])
    caxis([0 0.35])
    a=gca;
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    a.PlotBoxAspectRatio=[1 1 1];
    a.FontSize=18;
    a.XTick=-0.75:0.25:0.25;
    a.YTick=0.35:0.05:0.6;
    a.LineWidth=1.5;
    cb=colorbar;
    cb.LineWidth=1.5;
    ylabel(cb,'Intensity (arb. units)')

    set(f,'Name','Paper Figure 17b')
    movegui('north')
    drawnow;

    %% fig 17c
    f=figure;
    fits=importdata('fig17c.xy');
    data=importdata('fig17c.xye');
    plot(fits(:,1),fits(:,2),'b-','LineWidth',1.5);
    hold on;
    errorbar(data(:,1),data(:,2),data(:,3),'ro','MarkerFaceColor',[1 0 0],'LineWidth',1.5,'MarkerSize',10,'CapSize',6);

    xlabel('(-2/3, 1/3, \itl\rm) (r.l.u.)')
    ylabel('Linewidth (meV)')
    xlim([-0.85 0.4])
    ylim([0.02 0.04])
    a=gca;
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    a.PlotBoxAspectRatio=[1 1 1];
    a.FontSize=18;
    a.XTick=-0.75:0.25:0.25;
    a.YTick=0.02:0.005:0.04;
    a.LineWidth=1.5;
    ll=legend({'Calculated','Experiment'});
    ll.Box='off';
    
    set(f,'Name','Paper Figure 17c')
    movegui('north')
    drawnow;


end


%% Subroutines to plot
function hout=plot_color_fig(fdata,isErr,flag,xscale)
% Plots color data in .dat file, with isErr specifying if the input
% .dat file contains a column for errors (i.e. if experimental data); and
% flag specifying whether to plot smoothed intensities (flag=1 - default),
% raw intensities (flag=0), or errors (flag=-1).
% Additionally evaluates code strings specified as optional arguments.
% xscale =[p f side=+/-] is an optional scale factor for the xwidth of column number
% p on the + or - side=+/-1 (p = integer between 1 and size(X,2) number of columns) 
% this can be of the form [p1 f1 s1; p2 f2 s2;...] 
    
    fdata=importdata(fdata,' ',1);
    
    sz=eval(fdata.textdata{1});
    
    if ~exist('flag','var') %By default, set flag to 1
        flag=1;
    end
    
    % Reshape to 2D array for plotting
    if isErr
    X=reshape(fdata.data(:,1),sz);
    Y=reshape(fdata.data(:,end-3),sz);
    switch flag
        case -1 %Plot errors
            C=reshape(fdata.data(:,end-1),sz);
        case 0 %Raw intensities
            C=reshape(fdata.data(:,end-2),sz);
        case 1 %Smoothed intensities
            C=reshape(fdata.data(:,end),sz);
    end
    else
    X=reshape(fdata.data(:,1),sz);
    Y=reshape(fdata.data(:,end-1),sz);
    C=reshape(fdata.data(:,end),sz);    
    end
    
    % from (X,Y) bin centers construct arrays of bin edges (Xb,Yb) 
% X,Y,C(n,m)  Xb,Yb,Cb(n+1,m+1)
[Xb,Yb,Cb]=cen2edge(X,Y,C);  

if exist('xscale','var')&&~isempty(xscale)&&isnumeric(xscale)&&(size(xscale,2)==3)&&(all(xscale(:,1))<=size(X,2))
    [~,perm]=sort(xscale(:,1));
    xscale=xscale(perm,:);
    for i=1:size(xscale,1)
        j=xscale(i,1);
        xwidth=Xb(:,j+1)-Xb(:,j);
        cen=(Xb(:,j+1)+Xb(:,j))/2;
        switch xscale(i,3)
            case {-1}, Xb(:,j)=cen-xwidth/2*xscale(i,2);
            case {+1}, Xb(:,j+1)=cen+xwidth/2*xscale(i,2);
            otherwise
                fprintf(2,'xscale=[p f s]; s expected to be -/+1 for left/right side of boundary to be scaled\n');
                hout=[];
                return
        end
    end
end
h=pcolor(Xb,Yb,Cb);
shading flat

isNum=~isnan(Cb);
axis([min(Xb(isNum)) max(Xb(isNum)) min(Yb(isNum)) max(Yb(isNum))])

if nargout>0
    hout=h;
end
end

function [xb,yb,zz]=cen2edge(x,y,z)
xx=(x(:,1:(end-1))+x(:,2:end))/2;
x1=x(:,1)-(-x(:,1)+xx(:,1));
xn=x(:,end)+(x(:,end)-xx(:,end));
xb=[x1 xx xn];
xb(end+1,:)=xb(end,:);
yy=(y(1:(end-1),:)+y(2:end,:))/2;
y1=y(1,:)-(-y(1,:)+yy(1,:));
yn=y(end,:)+(y(end,:)-yy(end,:));
yb=[y1;yy;yn];
yb(:,end+1)=yb(:,end);
zz=z;
zz(end+1,:)=NaN;
zz(:,end+1)=NaN;
end


function format_fig4
    xlim([-1.3 1.3]);
    ylim([0 1]);
    caxis([0 1]);
    cb=colorbar;
    a=gca;
    a.PlotBoxAspectRatio=[1 1 1];
    f=gcf;
    f.Position(3:4)=[598   700];
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    a.XLabel.String='(\ith\rm,-0.5\ith\rm)(r.l.u.)';
    a.YLabel.String='Energy (meV)';
    a.LineWidth=1.5;
    cb.Color=[0 0 0];
    cb.LineWidth=1.5;
    ylabel(cb,'Intensity (arb. units)')
    a.FontSize=22;
    a.YLabel.FontSize=24;
    a.XLabel.FontSize=24;
    a.XTick=[-1 0 1]; 
    box on;
    set(gca,'Layer','top')

    
    a2=copyobj(gca,gcf);
    a2.XAxisLocation='top';
    a2.YTick=[];
    ylabel(a2,'');
    xlabel(a2,'')
    a2.Color='none';
    a2.XTick=[-1 -2/3 0 2/3 1];
    a2.XTickLabels={'M','K^{\prime}','\Gamma','K','M'};
    delete(a2.Children)
    a2.Position=a.Position;
    
end

function format_fig6
    xlim([-1.06 1.06]);
    ylim([0 0.6]);
    caxis([0.003 0.3]);
    cb=colorbar;
    a=gca;
    a.ColorScale='log';
    a.PlotBoxAspectRatio=[1 1 1];
    f=gcf;
    f.Position(3:4)=[598   518];
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    a.XLabel.String='(\ith\rm,-0.5\ith\rm)(r.l.u.)';
    a.YLabel.String='Energy (meV)';
    a.LineWidth=1.5;
    cb.Color=[0 0 0];
    cb.LineWidth=1.5;
    ylabel(cb,'Intensity (arb. units)')
    a.FontSize=22;
    a.YLabel.FontSize=24;
    a.XLabel.FontSize=24;
    a.XTick=[-1 0 1];
    box on;
    
    a2=copyobj(gca,gcf);
    a2.XAxisLocation='top';
    a2.YTick=[];
    ylabel(a2,'');
    xlabel(a2,'')
    a2.Color='none';
    a2.XTick=[-1 -2/3 0 2/3 1];
    a2.XTickLabels={'M','K^{\prime}','\Gamma','K','M'};
    %delete(a2.Children)
    a2.Position=a.Position;

end

function format_fig8
    xlim([-1.26 1.26]);
    ylim([-0.189 0.192]);
    caxis([0 1]);
    cb=colorbar;
    a=gca;
    a.PlotBoxAspectRatio=[5.7271 1 3.5333];
    f=gcf;
    f.Position(3:4)=[598   287];
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    a.XLabel.String='(\ith\rm,-0.5\ith\rm)(r.l.u.)';
    a.YLabel.String='(0,\it-k\rm)(r.l.u.)';
    a.LineWidth=1.5;
    cb.Color=[0 0 0];
    cb.LineWidth=1.5;
    ylabel(cb,'Intensity (arb. units)')
    a.FontSize=14;
    a.XTick=[-1 -0.5 0 0.5 1];
    a.YTick=[-0.15 0 0.15];

end

function format_fig10
    xlim([-0.75 -0.55]);
    ylim([-0.6 0.55]);
    caxis([0 60]);
    cb=colorbar;
    a=gca;
    a.PlotBoxAspectRatio=[1 4.3448 5.466];
    f=gcf;
    f.Position(3:4)=[598  518];
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    a.XLabel.String='(\ith\rm,-0.5\ith\rm)(r.l.u.)';
    a.YLabel.String='\itl\rm (r.l.u.)';
    a.LineWidth=1.5;
    cb.Color=[0 0 0];
    cb.LineWidth=1.5;
    ylabel(cb,'Intensity (arb. units)')
    a.FontSize=20;
    a.XTick=[-0.7 -0.6];
    a.YTick=[-0.6:0.2:0.4];
    set(gca,'Layer','top')

end

function format_fig14
    xlabel('|F_{calc}| (arb. units)')
    ylabel('|F_{obs}| (arb. units)')
    xlim([0 107])
    ylim([0 107])
    a=gca;
    f=gcf;
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    a.PlotBoxAspectRatio=[1 1 1];
    box on;
    a.LineWidth=1.5;
    a.XTick=0:20:100;
    a.YTick=0:20:100;
end



