%% N2 wavelength scans
% laser detection
% PB_TESTING0506y14
% 0311y14
% Tvalve = -100 deg C

% all traces together

close all
clear all

set(0,'defaulttextinterpreter','latex')
set(0,'DefaultTextFontname', 'Symbol')
set(0,'DefaultAxesFontName', 'Symbol')

Ubias = [0 30 50 80 100 130 150 180 200];
pv = [2.6 4.0 5.6];

str1 = 'N2_2p6bar_150V_m100.txt';
str2 = 'N2_5p6bar_0V_m100.txt';
str3 = 'N2_5p6bar_150V2_m100.txt';

str4 = 'N2_4p0bar_0V_m100.txt';
str5 = 'N2_4p0bar_30V_m100.txt';
str6 = 'N2_4p0bar_50V_m100.txt';
str7 = 'N2_4p0bar_80V_m100.txt';
str8 = 'N2_4p0bar_100V_m100.txt';
str9 = 'N2_4p0bar_130V_m100.txt';
str10 = 'N2_4p0bar_150V_m100.txt';
str11 = 'N2_4p0bar_180V_m100.txt';
str12 = 'N2_4p0bar_200V_m100.txt';

s1 = load(str1);
s2 = load(str2);
s3 = load(str3);
s4 = load(str4);
s5 = load(str5);
s6 = load(str6);
s7 = load(str7);
s8 = load(str8);
s9 = load(str9);
s10 = load(str10);
s11 = load(str11);
s12 = load(str12);


%% Wavelength scan
% plot two-photon wavenumber (269/2 nm!)

wl_shift = 2.7;
wl2 = 0.5; % additional wavelength shift needed for scans in normal direction

s1(:,1) = s1(:,1)+wl_shift;
s2(:,1) = s2(:,1)+wl_shift;
s3(:,1) = s3(:,1)+wl_shift+wl2;
s4(:,1) = s4(:,1)+wl_shift;
s5(:,1) = s5(:,1)+wl_shift;
s6(:,1) = s6(:,1)+wl_shift+wl2;
s7(:,1) = s7(:,1)+wl_shift+wl2;
s8(:,1) = s8(:,1)+wl_shift+wl2;
s9(:,1) = s9(:,1)+wl_shift;
s10(:,1) = s10(:,1)+wl_shift+wl2;
s11(:,1) = s11(:,1)+wl_shift+wl2;
s12(:,1) = s12(:,1)+wl_shift;

% indices peak1 for reversed scan direction:
i1 = find(s1(:,1)>74346.5,1,'first');
i2 = find(s1(:,1)>74350.5,1,'first');

% indices peak1 for normal scan direction:
i11 = find(s3(:,1)>74346.5,1,'first');
i21 = find(s3(:,1)>74350.5,1,'first');

peak1 = [s1(i1:i2,2) s2(i1:i2,2) s3(i11:i21,2) s4(i1:i2,2) s5(i1:i2,2) s6(i11:i21,2) s7(i11:i21,2) s8(i11:i21,2) ...
    s9(i1:i2,2) s10(i11:i21,2) s11(i11:i21,2) s12(i1:i2,2)];
sumpeak1 = sum(peak1,1);
[~,I] = max(peak1);

counter = 6900:-50:-100; % here: same for all owing to choice of wavelength direction
cpos_cw = [counter(I(3)+i11) counter(I(6)+i11) counter(I(7)+i11) counter(I(8)+i11) counter(I(10)+i11) counter(I(11)+i11)]
cpos_ccw = [counter(I(1)+i1) counter(I(2)+i1) counter(I(4)+i1) counter(I(5)+i1) counter(I(9)+i1) counter(I(12)+i1)]

% indices peak2 for reversed scan direction:
i1 = find(s1(:,1)>74354.0,1,'first');
i2 = find(s1(:,1)>74359.8,1,'first');

% indices peak2 for normal scan direction:
i11 = find(s3(:,1)>74354.0,1,'first');
i21 = find(s3(:,1)>74359.8,1,'first');

peak2 = [s1(i1:i2,2) s2(i1:i2,2) s3(i11:i21,2) s4(i1:i2,2) s5(i1:i2,2) s6(i11:i21,2) s7(i11:i21,2) s8(i11:i21,2) ...
    s9(i1:i2,2) s10(i11:i21,2) s11(i11:i21,2) s12(i1:i2,2)];
sumpeak2 = sum(peak2,1);
[~,I] = max(peak2);

counter = 6900:-50:-100; % here: same for all owing to choice of wavelength direction
cpos_cw = [counter(I(3)+i11) counter(I(6)+i11) counter(I(7)+i11) counter(I(8)+i11) counter(I(10)+i11) counter(I(11)+i11)]
cpos_ccw = [counter(I(1)+i1) counter(I(2)+i1) counter(I(4)+i1) counter(I(5)+i1) counter(I(9)+i1) counter(I(12)+i1)]

ratio = sumpeak2./sumpeak1;

figure_width  = 8;
figure_height = 4.5;
FontSize = 9;
% FontName = 'Arial';
LineWidth = 0.7;

figure10 = figure(10);
hold on
plot(Ubias, sumpeak1(4:end),'ro','MarkerSize',4,'MarkerFaceColor','r')
plot(Ubias, sumpeak2(4:end),'ko','MarkerSize',4,'MarkerFaceColor','k')
hold off
xlabel('$U_\textnormal{bias}$ (V)','FontSize',FontSize)
ylabel('Signal (arb.)','FontSize',FontSize)
hll = legend('$^2$D$_{3/2}$','$^2$D$_{5/2}$','Location',[0.3 0.7 0.1 0.1]);
legend boxoff
set(hll,'PlotBoxAspectRatioMode','manual');
set(hll,'PlotBoxAspectRatio',[0.5 1 1]);
axis([-20 220 0 10000])

set(gca, ...
  'FontSize'    , FontSize , ...
  'Box'         , 'on'     , ...
  'TickDir'     , 'in'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'off'      , ...
  'YMinorTick'  , 'off'      , ...
  'XGrid'       , 'off'      , ...
  'YGrid'       , 'off'      , ...
  'YTick'       , 0:2500:10000, ...
  'XTick'       , 0:50:200, ...
  'LineWidth'   , LineWidth);


set(gcf, 'units', 'centimeters', 'pos', [8 8 figure_width figure_height])
% set(gcf, 'Units', 'pixels', 'Position', [100 100 500 375]);
set(gcf, 'PaperPositionMode', 'auto');
set(gcf, 'Color', [1 1 1]); % Sets figure background
set(gca, 'Color', [1 1 1]); % Sets axes background
set(gcf, 'Renderer', 'painters');

print(figure10,'-depsc','peaks_Ubias','-r1000')
print(figure10,'-djpeg','peaks_Ubias','-r300')



figure_width  = 5;
figure_height = 4.5;
FontSize = 9;
% FontName = 'Arial';
LineWidth = 0.7;

figure11 = figure(11);
hold on
plot(pv, [sumpeak1(1) sumpeak1(10) sumpeak1(3)],'ro','MarkerSize',4,'MarkerFaceColor','r')
plot(pv, [sumpeak2(1) sumpeak2(10) sumpeak2(3)],'ko','MarkerSize',4,'MarkerFaceColor','k')
plot(pv(2:3), [sumpeak1(4) sumpeak1(2)],'r*','MarkerSize',4,'MarkerFaceColor','r')
plot(pv(2:3), [sumpeak2(4) sumpeak2(2)],'k*','MarkerSize',4,'MarkerFaceColor','k')
hold off
xlabel('$p_\textnormal{v}$ (bar)','FontSize',FontSize)
ylabel('Signal (arb.)','FontSize',FontSize)
hll = legend('$^2$D$_{3/2}$','$^2$D$_{5/2}$','Location',[0.45 0.7 0.1 0.1]);
legend boxoff
set(hll,'PlotBoxAspectRatioMode','manual');
set(hll,'PlotBoxAspectRatio',[0.5 0.7 1]);
axis([2.5 6 0 15000])

set(gca, ...
  'FontSize'    , FontSize , ...
  'Box'         , 'on'     , ...
  'TickDir'     , 'in'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'off'      , ...
  'YMinorTick'  , 'off'      , ...
  'XGrid'       , 'off'      , ...
  'YGrid'       , 'off'      , ...
  'YTick'       , 0:5000:15000, ...
  'XTick'       , 3:1.5:6, ...
  'LineWidth'   , LineWidth);


set(gcf, 'units', 'centimeters', 'pos', [8 8 figure_width figure_height])
% set(gcf, 'Units', 'pixels', 'Position', [100 100 500 375]);
set(gcf, 'PaperPositionMode', 'auto');
set(gcf, 'Color', [1 1 1]); % Sets figure background
set(gca, 'Color', [1 1 1]); % Sets axes background
set(gcf, 'Renderer', 'painters');

print(figure11,'-depsc','peaks_pv','-r1000')
print(figure11,'-djpeg','peaks_pv','-r300')


% N atom level holdings NIST:
level2D52 = 19224.464;
level2D32 = 19233.177;
level2S12 = 93581.550;

% wavenumber for transition:
d2D52 = (level2S12-level2D52);
d2D32 = (level2S12-level2D32);


figure_width  = 8;
figure_height = 4.5;
FontSize = 9;
% FontName = 'Arial';
LineWidth = 0.7;


figure1 = figure(1);
hold on
plot(d2D52*ones(100,1),linspace(-0.2,1.2,100)','r-','LineWidth',LineWidth)
plot(d2D32*ones(100,1),linspace(-0.2,1.2,100)','r-','LineWidth',LineWidth)

% plot(s1(:,1),s1(:,2)/max(s1(:,2)),'k-','LineWidth',LineWidth)
% plot(s2(:,1),s2(:,2)/max(s2(:,2)),'k-','LineWidth',LineWidth)
plot(s3(:,1),s3(:,2)/max(s3(:,2)),'k-','LineWidth',LineWidth)
% plot(s4(:,1),s4(:,2)/max(s4(:,2)),'k-','LineWidth',LineWidth)
% plot(s5(:,1),s5(:,2)/max(s5(:,2)),'k-','LineWidth',LineWidth)
% plot(s6(:,1),s6(:,2)/max(s6(:,2)),'k-','LineWidth',LineWidth)
% plot(s7(:,1),s7(:,2)/max(s7(:,2)),'k-','LineWidth',LineWidth)
% plot(s8(:,1),s8(:,2)/max(s8(:,2)),'k-','LineWidth',LineWidth)
% plot(s9(:,1),s9(:,2)/max(s9(:,2)),'k-','LineWidth',LineWidth)
% plot(s10(:,1),s10(:,2)/max(s10(:,2)),'k-','LineWidth',LineWidth)
% plot(s11(:,1),s11(:,2)/max(s11(:,2)),'k-','LineWidth',LineWidth)
% plot(s12(:,1),s12(:,2)/max(s12(:,2)),'k-','LineWidth',LineWidth)

% plot(s1(i1:i2,1),s1(i1:i2,2)/max(s1(:,2)),'r-','LineWidth',LineWidth)
% plot(s2(i1:i2,1),s2(i1:i2,2)/max(s2(:,2)),'r-','LineWidth',LineWidth)
% plot(s3(i11:i21,1),s3(i11:i21,2)/max(s3(:,2)),'r-','LineWidth',LineWidth)
% plot(s4(i1:i2,1),s4(i1:i2,2)/max(s4(:,2)),'r-','LineWidth',LineWidth)
% plot(s5(i1:i2,1),s5(i1:i2,2)/max(s5(:,2)),'r-','LineWidth',LineWidth)
% plot(s6(i11:i21,1),s6(i11:i21,2)/max(s6(:,2)),'r-','LineWidth',LineWidth)
% plot(s7(i11:i21,1),s7(i11:i21,2)/max(s7(:,2)),'r-','LineWidth',LineWidth)
% plot(s8(i11:i21,1),s8(i11:i21,2)/max(s8(:,2)),'r-','LineWidth',LineWidth)
% plot(s9(i1:i2,1),s9(i1:i2,2)/max(s9(:,2)),'r-','LineWidth',LineWidth)
% plot(s10(i11:i21,1),s10(i11:i21,2)/max(s10(:,2)),'r-','LineWidth',LineWidth)
% plot(s11(i11:i21,1),s11(i11:i21,2)/max(s11(:,2)),'r-','LineWidth',LineWidth)
% plot(s12(i1:i2,1),s12(i1:i2,2)/max(s12(:,2)),'r-','LineWidth',LineWidth)

hold off
xlabel('Two-Photon Wavenumber (cm$^{-1}$)','FontSize',FontSize)
ylabel('N Signal (norm.)','FontSize',FontSize)
axis([37172*2 37182*2 -0.1 1.5])

annotation('textbox', [.240 .785 .3 .1],'String','$^2$S$_{1/2}$ $\leftarrow$ $^2$D$_{3/2}$','FontSize',FontSize,'EdgeColor','none','Color','r','BackgroundColor','w');
annotation('textbox', [.532 .785 .3 .1],'String','$^2$S$_{1/2}$ $\leftarrow$ $^2$D$_{5/2}$','FontSize',FontSize,'EdgeColor','none','Color','r','BackgroundColor','w');

set(gca, ...
  'FontSize'    , FontSize , ...
  'Box'         , 'on'     , ...
  'TickDir'     , 'in'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'off'      , ...
  'YMinorTick'  , 'off'      , ...
  'XGrid'       , 'off'      , ...
  'YGrid'       , 'off'      , ...
  'YTick'       , 0:0.3:1.2, ...
  'XTick'       , 74344:6:74362, ...
  'XTickLabel',{'74344','74350','74356','74362'}, ... % else, it will show x10^4
  'LineWidth'   , LineWidth);


set(gcf, 'units', 'centimeters', 'pos', [8 8 figure_width figure_height])
% set(gcf, 'Units', 'pixels', 'Position', [100 100 500 375]);
set(gcf, 'PaperPositionMode', 'auto');
set(gcf, 'Color', [1 1 1]); % Sets figure background
set(gca, 'Color', [1 1 1]); % Sets axes background
set(gcf, 'Renderer', 'painters');

print(figure1,'-depsc','example_wl','-r1000')
print(figure1,'-djpeg','example_wl','-r300')

