%% N2 wavelength scans
% laser detection
% PB_TESTING0506y14
% 0311y14
% Tvalve = -100 deg C

close all
clear all

set(0,'defaulttextinterpreter','latex')
set(0,'DefaultTextFontname', 'Symbol')
set(0,'DefaultAxesFontName', 'Symbol')


% str = 'N2_2p6bar_150V_m100';
% str = 'N2_4p0bar_150V_m100';
% str = 'N2_5p6bar_0V_m100';
% str = 'N2_5p6bar_150V2_m100';
% str = 'N2_4p0bar_0V_m100';
% str = 'N2_4p0bar_100V_m100';
% str = 'N2_4p0bar_200V_m100';
% str = 'N2_4p0bar_50V_m100';
% str = 'N2_4p0bar_30V_m100';
% str = 'N2_4p0bar_180V_m100';
% str = 'N2_4p0bar_130V_m100';
str = 'N2_4p0bar_80V_m100';

str1 = strcat(str,'.mat');
str2 = strcat(str,'.txt');


% load file, use "raw" data (no baseline correction):
load(str1)


step = expparams.resolutionscan;
scanwidth = expparams.scanwidth; % wavelength range (in steps)
scanrange = (0:step:scanwidth)';
% these to parameters are not auto-saved yet!!
gratingorder = 5;
onestep = 1.8222e-05; % approximate wavelength difference (in nm) for 1 step with the stepper motor
% (for dye fundamental; measured with Burleigh WA 4500)
% see C:\Daten\Dissertation\Zeeman_data\H\H2308y12

scandir = expparams.scandir;
grating = expparams.grating;
scanint = 1E7./(grating/(gratingorder*10)+scandir*onestep*scanrange); % see manual PDL3
    % forward in wavelength = +1
    % backward in wavelength = -1
wavenostart = scanint(1);
scanint = scanint-wavenostart;

% gratingstart = 26908.4
% gratingend = 26901.85
gratingstart = 26901.85
gratingend = 26908.4
gratingrange = linspace(gratingstart,gratingend,length(scanint))';

% N atom level holdings NIST:
level2D52 = 19224.464;
level2D32 = 19233.177;
level2S12 = 93581.550;

% wavenumber for transition:
d2D52 = (level2S12-level2D52);
d2D32 = (level2S12-level2D32);


% grating to wavelength (from calibration_grating)
% incl. He* data points:
P = [0.099976961496645, 0.025407874590386];
% without He* data points: % MUCH BETTER FIT!!
% P = [0.099903250246361, 0.399928405457710];
% without He* and N* data points: % to check consistency (fit not only that
% good because we include the N* data in the original calibration fit)
% P = [0.099831641312900, 0.752415572385417];
lambda_cal = P(1)*gratingrange/gratingorder + P(2);

waveno_cal = 1./(lambda_cal*1E-7);

%% MCP signal (Neville amplifier)
%

ydatas = -yuc;
xdatas = xuc;

% baseline:
r1 = find(xdatas >= 3.0,1,'first');
r2 = find(xdatas >= 3.04,1,'first');
r1r2 = r1:r2;

v1 = find(xdatas >= 3.041,1,'first');
v2 = find(xdatas >= 3.054,1,'first');

ydatasc = zeros(size(ydatas));
for o = 1:size(ydatas,1)
    offs = mean(ydatas(o,r1r2)); % offset
	ydatasc(o,:) = ydatas(o,:) - offs;
end

wl_max = zeros(size(ydatasc,1),1);
imax = zeros(size(ydatasc,1),1);
figure(1)
for o = 1:size(ydatasc,1)
    plot(xdatas,ydatasc(o,:)','k-','LineWidth',1.0)
    hold on
	plot(xdatas(v1:v2),ydatasc(o,v1:v2)','r-','LineWidth',1.0)
    [wl_max(o,1) imax(o,1)] = max(ydatasc(o,v1:v2)); % peak detection; record index to get ion TOF position
end
hold off
xlabel('Ion TOF ($\mu$s)','FontSize',16)
ylabel('Signal (arb.)','FontSize',16)
set(gca,'FontSize',16)
axis([xdatas(1) xdatas(end) -3 220])

wl_sum = sum(ydatasc(:,v1:v2),2);

NionTOF = mean(xdatas(v1+imax-1))
NionTOFdev = std(xdatas(v1+imax-1))


% sort rows such that lowest wavenumber comes first:
[waveno_cal,isort] = sortrows(waveno_cal);
gratingrange = gratingrange(isort);
wl_sum = wl_sum(isort);

%% Wavelength scan
% plot two-photon wavenumber (269/2 nm!)


figure_width  = 8;
figure_height = 4.5;
FontSize = 9;
% FontName = 'Arial';
LineWidth = 0.7;


% wl_shift = -4.6; % if N* data are omitted in the calibration
wl_shift = 0; % if N* data are taken into account in the calibration
% wl_shift = 2.2; % if all calibration data are taken into account in the calibration

% plot intensity of the strongest peak as a function of wavelength
figure3 = figure(3);
hold on
plot(d2D52*ones(100,1),linspace(-20,500,100)','r-','LineWidth',LineWidth)
plot(d2D32*ones(100,1),linspace(-20,500,100)','r-','LineWidth',LineWidth)
plot(4*waveno_cal(1:end)+wl_shift,wl_sum(1:end)/max(wl_sum(1:end)),'k-','LineWidth',LineWidth) % 2w (doubled light)
% plot(2*2*waveno_cal(1:end)-wl_0+wl_shift,wl_max(1:end)*5,'r-','LineWidth',LineWidth) % 2w (doubled light)
hold off
xlabel('Two-Photon Wavenumber (cm$^{-1}$)','FontSize',FontSize)
ylabel('N Signal (norm.)','FontSize',FontSize)
axis([37172*2 37182*2 -0.1 1.3])

% annotation('textbox', [.2 .5 .1 .1],'String',strcat('+',num2str(round((wl_0+wl_shift)*10)/10),' cm^-^1'),'FontSize',16,'EdgeColor','none','Tag','tbox');
annotation('textbox', [.240 .785 .3 .1],'String','$^2$S$_{1/2}$ $\leftarrow$ $^2$D$_{3/2}$','FontSize',FontSize,'EdgeColor','none','Color','r','BackgroundColor','w');
annotation('textbox', [.532 .785 .3 .1],'String','$^2$S$_{1/2}$ $\leftarrow$ $^2$D$_{5/2}$','FontSize',FontSize,'EdgeColor','none','Color','r','BackgroundColor','w');

set(gca, ...
  'FontSize'    , FontSize , ...
  'Box'         , 'on'     , ...
  'TickDir'     , 'in'     , ...
  'TickLength'  , [.02 .02] , ...
  'XMinorTick'  , 'off'      , ...
  'YMinorTick'  , 'off'      , ...
  'XGrid'       , 'off'      , ...
  'YGrid'       , 'off'      , ...
  'YTick'       , 0:0.3:1.2, ...
  'XTick'       , 74344:6:74362, ...
  'XTickLabel',{'74344','74350','74356','74362'}, ... % else, it will show x10^4
  'LineWidth'   , LineWidth);


set(gcf, 'units', 'centimeters', 'pos', [8 8 figure_width figure_height])
% set(gcf, 'Units', 'pixels', 'Position', [100 100 500 375]);
set(gcf, 'PaperPositionMode', 'auto');
set(gcf, 'Color', [1 1 1]); % Sets figure background
set(gca, 'Color', [1 1 1]); % Sets axes background
set(gcf, 'Renderer', 'painters');

print(figure3,'-depsc',str,'-r1000')
print(figure3,'-djpeg',str,'-r300')

trace = [4*waveno_cal(1:end)+wl_shift wl_sum];
trace4gratingdet = [gratingrange wl_sum wl_max];

dlmwrite(str2, trace, 'delimiter', '\t','precision', 12)
% dlmwrite(str2, trace4gratingdet , 'delimiter', '\t','precision', 12)


%% Fit to distribution function to find the FWHM of the N lines
%

Gauss = 0

xdata = 4*waveno_cal(1:end);
it = find(xdata<=2*37175,1,'last');

peak1 = 0

if peak1 == 1
    % peak 1:
    xdata = 4*waveno_cal(1:it);
    ydata = wl_sum(1:it)/max(wl_sum(1:it));
    mu0 = 2*37172.5;
else
    % peak 2:
    xdata = 4*waveno_cal(it:end);
    ydata = wl_sum(it:end)/max(wl_sum(it:end));
    mu0 = 2*37177;
end

if Gauss == 1

% a) Gaussian
sigma = 0.5;

vGo=     [mu0, sigma];
lowerb = [2*37170, 0];
higherb = [2*37180, 5];
fprintf('Start: mu=%G  sigma=%G\n',vGo(1),vGo(2));
options=optimset('MaxFunEvals',1E9,'TolFun',1e-12,'TolX',1E-12,'MaxIter',1E5);
[vFit,resnorm,residual,exitflag,output] = lsqcurvefit(@wlfitGauss,vGo,xdata,ydata,lowerb,higherb,options);
P_n=wlfitGauss(vFit,xdata);
fprintf('Fit: mu=%G  sigma=%G\n',vFit(1),vFit(2))

FWHM = 2*sqrt(2*log(2))*vFit(2)

else
    
% b) Lorentzian
width = 0.5;

vGo=     [mu0, width];
lowerb = [2*37170, 0];
higherb = [2*37180, 5];
fprintf('Start: mu=%G  width=%G\n',vGo(1),vGo(2));
options=optimset('MaxFunEvals',1E9,'TolFun',1e-12,'TolX',1E-12,'MaxIter',1E5);
[vFit,resnorm,residual,exitflag,output] = lsqcurvefit(@wlfitLorentz,vGo,xdata,ydata,lowerb,higherb,options);
P_n=wlfitLorentz(vFit,xdata);
fprintf('Fit: mu=%G  width=%G\n',vFit(1),vFit(2))

FWHM = vFit(2)
    
end

%% Compare with experimental data
%

figure4 = figure(4);
hold on
plot(xdata,ydata,'k-','LineWidth',1.0)
plot(xdata,P_n,'r-','LineWidth',1.0);
hold off
xlabel('Two-Photon Wavenumber (cm$^{-1}$)','FontSize',FontSize)
ylabel('Signal (arb.)','FontSize',FontSize)
box on
axis([2*37172 2*37182 0 1.1])
set(gca,'FontSize',16)
legend('data','model',1)

% i1 = find(P_n>0.5,1,'first');
% i2 = find(P_n>0.5,1,'last');
% FWHMcheckfit = xdata(i2)-xdata(i1)
% 
% i1 = find(ydata>0.5,1,'first');
% i2 = find(ydata>0.5,1,'last');
% FWHMcheckdata = xdata(i2)-xdata(i1)
