%% TOF scans for different decelerator settings
% Here: N deceleration, 20 mus and 50 mus pulse duration, 460 mps, 400 mps

clf
clc 
clear all
close all

set(0,'defaulttextinterpreter','latex')
set(0,'DefaultTextFontname','Symbol')
set(0,'DefaultAxesFontName','Symbol')

niceg = [1 0 0];

% a) experiment:

defaultfolder = pwd;

cd('experimental_results')

    m1_50 = load('N2Ar_460mps_m1_15musincpl_50mus_allcombined.txt');
    m1_20 = load('N2Ar_460mps_m1_15musincpl_20mus_allcombined.txt');
    m1_50_400 = load('N2Ar_400mps_m1_15musincpl_50mus_allcombined.txt');

cd(defaultfolder)


% b) theory:

cd('simulation_results_Oct2015')

    cd('460mps_50mus_vary3Dvz\output_460_-1_2_470')
        m1_50_theory = load('output_460_-1_2.txt');
        m1_50_B = load('TOFvz_mesh1.txt');
        m1_50_A = load('TOFvz_mesh2.txt');
        m1_50_fvzTOFhist = load('TOFvz_mesh3.txt');
        m1_50_ppl1 = load('TOFvz_hull1.txt');
        m1_50_ppl2 = load('TOFvz_hull2.txt');
        
    cd('..\..\')

    cd('460mps_20mus_vary3Dvz\output_460_-1_2_470')
        m1_20_theory = load('output_460_-1_2.txt');
        m1_20_B = load('TOFvz_mesh1.txt');
        m1_20_A = load('TOFvz_mesh2.txt');
        m1_20_fvzTOFhist = load('TOFvz_mesh3.txt');
        m1_20_ppl1 = load('TOFvz_hull1.txt');
        m1_20_ppl2 = load('TOFvz_hull2.txt');
        
        m1_20_V = load('ifvz1.txt');
        m1_20_W = load('ifvz2.txt');
        m1_20_N = load('ifvz3.txt');
        
    cd('..\..\')
    
    cd('400mps_50mus_vary3Dvz\output_400_-1_2_470')
        m1_50_400_theory = load('output_400_-1_2.txt');
        m1_50_400_B = load('TOFvz_mesh1.txt');
        m1_50_400_A = load('TOFvz_mesh2.txt');
        m1_50_400_fvzTOFhist = load('TOFvz_mesh3.txt');
        m1_50_400_ppl1 = load('TOFvz_hull1.txt');
        m1_50_400_ppl2 = load('TOFvz_hull2.txt');

cd(defaultfolder)


scalef = max(max(m1_50_fvzTOFhist))

figure_width  = 18;
figure_height = 15;
FontSize = 11.5;
Linewidth = 0.8;

figure1 = figure(1);
% ha = tight_subplot(4,3,[.02 .01],[.17 .09],[.10 .02]);
ha = tight_subplot(4,3,[.02 .01],[.10 .09],[.10 .02]);
for kk = 1:12
    
axes(ha(kk)); 

if kk == 1
    hold on
    plot(m1_50(:,1),m1_50(:,2)/max(m1_50(:,2)),'k-','Linewidth',Linewidth)
    plot(m1_50(:,1),m1_50(:,3)/max(m1_50(:,2)),'-','Color',niceg,'Linewidth',Linewidth)
    hold off
	set(gca,'XTickLabel','')
    ylabel('$N$ (arb.)','FontSize',FontSize)
    axis([390 760 -0.1 1.2])
    set(gca,'YTick',0:0.5:1.5)
end
if kk == 2
    hold on
    plot(m1_20(:,1),m1_20(:,2)/max(m1_20(:,2)),'k-','Linewidth',Linewidth)
    plot(m1_20(:,1),m1_20(:,3)/max(m1_20(:,2)),'-','Color',niceg,'Linewidth',Linewidth)
    hold off
	set(gca,'XTickLabel','')
	set(gca,'YTickLabel','')
    axis([390 760 -0.1 1.2])
    set(gca,'YTick',0:0.5:1.5)
end
if kk == 3
    hold on
    plot(m1_50_400(:,1),m1_50_400(:,2)/max(m1_50_400(:,2)),'k-','Linewidth',Linewidth)
    plot(m1_50_400(:,1),m1_50_400(:,3)/max(m1_50_400(:,2)),'-','Color',niceg,'Linewidth',Linewidth)
    hold off
	set(gca,'XTickLabel','')
	set(gca,'YTickLabel','')
    axis([390 760 -0.1 1.2])
    set(gca,'YTick',0:0.5:1.5)
end

if kk == 4
    hold on
    plot(m1_50_theory(:,1),m1_50_theory(:,2)/max(m1_50_theory(:,2)),'k-','Linewidth',Linewidth)
    plot(m1_50_theory(:,1),m1_50_theory(:,3)/max(m1_50_theory(:,2)),'-','Color',niceg,'Linewidth',Linewidth)
    hold off
	set(gca,'XTickLabel','')
    ylabel('$N$ (arb.)','FontSize',FontSize)
    axis([390 760 -0.1 1.2])
    set(gca,'YTick',0:0.5:1.5)
end
if kk == 5
    hold on
    plot(m1_20_theory(:,1),m1_20_theory(:,2)/max(m1_20_theory(:,2)),'k-','Linewidth',Linewidth)
    plot(m1_20_theory(:,1),m1_20_theory(:,3)/max(m1_20_theory(:,2)),'-','Color',niceg,'Linewidth',Linewidth)
    hold off
	set(gca,'XTickLabel','')
	set(gca,'YTickLabel','')
    axis([390 760 -0.1 1.2])
    set(gca,'YTick',0:0.5:1.5)
end
if kk == 6
    hold on
    plot(m1_50_400_theory(:,1),m1_50_400_theory(:,2)/max(m1_50_400_theory(:,2)),'k-','Linewidth',Linewidth)
    plot(m1_50_400_theory(:,1),m1_50_400_theory(:,3)/max(m1_50_400_theory(:,2)),'-','Color',niceg,'Linewidth',Linewidth)
    hold off
	set(gca,'XTickLabel','')
	set(gca,'YTickLabel','')
    axis([390 760 -0.1 1.2])
    set(gca,'YTick',0:0.5:1.5)
end

if kk == 7
    hold on
    plot(m1_50(:,1),(m1_50(:,3)-m1_50(:,2))/max(m1_50(:,2)),'b-','Linewidth',Linewidth)
	plot(m1_50_theory(:,1),(m1_50_theory(:,3)-m1_50_theory(:,2))/max(m1_50_theory(:,2)),'-','Color',[0.5 0.5 0.5],'Linewidth',Linewidth)
    hold off
    set(gca,'XTickLabel','')
    ylabel('$\Delta N$ (arb.)','FontSize',FontSize)
    axis([390 760 -0.15 0.3])
    set(gca,'YTick',-0.1:0.2:0.3)
end
if kk == 8
    hold on
    plot(m1_20(:,1),(m1_20(:,3)-m1_20(:,2))/max(m1_20(:,2)),'b-','Linewidth',Linewidth)
	plot(m1_20_theory(:,1),(m1_20_theory(:,3)-m1_20_theory(:,2))/max(m1_20_theory(:,2)),'-','Color',[0.5 0.5 0.5],'Linewidth',Linewidth)
	hold off
    set(gca,'XTickLabel','')
	set(gca,'YTickLabel','')
    axis([390 760 -0.15 0.3])
    set(gca,'YTick',-0.1:0.2:0.3)
end
if kk == 9
    hold on
    plot(m1_50_400(:,1),2*(m1_50_400(:,3)-m1_50_400(:,2))/max(m1_50_400(:,2)),'b-','Linewidth',Linewidth)
	plot(m1_50_400_theory(:,1),2*(m1_50_400_theory(:,3)-m1_50_400_theory(:,2))/max(m1_50_400_theory(:,2)),'-','Color',[0.5 0.5 0.5],'Linewidth',Linewidth)
    hold off
    set(gca,'XTickLabel','')
	set(gca,'YTickLabel','')
    axis([390 760 -0.15 0.3])
    set(gca,'YTick',-0.1:0.2:0.3)
end

if kk == 10
    hold on
    contourf(m1_50_B,m1_50_A,m1_50_fvzTOFhist/scalef,40,'LineColor','none')
    plot(m1_50_ppl1(:,1),m1_50_ppl1(:,2),'r-','Linewidth',Linewidth-0.1)
    plot(m1_50_ppl2(:,1),m1_50_ppl2(:,2),'r-','Linewidth',Linewidth-0.1)
    hold off
	xlabel('TOF ($\mu$s)','FontSize',FontSize)
    ylabel('$v_z$ (m/s)','FontSize',FontSize)
%     axis([390 760 320 590 0 max(max(m1_50_fvzTOFhist)) 0 max(max(m1_50_fvzTOFhist))])
    axis([390 760 320 590 0 1 0 1])
    set(gca,'YTick',320:80:600)
end

if kk == 11 % *(20/50) to account for the different pulse durations and the according change in intensity
    hold on
    contourf(m1_20_B,m1_20_A,m1_20_fvzTOFhist/scalef*(20/50),40,'LineColor','none') 
    plot(m1_20_ppl1(:,1),m1_20_ppl1(:,2),'r-','Linewidth',Linewidth-0.1)
    plot(m1_20_ppl2(:,1),m1_20_ppl2(:,2),'r-','Linewidth',Linewidth-0.1)
    hold off
	xlabel('TOF ($\mu$s)','FontSize',FontSize)
%     axis([390 760 320 590 0 max(max(m1_20_fvzTOFhist)) 0 max(max(m1_20_fvzTOFhist))])
    axis([390 760 320 590 0 1 0 1])
	set(gca,'YTickLabel','')
    set(gca,'YTick',320:80:600)
end

if kk == 12
    hold on
    contourf(m1_50_400_B,m1_50_400_A,m1_50_400_fvzTOFhist/scalef,40,'LineColor','none') 
    plot(m1_50_400_ppl1(:,1),m1_50_400_ppl1(:,2),'r-','Linewidth',Linewidth-0.1)
    plot(m1_50_400_ppl2(:,1),m1_50_400_ppl2(:,2),'r-','Linewidth',Linewidth-0.1)
    hold off
	xlabel('TOF ($\mu$s)','FontSize',FontSize)
%     axis([390 760 320 590 0 max(max(m1_50_400_fvzTOFhist)) 0 max(max(m1_50_400_fvzTOFhist))])
    axis([390 760 320 590 0 1 0 1])
	set(gca,'YTickLabel','')
    set(gca,'YTick',320:80:600)
    
    colorbar('Location','East')
    h_bar = findobj(gcf,'Tag','Colorbar');
    % After you have the handle, you can use something like the following to
    % reduce its size by half vertically and horizontally (as well as the tick
    % labels) and keep it centered:
    initpos = get(h_bar,'Position');
    initfontsize = get(h_bar,'FontSize');
    set(h_bar,'FontSize',FontSize-1)
    set(h_bar,'ycolor','w','xcolor','w')
    % set(h_bar,'Position',[initpos(1)+initpos(3)*0.5 initpos(2)+initpos(4)*0.5 ...
    %       initpos(3)*0.5 initpos(4)*0.5])
    % set(h_bar,'Position',[0.53 0.37+0.39 initpos(3)*0.5 initpos(4)*0.5])
    set(h_bar,'Position',[initpos(1)+0.013 initpos(2)+0.06 initpos(3)*0.35 initpos(4)*0.55])

end

set(gca,'FontSize',FontSize)
box on
end
set(ha,'XTick',420:100:760)

% % annotation('rectangle',[x y w h])
% annotation('rectangle',[0.10 0.17 0.214 0.74],'Color','r','Linewidth',Linewidth*2)
% annotation('rectangle',[0.767 0.17 0.214 0.74],'Color','r','Linewidth',Linewidth*2)
% annotation('rectangle',[0.323 0.17 0.434 0.74],'Color','k','Linewidth',Linewidth*2)
% 
annotation('textbox', [.16 .86 .1 .1],'String','460 m/s, 50 $\mu$s','FontSize',FontSize,'EdgeColor','none');
annotation('textbox', [.455 .86 .1 .1],'String','460 m/s, 20 $\mu$s','FontSize',FontSize,'EdgeColor','none');
annotation('textbox', [.752 .86 .1 .1],'String','400 m/s, 50 $\mu$s','FontSize',FontSize,'EdgeColor','none');

annotation('textbox', [.74 .36 .1 .1],'String','x2','FontSize',FontSize,'EdgeColor','none');

annotation('textbox', [.11 .79 0.35 .1],'String','(a)','FontSize',FontSize,'EdgeColor','none','Color','k','BackgroundColor','none');
annotation('textbox', [.408 .79 0.35 .1],'String','(b)','FontSize',FontSize,'EdgeColor','none','Color','k','BackgroundColor','none');
annotation('textbox', [.706 .79 0.35 .1],'String','(c)','FontSize',FontSize,'EdgeColor','none','Color','k','BackgroundColor','none');

annotation('textbox', [.11 .79-0.209 0.35 .1],'String','(d)','FontSize',FontSize,'EdgeColor','none','Color','k','BackgroundColor','none');
annotation('textbox', [.408 .79-0.209 0.35 .1],'String','(e)','FontSize',FontSize,'EdgeColor','none','Color','k','BackgroundColor','none');
annotation('textbox', [.706 .79-0.209 0.35 .1],'String','(f)','FontSize',FontSize,'EdgeColor','none','Color','k','BackgroundColor','none');

annotation('textbox', [.11 .79-2*0.209 0.35 .1],'String','(g)','FontSize',FontSize,'EdgeColor','none','Color','k','BackgroundColor','none');
annotation('textbox', [.408 .79-2*0.209 0.35 .1],'String','(h)','FontSize',FontSize,'EdgeColor','none','Color','k','BackgroundColor','none');
annotation('textbox', [.706 .79-2*0.209 0.35 .1],'String','(i)','FontSize',FontSize,'EdgeColor','none','Color','k','BackgroundColor','none');

annotation('textbox', [.11 .79-3*0.209 0.35 .1],'String','(j)','FontSize',FontSize,'EdgeColor','none','Color','w','BackgroundColor','none');
annotation('textbox', [.408 .79-3*0.209 0.35 .1],'String','(k)','FontSize',FontSize,'EdgeColor','none','Color','w','BackgroundColor','none');
annotation('textbox', [.706 .79-3*0.209 0.35 .1],'String','(l)','FontSize',FontSize,'EdgeColor','none','Color','w','BackgroundColor','none');

set(gcf, 'units', 'centimeters', 'pos', [8 2 figure_width figure_height])
% set(gcf, 'Units', 'pixels', 'Position', [100 100 500 375]);
set(gcf, 'PaperPositionMode', 'auto');
set(gcf, 'Color', [1 1 1]); % Sets figure background
set(gca, 'Color', [1 1 1]); % Sets axes background
set(gcf,'Renderer','painters'); 

set(ha, ...
  'Layer', 'top', ...
  'Box'         , 'on'     , ...
  'TickDir'     , 'in'     , ...
  'TickLength'  , [.025 .025] , ...
  'XMinorTick'  , 'off'      , ...
  'YMinorTick'  , 'off'      , ...
  'XGrid'       , 'off'      , ...
  'YGrid'       , 'off');

print(gcf, '-r1000', 'comp_Ndeceleration.eps', '-depsc');


figure_width  = 8*1.3;
figure_height = 6.9*1.3;
FontSize = 11.5;
Linewidth = 0.8;

figure2 = figure(2);
hold on
contourf(m1_20_V,m1_20_W,m1_20_N./max(max(m1_20_N)),40,'LineColor','none') 
plot(linspace(300,800,1000)',linspace(300,800,1000)','k-','LineWidth',Linewidth)
plot(linspace(460,525,1000)',405*ones(1000,1),'w-','LineWidth',0.5)
plot(linspace(460,525,1000)',430*ones(1000,1),'w-','LineWidth',0.5)
plot(linspace(455,525,1000)',445*ones(1000,1),'w-','LineWidth',0.5)
plot(linspace(410,450,1000)',460*ones(1000,1),'w-','LineWidth',0.5)
plot(linspace(410,445,1000)',470*ones(1000,1),'w-','LineWidth',0.5)
plot(linspace(410,445,1000)',485*ones(1000,1),'w-','LineWidth',0.5)
hold off
xlabel('initial $v_{z}$ (m/s)','FontSize',FontSize);
ylabel('final $v_{z}$ (m/s)','FontSize',FontSize);
axis([360 580 360 580 0 1 0 1])
% how to invert the colormap:
% colormap hot; % select the colormap you wish to invert
% cmap = colormap; % get the matrix containing that colormap
% cmap = flipud(cmap); % flip the matrix:
% colormap(cmap); % apply the new inverted colormap:

    colorbar('Location','East')
    h_bar = findobj(gcf,'Tag','Colorbar');
    % After you have the handle, you can use something like the following to
    % reduce its size by half vertically and horizontally (as well as the tick
    % labels) and keep it centered:
    initpos = get(h_bar,'Position');
    initfontsize = get(h_bar,'FontSize');
    set(h_bar,'FontSize',FontSize-1)
    set(h_bar,'ycolor','w','xcolor','w')
    % set(h_bar,'Position',[initpos(1)+initpos(3)*0.5 initpos(2)+initpos(4)*0.5 ...
    %       initpos(3)*0.5 initpos(4)*0.5])
    % set(h_bar,'Position',[0.53 0.37+0.39 initpos(3)*0.5 initpos(4)*0.5])
    set(h_bar,'Position',[initpos(1)-0.01 initpos(2)+0.4 initpos(3)*0.55 initpos(4)*0.25])

annotation('textbox', [.281 .57 .1 .1],'String','$M_J$','FontSize',FontSize-1.5,'EdgeColor','none','Color','w');
annotation('textbox', [.27 .505 .1 .1],'String','-5/2','FontSize',FontSize-1.5,'EdgeColor','none','Color','w');
annotation('textbox', [.27 .45 .1 .1],'String','-3/2','FontSize',FontSize-1.5,'EdgeColor','none','Color','w');
annotation('textbox', [.27 .41 .1 .1],'String','-1/2','FontSize',FontSize-1.5,'EdgeColor','none','Color','w');
annotation('textbox', [.723 .36 .1 .1],'String','1/2','FontSize',FontSize-1.5,'EdgeColor','none','Color','w');
annotation('textbox', [.723 .30 .1 .1],'String','3/2','FontSize',FontSize-1.5,'EdgeColor','none','Color','w');
annotation('textbox', [.723 .213 .1 .1],'String','5/2','FontSize',FontSize-1.5,'EdgeColor','none','Color','w');

set(gcf, 'units', 'centimeters', 'pos', [8 2 figure_width figure_height])
% set(gcf, 'Units', 'pixels', 'Position', [100 100 500 375]);
set(gcf, 'PaperPositionMode', 'auto');
set(gcf, 'Color', [1 1 1]); % Sets figure background
set(gca, 'Color', [1 1 1]); % Sets axes background
set(gcf,'Renderer','painters'); 

set(gca, ...
  'Layer', 'top', ...
  'FontSize', FontSize, ...
  'Box'         , 'on'     , ...
  'TickDir'     , 'in'     , ...
  'TickLength'  , [.025 .025] , ...
  'XMinorTick'  , 'off'      , ...
  'YMinorTick'  , 'off'      , ...
  'XGrid'       , 'off'      , ...
  'YGrid'       , 'off');

print(gcf, '-r1000', '460_-1_2_470_20mus_initvsfinalvz.eps', '-depsc');



