function Plot_Mineralisation_rate()

t = linspace(0, 2*pi, 20000)';
delta_t = t(2);
omega = 1;
a = 140;
pressure = a*(1 - cos(2*pi*omega*t));

p_1 = 150;
K_2 = 10;
K_1 = 2;
T_1 = 0.25;
T_2 =0.6;

t_1 = zeros(11, 1);
t_2 = zeros(11, 1);

for i = 0:1:10
    t_1(i+1) = (1/(2*pi*omega))*( acos( 1 - p_1/140) + 2*i*pi);   % last time pressure  p= p_1 with increasing gradient
    t_2(i+1) = -(1/(2*pi*omega))*( acos( 1 - p_1/140) -2*(i+1)*pi);  % last time pressure p=p_1 with decreasing gradient 
    
end

K_p_model_1 = zeros(size(t));
K_p_model_2 = zeros(size(t));
K_p_model_3 = zeros(size(t));

Dep_higher = 0;
sum_at_p_1 = 0;
sum_at_k_2 = 0;



for i = 1:1:size(t,1)
   
    
    if(pressure(i) >= p_1)
        K_p_model_1(i) = K_2;
        
        if(i>2 && pressure(i-1) < p_1)
            sum_at_k_2 = 0;
        else
            sum_at_k_2 = sum_at_k_2 + delta_t;
        end
    
        
        if( sum_at_k_2 <= T_1)
            K_p_model_2(i) = K_2;
        else
            K_p_model_2(i) = K_1;
        end
        
        if(sum_at_k_2 <= T_1 && sum_at_p_1 >= T_2)
            K_p_model_3(i) = K_2;
            Dep_higher = 1;
        else
            K_p_model_3(i) = K_1;
        end
    else %% pressure < p_1
        if(i>2 && pressure(i-1) >=p_1 && Dep_higher == 1)
            sum_at_p_1 = 0;
            Dep_higher = 0;
        else
            sum_at_p_1 = sum_at_p_1 + delta_t;
        end
        
        
        K_p_model_1(i) = K_1;
        K_p_model_2(i) = K_1;
        K_p_model_3(i) = K_1;
    end
    
    
    
end

%%%%%%%%%%% Plot K_p model 1
figure6 = figure;


axes1 = axes('Parent',figure6,'YTickLabel',{'0',' ',' '},...
    'YTick',[0 2 10],...
    'YColor',[0 0 0],...
    'XTickLabel',{'0',' ',' ',' '},...
    'XTick',[1 2 3 4],...
    'Position',[0.13 0.110016420361248 0.775 0.814983579638752],...
    'FontSize',34);

 xlim(axes1,[1 4]);
 ylim(axes1,[0 10.25]);
hold(axes1,'all');

plot(t,K_p_model_1,'k', 'Parent',axes1, 'Linewidth', 2.3);
ylabel('k_p(t, p(t))','FontSize',34,'Color',[0 0 0]);



axes2 = axes('Parent',figure6,'YTickLabel',{'0','a','2a'},...
    'YTick',[0 140 280],'YAxisLocation','right',...
    'YColor',[0 0 0], 'FontSize',34, ...
    'XTickLabel',{'0',' ',' ',' '},...
    'XTick',[1 2 3 4],...
    'Position',[0.13 0.110016420361248 0.775 0.814983579638752],...
    'FontSize',34,...
    'ColorOrder',[0 0.5 0;1 0 0;0 0.75 0.75;0.75 0 0.75;0.75 0.75 0;0.25 0.25 0.25;0 0 1],...
    'Color','none');


 xlim(axes2,[1 4]);
 ylim(axes2,[0 310]);
hold(axes2,'all');

plot(t, pressure, 'k--','Parent',axes2, 'Linewidth', 2.3);


ylabel('Applied pressure','VerticalAlignment','cap','FontSize',34,...
    'Color',[0 0 0]);

hold on
plot(t, p_1*ones(size(t)), 'k-.','Parent',axes2, 'Linewidth', 2.3);



annotation(figure6,'textbox',...
    [0.362639824304539 0.0342510602717921 0.0451200585651537 0.0843558282208589],...
    'String',{'1/\omega'},...
    'FontSize',34,...
    'FitBoxToText','off',...
    'EdgeColor','none');


annotation(figure6,'textbox',...
    [0.624221083455345 0.0355975298941238 0.0451200585651537 0.0843558282208589],...
    'String',{'2/\omega'},...
    'FontSize',34,...
    'FitBoxToText','off',...
    'EdgeColor','none');


annotation(figure6,'textbox',...
    [0.865304538799415 0.0340388586802802 0.0451200585651537 0.0843558282208589],...
    'String',{'3/\omega'},...
    'FontSize',34,...
    'FitBoxToText','off',...
    'EdgeColor','none');

%
annotation(figure6,'textbox',...
    [0.080765739385067 0.88393907340808 0.0451200585651537 0.0843558282208589],...
    'String',{'k_2'},...
    'FontSize',34,...
    'FitBoxToText','off',...
    'EdgeColor','none');


annotation(figure6,'textbox',...
    [0.0878521229868239 0.229062226117441 0.0451200585651537 0.0843558282208589],...
    'String',{'k_1'},...
    'FontSize',34,...
    'FitBoxToText','off',...
    'EdgeColor','none');



saveas(figure6, 'Model_1_k_p', 'fig')

%%%%%%%%%%% Plot K_p model 2
figure7 = figure;


axes3 = axes('Parent',figure7,'YTickLabel',{'0',' ',' '},...
    'YTick',[0 2 10],...
    'YColor',[0 0 0],...
    'XTickLabel',{'0',' ',' ',' '},...
    'XTick',[1 2 3 4],...
    'Position',[0.13 0.110016420361248 0.775 0.814983579638752],...
    'FontSize',34);

 xlim(axes3,[1 4]);
 ylim(axes3,[0 10.25]);
hold(axes3,'all');

plot(t,K_p_model_2,'k', 'Parent',axes3, 'Linewidth', 2.3);
ylabel('k_p(t, p(t))','FontSize',34,'Color',[0 0 0]);



axes4 = axes('Parent',figure7,'YTickLabel',{'0','a','2a'},...
    'YTick',[0 140 280],'YAxisLocation','right',...
    'YColor',[0 0 0], 'FontSize',34, ...
    'XTickLabel',{'0',' ',' ',' '},...
    'XTick',[1 2 3 4],...
    'Position',[0.13 0.110016420361248 0.775 0.814983579638752],...
    'FontSize',34,...
    'ColorOrder',[0 0.5 0;1 0 0;0 0.75 0.75;0.75 0 0.75;0.75 0.75 0;0.25 0.25 0.25;0 0 1],...
    'Color','none');


 xlim(axes4,[1 4]);
 ylim(axes4,[0 310]);
hold(axes4,'all');

% Create plot
plot(t, pressure, 'k--','Parent',axes4, 'Linewidth', 2.3);

% Create ylabel
ylabel('Applied pressure','VerticalAlignment','cap','FontSize',34,...
    'Color',[0 0 0]);

hold on
plot(t, p_1*ones(size(t)), 'k-.','Parent',axes4, 'Linewidth', 2.3);




% 
% 
% [hAx,hLine1,hLine2] = plotyy(t, K_p_model_1, t, pressure);
% ylabel(hAx(1),'Substrate Deposition', 'Fontsize', 34) % left y-axis
% ylabel(hAx(2),'Applied pressure', 'Fontsize', 34) % right y-axis
% %hold on
% %plot(t, K_p_model_2, 'r--')
% %hold on
% %plot(t, K_p_model_3, 'k--')
% 
% 
% Create textbox
annotation(figure7,'textbox',...
    [0.362639824304539 0.0342510602717921 0.0451200585651537 0.0843558282208589],...
    'String',{'1/\omega'},...
    'FontSize',34,...
    'FitBoxToText','off',...
    'EdgeColor','none');

% Create textbox
annotation(figure7,'textbox',...
    [0.624221083455345 0.0355975298941238 0.0451200585651537 0.0843558282208589],...
    'String',{'2/\omega'},...
    'FontSize',34,...
    'FitBoxToText','off',...
    'EdgeColor','none');

% Create textbox
annotation(figure7,'textbox',...
    [0.865304538799415 0.0340388586802802 0.0451200585651537 0.0843558282208589],...
    'String',{'3/\omega'},...
    'FontSize',34,...
    'FitBoxToText','off',...
    'EdgeColor','none');

% Create textbox
annotation(figure7,'textbox',...
    [0.080765739385067 0.88393907340808 0.0451200585651537 0.0843558282208589],...
    'String',{'k_2'},...
    'FontSize',34,...
    'FitBoxToText','off',...
    'EdgeColor','none');

% Create textbox
annotation(figure7,'textbox',...
    [0.0878521229868239 0.229062226117441 0.0451200585651537 0.0843558282208589],...
    'String',{'k_1'},...
    'FontSize',34,...
    'FitBoxToText','off',...
    'EdgeColor','none');






saveas(figure7, 'Model_2_k_p', 'fig')




%%%%%%%%%%% Plot K_p model 3

figure8 = figure;


axes5 = axes('Parent',figure8,'YTickLabel',{'0',' ',' '},...
    'YTick',[0 2 10],...
    'YColor',[0 0 0],...
    'XTickLabel',{'0',' ',' ',' '},...
    'XTick',[1 2 3 4],...
    'Position',[0.13 0.110016420361248 0.775 0.814983579638752],...
    'FontSize',34);

 xlim(axes5,[1 4]);
 ylim(axes5,[0 10.25]);
hold(axes5,'all');

plot(t,K_p_model_3,'k', 'Parent',axes5, 'Linewidth', 2.3);
ylabel('k_p(t, p(t))','FontSize',34,'Color',[0 0 0]);



axes6 = axes('Parent',figure8,'YTickLabel',{'0','a','2a'},...
    'YTick',[0 140 280],'YAxisLocation','right',...
    'YColor',[0 0 0], 'FontSize',34, ...
    'XTickLabel',{'0',' ',' ',' '},...
    'XTick',[1 2 3 4],...
    'Position',[0.13 0.110016420361248 0.775 0.814983579638752],...
    'FontSize',34,...
    'ColorOrder',[0 0.5 0;1 0 0;0 0.75 0.75;0.75 0 0.75;0.75 0.75 0;0.25 0.25 0.25;0 0 1],...
    'Color','none');


 xlim(axes6,[1 4]);
 ylim(axes6,[0 310]);
hold(axes6,'all');

% Create plot
plot(t, pressure, 'k--','Parent',axes6, 'Linewidth', 2.3);

% Create ylabel
ylabel('Applied pressure','VerticalAlignment','cap','FontSize',34,...
    'Color',[0 0 0]);

hold on
plot(t, p_1*ones(size(t)), 'k-.','Parent',axes6, 'Linewidth', 2.3);





annotation(figure8,'textbox',...
    [0.362639824304539 0.0342510602717921 0.0451200585651537 0.0843558282208589],...
    'String',{'1/\omega'},...
    'FontSize',34,...
    'FitBoxToText','off',...
    'EdgeColor','none');


annotation(figure8,'textbox',...
    [0.624221083455345 0.0355975298941238 0.0451200585651537 0.0843558282208589],...
    'String',{'2/\omega'},...
    'FontSize',34,...
    'FitBoxToText','off',...
    'EdgeColor','none');


annotation(figure8,'textbox',...
    [0.865304538799415 0.0340388586802802 0.0451200585651537 0.0843558282208589],...
    'String',{'3/\omega'},...
    'FontSize',34,...
    'FitBoxToText','off',...
    'EdgeColor','none');

annotation(figure8,'textbox',...
    [0.080765739385067 0.88393907340808 0.0451200585651537 0.0843558282208589],...
    'String',{'k_2'},...
    'FontSize',34,...
    'FitBoxToText','off',...
    'EdgeColor','none');

annotation(figure8,'textbox',...
    [0.0878521229868239 0.229062226117441 0.0451200585651537 0.0843558282208589],...
    'String',{'k_1'},...
    'FontSize',34,...
    'FitBoxToText','off',...
    'EdgeColor','none');

saveas(figure8, 'Model_3_k_p', 'fig')
