close all
clear 

model_1_const_atm = importdata('Model_1/Model_1_const_atm.gpl');
model_2_const_atm = importdata('Model_2/Model_2_const_atm.gpl');
model_3_const_atm = importdata('Model_3/Model_3_const_atm.gpl');

model_1_int_cyc = importdata('Model_1/Model_1_int_cyc.gpl');
model_2_int_cyc = importdata('Model_2/Model_2_int_cyc.gpl');
model_3_int_cyc = importdata('Model_3/Model_3_int_cyc.gpl');


model_1_int_high = importdata('Model_1/Model_1_int_high.gpl');
model_2_int_high= importdata('Model_2/Model_2_int_high.gpl');
model_3_int_high = importdata('Model_3/Model_3_int_high.gpl');




figure1 =figure;
axes1 = axes('Parent',figure1,'XTick',[0 120 240 360 480],'FontSize',34);
plot(24*model_1_const_atm(:,1), model_1_const_atm(:,3), 'k',  24*model_1_int_cyc(:,1), model_1_int_cyc(:,3), 'k--', 24*model_1_int_high(:,1), model_1_int_high(:,3), 'k-.', 'Linewidth', 2.3)
xlabel('Time', 'Fontsize', 34)
ylabel('Mineral volume', 'Fontsize', 34)
legend1 = legend('Control', 'Oscillatory stimulation', 'Constant stimulation')';
set(legend1,'YColor',[1 1 1],'XColor',[1 1 1]);
box
xlim([0 480])
ylim([0 1])
set(gca, 'XTick', [0 120 240 360 480])
saveas(figure1, 'Model_1_Mineral_volume_3_loading_strategies', 'fig')





figure2 =figure;
axes2 = axes('Parent',figure2,'XTick',[0 120 240 360 480],'FontSize',34);
plot(24*model_2_const_atm(:,1), model_2_const_atm(:,3), 'k', 24* model_2_int_cyc(:,1), model_2_int_cyc(:,3), 'k--', 24*model_2_int_high(:,1), model_2_int_high(:,3), 'k-.', 'Linewidth', 2.3)
xlabel('Time', 'Fontsize', 34)
ylabel('Mineral volume', 'Fontsize', 34)
legend2 = legend('Control', 'Oscillatory stimulation', 'Constant stimulation');
set(legend2,'YColor',[1 1 1],'XColor',[1 1 1]);
box
xlim([0 480])
ylim([0 1])
set(gca, 'XTick', [0 120 240 360 480])
saveas(figure2, 'Model_2_Mineral_volume_3_loading_strategies', 'fig')



figure3 =figure;
axes3= axes('Parent',figure3,'XTick',[0 120 240 360 480],'FontSize',34);
plot(24*model_3_const_atm(:,1), model_3_const_atm(:,3), 'k', 24* model_3_int_cyc(:,1), model_3_int_cyc(:,3), 'k--',24* model_3_int_high(:,1), model_3_int_high(:,3), 'k-.', 'Linewidth', 2.3)
xlabel('Time', 'Fontsize', 34)
ylabel('Mineral volume', 'Fontsize', 34)
legend3 = legend('Control', 'Oscillatory stimulation', 'Constant stimulation');
set(legend3,'YColor',[1 1 1],'XColor',[1 1 1]);
box
xlim([0 480])
ylim([0 1])
set(gca, 'XTick', [0 120 240 360 480])
saveas(figure3, 'Model_3_Mineral_volume_3_loading_strategies', 'fig')


theta_m_20_model_1_const_atm = model_1_const_atm(find(model_1_const_atm(:,1)>=20, 1),3);
theta_m_20_model_2_const_atm = model_2_const_atm(find(model_2_const_atm(:,1)>=20, 1),3);
theta_m_20_model_3_const_atm = model_3_const_atm(find(model_3_const_atm(:,1)>=20, 1),3);
% 
% theta_m_20_model_1_int_cyc = model_1_int_cyc(find(model_1_int_cyc(:,1)>=20, 1),3);
% theta_m_20_model_2_int_cyc = model_2_int_cyc(find(model_2_int_cyc(:,1)>=20, 1),3);
% theta_m_20_model_3_int_cyc = model_3_int_cyc(find(model_3_int_cyc(:,1)>=20, 1),3);
% 
% theta_m_20_model_1_int_high = model_1_int_high(find(model_1_int_high(:,1)>=20, 1),3);
% theta_m_20_model_2_int_high = model_2_int_high(find(model_2_int_high(:,1)>=20, 1),3);
% theta_m_20_model_3_int_high = model_3_int_high(find(model_3_int_high(:,1)>=20, 1),3);
% 
% (theta_m_20_model_1_int_cyc/theta_m_20_model_1_const_atm -1)*100
% (theta_m_20_model_2_int_cyc/theta_m_20_model_2_const_atm -1)*100
% (theta_m_20_model_3_int_cyc/theta_m_20_model_3_const_atm -1)*100
% 
% 
% (theta_m_20_model_1_int_high/theta_m_20_model_1_const_atm -1)*100
% (theta_m_20_model_2_int_high/theta_m_20_model_2_const_atm -1)*100
% (theta_m_20_model_3_int_high/theta_m_20_model_3_const_atm -1)*100



frequency_model_1 = importdata('Frequency_Sweep/Model_1_Loop_frequency.gpl');
frequency_model_2 = importdata('Frequency_Sweep/Model_2_Loop_frequency.gpl');
frequency_model_3 = importdata('Frequency_Sweep/Model_3_Loop_frequency.gpl');
new_frequency_model_1(2:size(frequency_model_1,1)+1,:) = frequency_model_1;
new_frequency_model_1(1,2) = theta_m_20_model_1_const_atm;

amplitude_model_1 = importdata('Amplitude_Sweep/Model_1_Loop_amplitude.gpl');
amplitude_model_1vs2 = importdata('Amplitude_Sweep/Model_1_Loop_amplitude2.gpl');

amplitude_model_2 = importdata('Amplitude_Sweep/Model_2_Loop_amplitude.gpl');
amplitude_model_2vs2 = importdata('Amplitude_Sweep/Model_2_Loop_amplitude2.gpl');

amplitude_model_3 = importdata('Amplitude_Sweep/Model_3_Loop_amplitude.gpl');
amplitude_model_3vs2 = importdata('Amplitude_Sweep/Model_3_Loop_amplitude2.gpl');

total_amplitude_model_1 = amplitude_model_1;
total_amplitude_model_1(size(amplitude_model_1,1)+1:size(amplitude_model_1,1)+size(amplitude_model_1vs2,1),:) = amplitude_model_1vs2;

total_amplitude_model_2 = amplitude_model_2;
total_amplitude_model_2(size(amplitude_model_2,1)+1:size(amplitude_model_2,1)+size(amplitude_model_2vs2,1),:) = amplitude_model_2vs2;


total_amplitude_model_3 = amplitude_model_3;
total_amplitude_model_3(size(amplitude_model_3,1)+1:size(amplitude_model_3,1)+size(amplitude_model_3vs2,1),:) = amplitude_model_3vs2;

figure4=figure;
axes4 = axes('Parent',figure4,'FontSize',34);
plot(3600*new_frequency_model_1(:,1), new_frequency_model_1(:,2)-theta_m_20_model_1_const_atm, 'k', 3600* frequency_model_2(:,1), frequency_model_2(:,2)-theta_m_20_model_2_const_atm, 'k--',3600*  frequency_model_3(:,1), frequency_model_3(:,2)-theta_m_20_model_3_const_atm, 'k-.', 'Linewidth', 2.3)
xlabel('Frequency', 'Fontsize', 34)
ylabel('Increase in mineral volume', 'Fontsize', 34)
legend4 = legend('Model 1', 'Model 2', 'Model 3')';
xlim([0 30000])
set(legend4,'YColor',[1 1 1],'XColor',[1 1 1]);
set(gca, 'XTick', [0, 10000, 20000, 30000])
box
saveas(figure4, 'Frequency_sweeps', 'fig')


figure5=figure;
axes5 = axes('Parent',figure5,'FontSize',34);
plot(total_amplitude_model_1(:,1)/140, total_amplitude_model_1(:,2)-theta_m_20_model_1_const_atm, 'k',  total_amplitude_model_2(:,1)/140, total_amplitude_model_2(:,2)-theta_m_20_model_2_const_atm, 'k--', total_amplitude_model_3(:,1)/140, total_amplitude_model_3(:,2)-theta_m_20_model_3_const_atm, 'k-.', 'Linewidth', 2.3)
xlabel('Amplitude', 'Fontsize', 34)
ylabel('Increase in mineral volume', 'Fontsize', 34)
legend4 = legend('Model 1', 'Model 2', 'Model 3')';
set(legend4,'YColor',[1 1 1],'XColor',[1 1 1]);
xlim([0 5])
box
set(gca, 'XTick', [0, 0.5, 1, 2, 3, 3.36, 4, 5])
set(gca, 'XTickLabel', {'0','','1','2','3','','4','5'})
saveas(figure5, 'Amplitude_sweeps', 'fig')

Plot_Mineralisation_rate();
