%mode_coupling.m is just a little calculation to estimate the degree to
%which anti-Stokes scattering into higher-order cavity modes may contribute
%noise.
%
%Basically the idea is that higher-order cavity modes are shifted from the
%fundamental mode by some amount, which we set to be on the order of the
%linewidth so that the Stokes can be aligned. A higher-order anti-Stokes
%will be correlated with a higher-order spin-wave, and to produce noise
%this then needs to be coupled to the fundamental signal mode. Coupling
%between spatial modes is mediated by the control field, which is not a
%plane wave but also a Gaussian profile, following the fundamental cavity
%mode.
%
%So now the noise contribution will be proportional to the coupling
%integral
%
% int_x U0(x) U0(x) Up(x) dx,
%
% where U0 is a Gaussian (one for the signal and one for the control) and
% where Up is a higher-order mode, with index p ~ floor(F/2), where F is
% the cavity finesse (that is, there are roughly F/2 linewidths between the
% Stokes and anti-Stokes frequencies.

N = 100000;
X = 8;
dx = X/N;
x = dx:dx:X;
x = x-X/2;
ps = 0:2:20;
Is = ps;
U0 = exp(-x.^2);
K = sum( U0.*U0 )*dx;
U0 = U0/sqrt(K);

for j = 1:length(ps);
Up = U0.*hermite(x*sqrt(2),ps(j));
Up = Up/sqrt(sum( Up.*Up )*dx);

Is(j) = sum( U0.^2.*Up )*dx;

% figure(1);
% plot(x,[U0',Up']);
% xlabel('x');
% legend('U_0','U_p')

end

figure(1);
semilogy(ps,Is.^2);
xlabel('Index')
ylabel('Overlap')

beta = .5;
App = 0.5*10.^(-beta*ps);
figure(1)
hold all
semilogy(ps,App);
hold off
legend('Int','App')

