%chi_plot_2.m is totally unrelated to chi_plot.m, but I'm just re-visiting
%the problem of how chi varies with the reflectivity r.
%Now the forumula I'm using is:
%
% chi = (1-r^2) alpha / (1-r alpha),
%
% where r is the amplitude reflectivity of the input / output coupler, and
% where alpha is the rountrip transmission amplitude excluding reflection
% off the coupler (so alpha = 1 means no intra-cavity losses).

N = 100;
r = 1-logspace(-3,-.1,N)'; %reflectivities
alpha = 1-1e-2; %roundtrip transmission

chi = (1-r.^2)*alpha./(1-r*alpha);

chi_approx = (1+r).*( alpha.^(1./(1-r)) );

figure(1);
semilogx(1-r,[chi,chi_approx]);
xlabel('1-r');
ylabel('\chi');
legend('exact','approximate');

r_max = (1-sqrt(1-alpha^2))/alpha;

beta = log(1/alpha);
r_max_approx = 1+beta/2 - sqrt(beta*(2+beta/4));
theta = acos(sqrt(alpha));
%r_max_approx = 1-sqrt(2)*theta;

chi_max = 2*r_max_approx;

figure(1);
xl = xlim;
yl = ylim;
hold all
plot((1-r_max_approx)*[1 1],yl,'r:');
plot(xl,chi_max*[1 1],'g:');
hold off;

M = 100;
alphas = 1-logspace(-6,-1,N)';
eff_max = ( (1-sqrt(1-alphas.^2))./alpha ).^2;
figure(2);
semilogx(1-alphas,eff_max);
xlabel('1-\alpha')
ylabel('\eta_{max}');