%chi_plot.m just plots the variation of R1*chi with R1.

NR=1000; %number points for control energy scan
Nin = 0.1;

bandwidth_f = .1;% %bandwidth we want to store, in GHz
delta_cav_f = 3*bandwidth_f; %linewidth of cavity we want, at signal frequency
delta_cav = delta_cav_f*2*pi;

Temp = 273+70; %temperature in K (controls optical depth)
En = 3e-10;
m=0; %order of cavity (m = no. of cavity modes in between signal and control)
R2=1;%.999; %other mirror reflectivity (amplitude)
eta = 1;%0.99; %straight-through mirror 1 to mirror 2 transmission (input
%to output, if we're outcoupling from mirror 2)
alph = .999;%0.97;%0.98;.97;1; %remaining transmission (excluding atomic absorption)
R1=linspace(.5,.999,NR)';%.998;%.8;%.75;%.9; %input-coupler reflectivity

kB = 1.38065e-23; %Boltzmann's constant in J/K
c = 2.9979e8; %speed of light in m/s
epsilon = 8.85e-12; 
%permittivity of free space in F/m
hbar = 1.05e-34; %hbar in Js
gamma = .0164; %2 gamma = homogeneous linewidth. Units of (ns)^-1. (gamma = 2*pi * 5.2227 MHz / 2)

logP = 8.22127-4006.048/Temp-.00060194*Temp-.19623*log10(Temp); %logP gives the logarithm of the cesium pressure in torr
p = 133.322368*10^logP; %pressure in Pascals
n = p/kB/Temp; %number density in atoms per cubic metre
D = 1e-29; %cesium D2 dipole moment in Cm (roughly 1/3 of the full dipole moment, since the polarization is linear)
lambda = 852.347e-9; %D2 wavelength in nm
omega = 2*pi*c/lambda; %D2 angular frequency

delta_f=9.2; %Stokes shift in GHz
delta = delta_f*2*pi;
Df = 4*delta_f/(2*m+1); %Free spectral range
%Df = delta_f/(m+1);
L = c./Df/1e9 %rough estimate of cavity length required, neglecting group delay
d = 1*D^2*omega*n*L/2/epsilon/hbar/c/(gamma*1e9) %single-pass optical depth
%(factor of 11 out-front is inherited from the fit to cavity fringe data)

%d=8e3; %single-pass optical depth (put in "by hand")
DA_f = 5;%10*bandwidth_f; %detuning in GHz, to get adiabaticity
DS_f=DA_f+delta_f; %Stokes detuning in GHz

DA = DA_f*2*pi; %Blue detuning of signal field from red line (F=4 transtion) 
DS = DS_f*2*pi; %Stokes detuning in (ns)^-1
GA = gamma-1i*DA;
GS = gamma-1i*DS;
KTA = d*gamma/GA;
KTS = d*gamma/(gamma-1i*(DS+delta));
% Abs_A = exp(-d*(gamma/DA)^2); %single-pass linear absorption of signal
% Abs_S = exp(-d*(gamma/(DS+delta))^2); %single-pass linear absorption of noise
Abs_A = exp(-real(KTA)); %single-pass linear absorption of signal
Abs_S = exp(-real(KTS)); %single-pass linear absorption of noise

gamma_p = .16; %pressure linewidth in (ns)^-1
GAp = gamma_p-1i*DA;
GSp = gamma_p-1i*DS;
dp = d*gamma/gamma_p; %pressure-broadened optical depth.
KTAp = dp*gamma_p/GAp;
KTSp = dp*gamma_p/(gamma_p-1i*(DS+delta));

% Abs_p_A = exp(-dp*(gamma_p/DA)^2); %single-pass linear signal absorption with pressure broadening. (Just checking it's not huge).
% Abs_p_S = exp(-dp*(gamma_p/(DS+delta))^2); %single-pass linear noise absorption with pressure broadening. (Just checking it's not huge).
Abs_p_A = exp(-real(KTAp)); %single-pass linear signal absorption with pressure broadening. (Just checking it's not huge).
Abs_p_S = exp(-real(KTSp)); %single-pass linear noise absorption with pressure broadening. (Just checking it's not huge).

T1=sqrt(1-R1.^2); %corresponding amplitude transmission coefficients
T2=sqrt(1-R2^2);

T = eta*alph*Abs_p_A*R1*R2; %round-trip transmission, including all losses and mirror reflectivities

Topt = 1./(1+(pi*(m+1) + dp*gamma_p*delta^2/2/DA^2/DS )*delta_cav/delta);
%analytic expression for "optimal" roundtrip loss (i.e. the value of T that
%gives a pass-bandwidth of delta_cav, for the "no birefringent element" case)

R1opt = Topt/(eta*alph*Abs_p_A*R2); %corresponding "optimal" value of R1
%But note that R1opt is not the same as R_opt (dashed lines in plots) which
%is the value of R1 that maximizes the memory efficiency. Anyway, it's good
%if R1opt is close to R_opt, because then you get the bandwidth you want
%and a good efficiency.

%chi = T1*T2*eta./(1-T); %transmission parameter for outcoupling from behind mirror 2.

%chi = (T1.^2./R1).*T./(1-T); %same coupling

%chi = T1.^2*R1./(1-T); %same coupling
chi = T1.^2./(1-T); %same coupling

nu = eta*alph*Abs_p_A*R2;
theta = sqrt(1-nu);
%theta = acos(sqrt(nu));
R1_opt = 1-sqrt(2)*theta;
%chi_opt = 2*(1-2*sqrt(1-nu));
%chi_opt = 2*(1-sqrt(2)*theta);
%chi_opt = 2*(sqrt(2)-theta)./(sqrt(2)+theta);
%chi_opt = 2*(sqrt(2)-sin(theta))./(sin(theta)+sqrt(2)*cos(theta).^2);
%chi_opt = (1-R1_opt.^2)./(1-nu*R1_opt);
chi_opt = 2*R1_opt;

figure(1);
plot(R1,chi);
hold all
plot(R1_opt*[1 1],[0 2],':r');
plot([R1(1) 1],chi_opt*[1 1],':b');
hold off
xlabel('R_1');
ylabel('\chi');
