%cav_theory_paper.m is like gen_1_fit.m in the folder gen_1_fit. Except
%here I am not comparing with any data. I instead just want to produce a
%prediction to go into my theory paper. So I want the numbers to be
%"optimistic".

Nc=1000; %number points for control energy scan
Nn=10; %number of points for the input photon number scan
Nin = linspace(0,.5,Nn)'; %input photon number
En_max = .2; %max pulse energy in units of 1e-9 J (nJ)

bandwidth_f = .1;% %bandwidth we want to store, in GHz
delta_cav_f = 3*bandwidth_f; %linewidth of cavity we want, at signal frequency
delta_cav = delta_cav_f*2*pi;

Temp = 273+70; %temperature in K (controls optical depth)
En = linspace(.0001,En_max,Nc)'*1e-9; %control pulse energies in J
m=0; %order of cavity (m = no. of cavity modes in between signal and control)
R2=1;%.999; %other mirror reflectivity (amplitude)
eta = 1;%0.99; %straight-through mirror 1 to mirror 2 transmission (input
%to output, if we're outcoupling from mirror 2)
alph = .9995;%0.97;%0.98;.97;1; %remaining transmission (excluding atomic absorption)
R1=.95;%.998;%.8;%.75;%.9; %input-coupler reflectivity

kB = 1.38065e-23; %Boltzmann's constant in J/K
c = 2.9979e8; %speed of light in m/s
epsilon = 8.85e-12; 
%permittivity of free space in F/m
hbar = 1.05e-34; %hbar in Js
gamma = .0164; %2 gamma = homogeneous linewidth. Units of (ns)^-1. (gamma = 2*pi * 5.2227 MHz / 2)

logP = 8.22127-4006.048/Temp-.00060194*Temp-.19623*log10(Temp); %logP gives the logarithm of the cesium pressure in torr
p = 133.322368*10^logP; %pressure in Pascals
n = p/kB/Temp; %number density in atoms per cubic metre
D = 1e-29; %cesium D2 dipole moment in Cm (roughly 1/3 of the full dipole moment, since the polarization is linear)
lambda = 852.347e-9; %D2 wavelength in nm
omega = 2*pi*c/lambda; %D2 angular frequency

delta_f=9.2; %Stokes shift in GHz
delta = delta_f*2*pi;
Df = 4*delta_f/(2*m+1); %Free spectral range
%Df = delta_f/(m+1);
L = c./Df/1e9 %rough estimate of cavity length required, neglecting group delay
d = 1*D^2*omega*n*L/2/epsilon/hbar/c/(gamma*1e9) %single-pass optical depth
%(factor of 11 out-front is inherited from the fit to cavity fringe data)

%d=8e3; %single-pass optical depth (put in "by hand")
DA_f = 5;%10*bandwidth_f; %detuning in GHz, to get adiabaticity
DS_f=DA_f+delta_f; %Stokes detuning in GHz

DA = DA_f*2*pi; %Blue detuning of signal field from red line (F=4 transtion) 
DS = DS_f*2*pi; %Stokes detuning in (ns)^-1
GA = gamma-1i*DA;
GS = gamma-1i*DS;
KTA = d*gamma/GA;
KTS = d*gamma/(gamma-1i*(DS+delta));
% Abs_A = exp(-d*(gamma/DA)^2); %single-pass linear absorption of signal
% Abs_S = exp(-d*(gamma/(DS+delta))^2); %single-pass linear absorption of noise
Abs_A = exp(-real(KTA)); %single-pass linear absorption of signal
Abs_S = exp(-real(KTS)); %single-pass linear absorption of noise

gamma_p = .16; %pressure linewidth in (ns)^-1
GAp = gamma_p-1i*DA;
GSp = gamma_p-1i*DS;
dp = d*gamma/gamma_p; %pressure-broadened optical depth.
KTAp = dp*gamma_p/GAp;
KTSp = dp*gamma_p/(gamma_p-1i*(DS+delta));

% Abs_p_A = exp(-dp*(gamma_p/DA)^2); %single-pass linear signal absorption with pressure broadening. (Just checking it's not huge).
% Abs_p_S = exp(-dp*(gamma_p/(DS+delta))^2); %single-pass linear noise absorption with pressure broadening. (Just checking it's not huge).
Abs_p_A = exp(-real(KTAp)); %single-pass linear signal absorption with pressure broadening. (Just checking it's not huge).
Abs_p_S = exp(-real(KTSp)); %single-pass linear noise absorption with pressure broadening. (Just checking it's not huge).

T1=sqrt(1-R1.^2); %corresponding amplitude transmission coefficients
T2=sqrt(1-R2^2);

T = eta*alph*Abs_p_A*R1*R2; %round-trip transmission, including all losses and mirror reflectivities

Topt = 1./(1+(pi*(m+1) + dp*gamma_p*delta^2/2/DA^2/DS )*delta_cav/delta);
%analytic expression for "optimal" roundtrip loss (i.e. the value of T that
%gives a pass-bandwidth of delta_cav, for the "no birefringent element" case)

R1opt = Topt/(eta*alph*Abs_p_A*R2); %corresponding "optimal" value of R1
%But note that R1opt is not the same as R_opt (dashed lines in plots) which
%is the value of R1 that maximizes the memory efficiency. Anyway, it's good
%if R1opt is close to R_opt, because then you get the bandwidth you want
%and a good efficiency.

%chi = T1*T2*eta./(1-T); %transmission parameter for outcoupling from behind mirror 2.

%chi = (T1.^2./R1).*T./(1-T); %same coupling

%chi = T1.^2*R1./(1-T); %same coupling
chi = T1.^2./(1-T); %same coupling

%(if you outcouple from the input mirror, then the expression for chi is:
%chi = T1^2*R2*eta*Abs*alph/(1-T) = (T1^2 / R1 ) * T/(1-T).

x = (1-T)./(1+T); %noise suppression in perfectly anti-resonant cavity
%x = 0;

Tcorr = exp(4*dp*(gamma_p/DA)^2*(delta + DA)*delta/(DS+delta)^2);
%correction factor to account for lower absorption of noise field: Tcorr =
%Abs_p_S/Abs_p_A
phi = 2*dp*gamma_p*delta^2/DA/DS/(DA+DS); %dispersive phase shift of anti-Stokes
%x = abs( (1-T)./(1-exp(1i*phi)*T*Tcorr) ); %noise suppression where
%anti-Stokes is off-resonant because of the dispersion of the atoms
V = (1-x.^2)./(1+x.^2); %measured visibility

F = pi./acos(2-cosh(log(T))); %finesse (without high-reflectivity approximation)
df = Df./F; %cavity FWHM pass-band

tg = d*gamma/2/DA^2; %group delay
r = 1/(1+Df*tg); %fractional change in the length of the cavity due to the group delay
L = r*c/Df/1e6; %cavity length in mm.

w = 150e-6;%70e-6; %cavity beam-waist diameter in m
A = pi*(w/2)^2; %beam x-sectional area
A = L*1e-3*lambda; %diffraction-limited beam waist in cavity.
Tc = 3e-9; %control pulse duration in s

% W = 10; %integrated Rabi frequency in GHz
% Omega = sqrt(W*1e9/Tc);
% E0 = Omega*2*hbar/D;
% Ein = (1-T)*E0./T1;
% I = epsilon*c*Ein.^2/2;
% En = A*Tc*I;
% En = En*1e12; %pulse energy in pJ

%parameters for control field (reflectivity is different)
R1O = sqrt(0.5);
R2O = R1O;

T1O = sqrt(1-R1O^2);
T2O = sqrt(1-R2O^2);

etaO = eta;
alphO = alph;
DO = DS;
Abs_p_O = exp(-dp*(gamma_p/DO)^2);

TO = etaO*alphO*Abs_p_O*R1O*R2O;

fudge = 1; %fudge factor to account for poor coupling of the control
%field into the cavity.

off_res_f = 0; %detuning of control field from resonance in GHz

I = fudge*En/Tc/A; %peak intensity
Ein = sqrt(2*I/epsilon/c); %peak electic field without cavity enhancement
E0 = Ein*T1O./(1-TO*exp(1i*2*pi*off_res_f/Df)); %intra-cavity peak electric field
Omega = E0*D/hbar/2; %intra-cavity peak Rabi frequency
W = abs(Omega).^2*Tc;
W = W*1e-9; %integrated Rabi frequency W in GHz

%C=d*T/(1-T); %cooperativity
C=d/(1-T); %cooperativity
CA = sqrt(C*gamma*W)/GA; %anti-Stokes coupling
CS = sqrt(C*gamma*W)/GS; %Stokes coupling

%z = 2*R1*(CA.^2 + CS.^2*x);
z = -2*R1*real(CA.^2.*exp(1i*imag(KTAp)) + conj(CS).^2.*exp(-1i*imag(KTSp))*(conj(GA)/GA)*conj(x)) + 2*W*real(1/GS + 1/conj(GA));
%z = -2*R1*real(CA.^2.*exp(-1i*1*imag(KTAp)) );% + 2*W*real(1/GS + 1/conj(GA));
E = (1-exp(-z))./z;
f=1i*(1/DA + 1/DS)*W - z/2;

%kappa = ((1-exp(-f))./f)./sqrt(E.*exp(z)); %overlap with optimal mode, for
%an input mode the same shape as the control.
kappa = 1;
fudge_sig = 1; %fudge factor to reduce the predicted efficiency because
%not all the signal field gets into the cavity (deviation from "bad cavity"
%approximation).
eff = fudge_sig*abs(R1*chi*CA.^2.*E.*abs(kappa)).^2;
Sig = eff*Nin';

gz1 = (1-exp(-z).*E)./z;
Noise = abs(R1*chi*x*CA.*CS).^2.*gz1;

Nout = Sig + Noise*ones(1,Nn);

SNR = Nin(end)*eff./Noise;

[eff_opt,j_opt]=max(eff);
eff_opt

pos = [1   311   437   494];

figure(1);plot(En*1e9,eff);
xlabel('Pulse energy (nJ)');ylabel('\eta');
xlim([0 En_max])
ylim([0 1])
%xlim([0 En_opt*1e9*.95])
set(gcf,'position',pos)

%power_correction = 1/data_En(end);
%data_En = data_En*power_correction;

 %xlim([0 en_nJ(end)*1.2])
 %ylim([0 max(data_eff)*1.2])
 yl = ylim;
En_opt = En(j_opt);
% hold on
 %plot(En_opt*[1 1]*1e9,yl,':r');
 %hold off
 
 %eff_approx = (chi*CA(end)^2/z(end))^2;
 %eff_approx = chi^2/4/R1^2;
 F0 = pi*R1/(1-R1);
 %eff_approx = exp(2*F0/pi*log(eta*alph*Abs_p_A))*(1+R1)^2/(4*R1^2);
 %hold on
 %plot([En(1) En(end)]*1e9,eff_approx*[1 1],':g');
 %hold off

gs = 0; %input signal g2

S = 2*exp(-z).*(sinh(z)-z);


hz1 = 4*(1-E)./z.^3 - 2*E./z.^2 + E.^4 + S.*(1-2*exp(-z))./z.^4;
hz2 = E.^4 + E.*S./z.^3;
H = E.^2.*gz1 + hz2;
H2 = gz1.^2 + hz1;
Ck = CA.*kappa;
Cx = CS*x;
g2 = ((2*abs(Ck.*Cx).^2.*H)*Nin' + (abs(Cx).^4.*H2)*ones(1,Nn))./(abs(Ck.*E).^2*Nin' + (abs(Cx).^2.*gz1)*ones(1,Nn)).^2;

% g = chi^4*(CA.^4*ones(1,Nn)).*( (gs-1)*(CA.*E.*abs(kappa)).^4*Nin'.^2 + x^4*CS.^4.*...
%     (E.^4 + (2*(1+2*exp(-z))-E.*(5+exp(-z)))./z.^3 + 2*E.*S./z.^3)*ones(1,Nn) + 2*x^2*CS.^2.*CA.^2.*E.*(E.^3 ...
% + S./z.^3).*abs(kappa).^2*Nin');
% 
% g2 = 1+g./Nout.^2;

SNR_approx = (2/3-4/27*z).*Nin(end).*abs(kappa).^2.*abs(CA./CS).^2./abs(x).^2;
g2_approx = (34/9-14/81*z)./SNR_approx;
figure(10)
plot(En*1e9,g2(:,end));
%hold all
%plot(En*1e9,g2_approx);
%hold off
%legend('g^{(2)}','g^{(2)}_{approx}');
xlabel('Pulse energy (nJ)')
ylabel('g^{(2)} autocorrelation')
xlim([0 En_max])
set(gcf,'position',pos)
%ylim([0 2]);

% figure(11)
% plot(En*1e9,SNR);
% hold all
% plot(En*1e9,SNR_approx);
% hold off
% legend('SNR','SNR_{approx}');
% xlabel('Pulse energy (nJ)')

[X,Y]=meshgrid(Nin,En*1e9);
% figure(4);
% clf
% h=patch([Nin(1) Nin(1) Nin(end) Nin(end)],[En(end) En(1) En(1) En(end)]*1e9,ones(1,4),'b');
% hold all
% surf(X,Y,g2);
% set(h,'FaceAlpha',0.5)
% xlabel('N_{in}')
% ylabel('Pulse energy (nJ)');
% zlabel('g^{(2)} autocorrelation');
% alpha(h,0.5)
% h2=patch([Nin(1) Nin(1) Nin(end) Nin(end)],En_opt*1e9*ones(1,4),[0 2 2 0],'r');
% set(h2,'FaceAlpha',0.5)
% hold off
% view([52.5 30])
% %ylim([0 data_En(end)*1.2])

Ad = DA./Omega*1e9; %Adiabaticity >> 1?
%(Detuning should be much larger than peak Rabi frequency)
% figure(5);
% semilogx(En*1e9,Ad);
% xlabel('Pulse energy (nJ)');
% ylabel('Adiabaticity');
% yl = ylim;
% hold on
% plot(En_opt*1e9*[1 1],yl,':r');
% hold off

% figure(6);
% plot(En*1e9,Noise);
% xlabel('Pulse energy (nJ)');
% ylabel('Noise (photons per pulse)');
% yl = ylim;
% hold on
% plot(En_opt*1e9*[1 1],yl,':r');
% hold off


% figure(10);
% plot(En*1e9,abs(CA.^2./z).^2);
% xlabel('Pulse energy (nJ)');
% ylabel('|C_A^2/\zeta|^2');

