% zprofileCacheSummary
% after running clusterCompAndProfileDecompIonic use this script to output
% the cluster compositions in a format that R can understand
% A London Feb 2015
disp('centred')
load('clusterDecompData2015f.mat'); % a couple of data sets had corrupted indexed.pos files (copared to (e))
[d,cols]=dataBase('run>0',1);
%load('20150228T010100_clusterDecomp.mat'); % load zprofileCache

% variables used from clusterCompAndProfileDecompIonic: d, cols, zprofileCache
headerElements = {'Fe','Cr','Y','Ti','O','C','N'}; % output elements
C1loc = 3; % Y  }
C2loc = 4; % Ti } - The 3 components used for plotting the ternary diagram
C3loc = 5; % O  }
solutep = [3,4,5]; % solute elements used for line profile centering
% output ions:
headerIons = {'Ar','C','C2','C3','C4','CN','Cr','Cr2O','CrN','CrO','CrO2','CrO3','Fe','Fe2O','FeC','FeC2','FeH','FeN','FeO','FeO2','Ga','Mn','N','O','O2','Si','Ti','TiO','TiO2','W','WN','WO2','WO3','Y','YO','YO2';}; % output ions

% total number of clusters over all files
totalClusters =  sum(cell2mat(cellfun(@(x) size(x,1),zprofileCache(:,7),'uni',0)));

% run matCode r x y mat dpa irrdT1 irrdDpa1 irrdT2 irrdDpa2 elementalCounts
% {(col num in exprt), 'name in cols'} % export layout:
exportLayout = {1,'run';2,'matCode';3,'r';4,'o2';5,'fe2o';6,'mat';7,'dpa';8,'irrdT1';9,'irrdDpa1';10,'irrdT2';11,'irrdDpa2';12,'vol';13,'x';14,'y'};
exportLayoutLineProfs = {1,'run';2,'matCode';3,'r';4,'mat';5,'dpa';6,'irrdT1';7,'irrdDpa1';8,'irrdT2';9,'irrdDpa2';10,'x';11,'id'};
%exportLayout = {1,'x';2,'y';3,'r'};
extraCols = size(exportLayout,1);
exprt = cell(totalClusters,length(headerElements)+extraCols);
%% summarise cluster composition data
index = 1;
for i=1:size(zprofileCache,1)
    if ~isempty(zprofileCache{i,2})
        % find elements
        [~,loc]=ismember(headerElements,zprofileCache{i,2});
        c = size(zprofileCache{i,7},1); % number of clusters in i
        for k=1:extraCols
            if sum(strcmp(exportLayout{k,2},'r')) % radius
                exprt(index:index+(c-1),exportLayout{k,1}) = num2cell(zprofileCache{i,3});
            elseif sum(strcmp(exportLayout{k,2},'o2')) % O2 ionic comp in 32 Da peak
                exprt(index:index+(c-1),exportLayout{k,1}) = num2cell( returnOverlaps('O2',32,zprofileCache{i,4},zprofileCache{i,5}) );
            elseif sum(strcmp(exportLayout{k,2},'fe2o')) % Fe2O ionic comp in 64 Da peak
                exprt(index:index+(c-1),exportLayout{k,1}) = num2cell( returnOverlaps('Fe2O',64,zprofileCache{i,4},zprofileCache{i,5}) );
            elseif sum(strcmp(exportLayout{k,2},'dpa')) % dpa
                exprt(index:index+(c-1),exportLayout{k,1}) = num2cell(d{i,strcmp(exportLayout{k,2},cols)});
            elseif sum(strcmp(exportLayout{k,2},'x')|strcmp(exportLayout{k,2},'y')) % x & y
                % calculated at the end
            else
                exprt(index:index+(c-1),exportLayout{k,1}) = d(i,strcmp(exportLayout{k,2},cols));
            end
        end
        for j=1:length(loc)
            if loc(j)
                exprt(index:index+(c-1),(extraCols+j)) = num2cell(zprofileCache{i,7}(:,loc(j)));
            end
        end
        index = index + size(zprofileCache{i,7},1);
    end
end
exprt(cell2mat(cellfun(@isempty,exprt,'uni',0))) = {0}; % set empties to 0
% calc x and y
c1 = cell2mat(exprt(:,extraCols+C1loc))./sum(cell2mat(exprt(:,extraCols+[C1loc C2loc C3loc])),2);
c2 = cell2mat(exprt(:,extraCols+C2loc))./sum(cell2mat(exprt(:,extraCols+[C1loc C2loc C3loc])),2);
exprt(:,exportLayout{strcmp(exportLayout(:,2),'x'),1}) = num2cell(c1+c2*0.5); % x
exprt(:,exportLayout{strcmp(exportLayout(:,2),'y'),1}) = num2cell(c2*sqrt(3/4)); % y
% headings
exprt = [[exportLayout(:,2)' headerElements];exprt];
cell2csv('ternData2015e.csv',exprt); % save cvs file

%% summarise line profiles
extraCols = size(exportLayoutLineProfs,1);
w=size(zprofileCache{i,1}{1},1); % number of profile points
exprtLines = cell(totalClusters*w,extraCols);
index = 1;
ld = zeros(totalClusters*w,length(headerElements)+length(headerIons)); % double line profile data
for i=1:size(zprofileCache,1)
    if index > totalClusters*w
        error('index error');
    end
    disp(i);
    [~,loc]=ismember(headerElements,zprofileCache{i,2});
    c = size(zprofileCache{i,7},1); % number of clusters in i
    % specific column data from dataBase
    for k=1:extraCols
        if sum(strcmp(exportLayoutLineProfs{k,2},'r')) % radius
            a = arrayfun(@(x) repmat(x,w,1),zprofileCache{i,3},'uni',0); % temp list of radii
            exprtLines(index:index+(c*w-1),exportLayoutLineProfs{k,1}) = num2cell(vertcat(a{:}));
        elseif sum(strcmp(exportLayoutLineProfs{k,2},'dpa')) % dpa
            a = arrayfun(@(x) repmat(x,w,1),d{i,strcmp(exportLayoutLineProfs{k,2},cols)},'uni',0); % temp list of dpa
            exprtLines(index:index+(c*w-1),exportLayoutLineProfs{k,1}) = num2cell(vertcat(a{:}));
        elseif sum(strcmp(exportLayoutLineProfs{k,2},'id')) % cluster ID
            exprtLines(index:index+(c*w-1),exportLayoutLineProfs{k,1}) = num2cell( ceil( [1:(w*c)]./w ) );
        elseif sum(strcmp(exportLayoutLineProfs{k,2},'x')) % x coordinate
            exprtLines(index:index+(c*w-1),exportLayoutLineProfs{k,1}) = num2cell( mod(0:(w*c-1),w )+1 );
        else
            exprtLines(index:index+(c*w-1),exportLayoutLineProfs{k,1}) = d(i,strcmp(exportLayoutLineProfs{k,2},cols));
        end
    end
    % copy line profile data
    % get locations of header ions in this data set
    [~,loce]=ismember(headerElements,zprofileCache{i,2});
    [~,loci]=ismember(headerIons,zprofileCache{i,5});
    % compile profiles together
    z=vertcat(zprofileCache{i,1}{:});
    % get ion-table for ionic->elemental conversion
    t=ions2ionTable(ionStr2ions(zprofileCache{i,5}),zprofileCache{i,2});
    ze=z*t; % elemental line profiles
    % elemental line profile
    for j=1:length(loce)
        if loce(j)
            ld(index:index+(c*w-1),(j)) = ze(:,loce(j));
        end
    end
    % ionic line profile
    for j=1:length(loci)
        if loci(j)
            ld(index:index+(c*w-1),(length(headerElements)+j)) = z(:,loci(j));
        end
    end
    % centre profile: using solute = sum(ld(index:index+(c*w-1),solutep),2)
    for k = 1:c % loop over all clusters
        cindex = (index+((k-1)*w)):index+(k*w-1);
        ld(cindex,:) = profileCentre(sum(ld(cindex,solutep),2),ld(cindex,:),1:w);
    end
    index = index + c*w;
end
% format output
exprtLines(cell2mat(cellfun(@isempty,exprtLines,'uni',0))) = {0}; % set empties to 0
% headings
%exprtLines = [[exportLayoutLineProfs(:,2)' headerElements headerIons]; exprtLines];
cell2csvParts('lineData2015c.csv',[exportLayoutLineProfs(:,2)' headerElements strcat('i',headerIons)],exprtLines,ld); % save cvs file