% zprofileCache cluster overlaps summary
countScale = 1; % 1 = output is scaled to counts per range
i=1; % file number
for c=1:size(zprofileCache{i,1},1)
% c=1; % cluster
tol = 0.01; % minimum composition to be displayed
numr = size(zprofileCache{i,4}{c},1); % number of ranges
presentIons = sum(zprofileCache{i,4}{c}(:,3:end),1)>tol;
if countScale
rangeCounts = log10(repmat(zprofileCache{i,10}(c,:)',1,sum(presentIons)));
rangeCounts(rangeCounts<0) = 0;
else
rangeCounts = repmat(ones(numr,1),1,sum(presentIons));
end
barData = (zprofileCache{i,4}{c}(:,logical([0 0 presentIons])).*rangeCounts);
% remove ion in ranges == 0
presentIons2 = sum(barData,1)>tol;
p = presentIons;
p(p==1) = presentIons2;
barData = barData(:,presentIons2);
barData(barData<0) = 0;
y = sum(barData,2);
bar(barData,'stacked'); % plot bar chart
% range labels
xText = text(1:numr, zeros(1,numr) , num2str(mean(zprofileCache{i,4}{c}(:,1:2),2),'%2.1f'));
set(xText, 'VerticalAlignment','middle', 'FontSize',8, 'rotation',90);
% get ions per range
ionNames = zprofileCache{i,5};
ionNames2 = strcat(zprofileCache{i,5},',');
l=cell(1,numr); % ions per range
for r=1:numr
    l{r}=strcat(ionNames2(zprofileCache{i,4}{c}(r,3:end)>tol));
end
l(cell2mat(cellfun(@isempty,l,'uni',0))) = {{''}};
ls = cellfun(@(x) strcat(x{:}),l,'uni',0); % make text labels
ls = regexprep(ls,'(\d)','_$1'); % add subscripts
ls = cellfun(@(x) x(1:end-1),ls,'uni',0); % remove trailing comma
%hText = text(1:numr, ones(1,numr) , ls);
hText = text(1:numr, y , ls); %presntIons2 need to be here y(presentIons2)
set(hText, 'VerticalAlignment','middle', 'FontSize',8, 'rotation',90);
legend(regexprep(ionNames(p),'(\d)','_$1'),'Location','EastOutside');
[path,name]=fileparts(posFileList{i});
title([name ', cluster ' num2str(c)],'Interpreter', 'none');
if ~countScale
ylim([0,1.2]);
end
set(gcf, 'PaperPosition', [0 0 25 20]); % set figure size
saveas(gca,['clrIonic\' name '_' sprintf('%03d',c) '.png']); % save figure
end