% zprofileCache cluster overlaps summary, plots the number of counts per
% range and the ionic composition for each cluster in file i of
% zprofileCache. This is generated by clusterCompAndProfileDecompIonic for
% example. The plots are saved in a folder called clrIonic\
countScale = 1; % 1 = output is scaled to counts per range
i=2; % file number
for c=1:size(zprofileCache{i,1},1)
% c=1; % cluster
tol = 0.01; % minimum composition to be displayed
numr = size(zprofileCache{i,4}{c},1); % number of ranges
presentIons = sum(zprofileCache{i,4}{c}(:,3:end),1)>tol;
if countScale
rangeCounts = log10(repmat(zprofileCache{i,10}(c,:)',1,sum(presentIons)));
rangeCounts(rangeCounts<0) = 0;
else
rangeCounts = repmat(ones(numr,1),1,sum(presentIons));
end
barData = (zprofileCache{i,4}{c}(:,logical([0 0 presentIons])).*rangeCounts);
barData(barData<0) = 0;
y = sum(barData,2);
bar(barData,'stacked') % plot bar chart
% range labels
set(gca,'XTickLabel','');
xText = text(1:numr, zeros(1,numr) , num2str(mean(zprofileCache{i,4}{c}(:,1:2),2),'%2.1f -'));
set(xText, 'VerticalAlignment','middle','HorizontalAlignment','right', 'FontSize',8, 'rotation',90);
% get ions per range
ionNames = zprofileCache{i,5};
ionNames2 = strcat(zprofileCache{i,5},',');
l=cell(1,numr); % ions per range
for r=1:numr
    l{r}=strcat(ionNames2(zprofileCache{i,4}{c}(r,3:end)>tol));
end
l(cell2mat(cellfun(@isempty,l,'uni',0))) = {{''}};
ls = cellfun(@(x) strcat(x{:}),l,'uni',0); % make text labels
ls = regexprep(ls,'(\d)','_$1'); % add subscripts
ls = cellfun(@(x) x(1:end-1),ls,'uni',0); % remove trailing comma
%hText = text(1:numr, ones(1,numr) , ls);
hText = text(1:numr, y , ls);
set(hText, 'VerticalAlignment','middle', 'FontSize',8, 'rotation',90);

legend(regexprep(ionNames(presentIons),'(\d)','_$1'),'Location','EastOutside');
[path,name]=fileparts(posFileList{i});
title([name ', cluster ' num2str(c) ' ' num2str(zprofileCache{i,3}(c),3) ' nm'],'Interpreter', 'none');
if ~countScale
ylim([0,1.2]);
end
% axis labels
ylabel('log(Count)');
xlabel('Range Da');
xlabh = get(gca,'XLabel');
set(xlabh,'Position',get(xlabh,'Position') - [0 .2 0])

set(gcf, 'PaperPosition', [0 0 25 20]); % set figure size
saveas(gca,['clrIonic\' name '_' sprintf('%03d',c) '.png']); % save figure
end