% volume sampling simulation
% Does the random sampling of a volume with particles in it give a root n
% standard deviation in accordance with counting statistics?
% The number of particles in the random sampling box error goes as root n.
% A London Oct 2013
s = 50; % number of samples
b = 20; % size of sample box
l = 200; % cube length in nm

vol = rand(n,3)*l; % x y z positions in the cube
c = zeros(s,1); % number of particles counted
% randomly sample the volume
index = 1;
for d=5E22:5E22:1E24 % number density in m-3
    n = round(d*((l*1E-9)^3));
    vol = rand(n,3)*l;% total number of particles in the whole volume
for i = 1:s
    % pick a random volume
    p = ones(n,1);
    for j=1:3
        % pick x1 dimensions
        x1s = (rand(1)*l); % box start
        if (x1s+b)>l
            % box over runs
            p = p & ((vol(:,j)>x1s & vol(:,j)<=l)|(vol(:,j)>=0 & vol(:,j)<(x1s-l+b)));
        else
            % within bounds
            p = p & vol(:,j)>x1s & vol(:,j)<(x1s+b);
        end
    end
    c(i) = sum(p);
end
cerr(index,:) = [mean(c) std(c)];
derr(index,:) = cerr(index,:)/(b*b*b*1E-27);
index = index +1;
end
% measured density
%disp(strcat('measured density:',num2str( mean(c)/(b*b*b*1E-27),'%e'),' m-3'));
plot(cerr(:,1),derr(:,2),'bx',cerr(:,1),derr(:,1)./sqrt(cerr(:,1)))
legend('Measured deviation of number density','Predicted variation from number of particles')
xlabel('Number of particles counted');
ylabel('Standard deviation in particles/m^3');