function [Cv] = vacancyCon(T,R,k2)
%[Cv] = vacancyCon(T,R,k)
% Vacancy concentration as a function of [T]emperature (K), [R] 
% displacement rate (dpa/s) and [k2] sink strength squared.

kB = 0.00008617332478; % Boltzman Const.
a = 2.870E-10; % lattice parameter
v = 1.00E+13; % Debye freq.
D0 = a*a*v;
EmV = -0.7; % Actiavation energy of vacancy migration eV
EfV = -2.2; % Actiavation energy of vacancy formation eV

Dv = D0*exp(EmV./(kB*T))*10000; % Vacancy diffusion rate /cm2s1
t = 1./(Dv*k2); % time for defects to reach sinks
CvIrrd = t*R; % vac conc of irradiation defects
CeqV = exp(EfV./(kB*T)); % eq vacancy conc.
Cv = CvIrrd + CeqV;