% Update one data set script

%% Identify data
%get data
aptRoot = 'C:\Users\andy\APT\';
cfRoot = 'C:\Users\andy\APT\clusterAnalysis\';
clrRangeRoot = 'C:\Users\andy\APT\ranges\';
matrixRangeRoot = 'C:\Users\andy\APT\ranges\matrix\';
[d,cols]=dataBase('run>0',1); % get all data form datBase
clrRangeFileList = strcat(clrRangeRoot, regexprep(d(:,strcmp('rrng',cols)),'\.rrng','ss_80.rrng','ignorecase'));
matrixRangeFileList = strcat(matrixRangeRoot, regexprep(d(:,strcmp('rrng',cols)),'\.rrng','ss_80.rrng','ignorecase'));
posFileList = strcat(d(:,strcmp('reconRoot',cols)), d(:,strcmp('pos',cols)));
clrPosList = regexprep(d(:,strcmp('clrIdxRrng',cols)),'\.indexed\.rrng','.pos','ignorecase');
matrixPosList = regexprep(d(:,strcmp('clrIdxRrng',cols)),'\.cluster\.indexed\.rrng','.matrix.pos','ignorecase');
overlapList = [d(:,strcmp('overlaps',cols));d(:,strcmp('overlapsMatrix',cols))];

% extra stuff for cluster/matrix comps
rangeFileList = [clrRangeFileList; matrixRangeFileList];
% add matrix and cluster file endings
posFileList = [clrPosList; matrixPosList];
% first half matrix
% second half cluster
disp('Which dataset to examine?');
n=8;
pause
%% plot final range file
disp(rangeFileList{n});
%rangePlotter(rangeFileList{n},posFileList{n},100000);
%pause
respse = input('open original range file? Y/N:','s');
qrrngFile = strcat(aptRoot, d{mod(n,size(d,1)),strcmp('rrng',cols)});
if strcmpi(respse,'Y')
    winopen(qrrngFile);
end
%pause
%% make synthetic range file
load('iList.mat'); % loads possible ions
[newRanges,overlapIons,ionRanges]=rangeSynthetic(qrrngFile,iList,'ss');
%pause
% plot new file
rangePlotter(regexprep(qrrngFile,'\.rrng','ss.rrng','ignorecase'),posFileList{n},100000);
protectedRanges = [15.9900000000000;29.6350000000000;31.9740000000000;52.4500000000000;63.9490000000000;];
protectedRanges = [0];
%% check new range file
[rf,newPossIons]=rangeCheck(regexprep(qrrngFile,'\.rrng','ss.rrng','ignorecase'),posFileList{n},[0],0,ionRanges,iList);
%% write new file or not?
rangeWriter(rf{5},rf{4},'checkThisRange');
rangePlotter('checkThisRange.rrng',posFileList{n},100000);
%% optimise new ranges
[result]=rangeCorrector(rf,posFileList{n},0.8); % saves new range *_80.rrng
% copy file to location
% save "range image" .png
rangeDraw(result,gca,[matrixRangeRoot regexprep(qrrngFile,'\.rrng','ss_80','ignorecase')]);
%% save overlaps into database
load('data.mat'); % data and cols
disp(['cluster overlaps is column ' num2str(find(strcmp('overlaps',cols)))]);
disp(['matrix overlaps is column ' num2str(find(strcmp('overlapsMatrix',cols)))]);
disp(d(mod(n,size(d,1)),1));
disp('Please update the dataBase entry manually');