function [ttc]=twotheta(a,lamda,hkl)
% calculate the two theta diffraction angles for a cubic crystal lattice
% parameter a (same units as lambda), with wavelength lambda and hkl
% reflections, hkl (double list)
d=a./sqrt(hkl);
ttc = asind(lamda./(2.*d))*2; % theoretical 2theta
end