% script to fit the shape of an atom probe needle and find it's volume
% assuming it is a parabola. Open the image and use ginput to get a list of
% coords. Fit these coords to a poly2, this is our parabola.

[FileName,PathName,FilterIndex] = uigetfile({'*.jpg;*.png;*.tiff;*.tif'});

% need to ask for the mag
mag = input('Enter Mag in xk, eg 50:');
dpi = input('Enter scan DPI, eg 1200:');
pixSize = 25400/(mag*dpi);
disp(strcat('Pixel size = ',num2str(pixSize),'nm'));
tip = imread(strcat(PathName,FileName));
imshow(tip)
invertq = input('Bright field? y/n ','s');
if strcmp(invertq,'y')
    tip = imcomplement(tip);
end
disp('two points for image rotation; shank, tip')
[ix,iy] = ginput(2);
if length(ix)<2
    % assume 0 angle
    disp('Assuming no rotation');
else
    disp('angle');
    disp(atand((iy(2)-iy(1))/(ix(2)-ix(1)))+90);
    tip = imrotate(tip,atand((iy(2)-iy(1))/(ix(2)-ix(1)))+90);
end
imshow(tip)
rotgood = input('Tip at top? y/n ','s');
if strcmp(invertq,'n')
    tip = imrotate(tip,180);
end
disp('click-drag zoomed ROI, double click to finish');
[I2,rect] = imcrop(tip);
% threshold
[thlevel,bw] = thresh_tool(I2);
blurF = fspecial('disk',10);
bw = imfilter(bw,blurF,'replicate');
bw = edge(bw,'canny');
imshow(I2)
%disp('get points on the tip');
[iy,ix] = find(bw);
% need to display points
% need to rotate image...
disp('select fitting lower limit');
[fmx,fmy] = ginput(1);
flim = iy<fmy;
ffun = fittype( @(a, b, c, x) c+(a*(x - b).^2) );
fitObj = fit(ix(flim),iy(flim),ffun);
hold on
plot(ix(flim),iy(flim),'g.');
plot(fitObj,'r');
hold off
% need to integrate the curve to find the volume
vol = (pi*(length(I2(:,1))-fitObj.c)^2)/(2*fitObj.a);    %y^2/2a
disp(strcat('Volume = ',num2str(vol),' pixles'));
disp(strcat('Volume = ',num2str(vol*(pixSize^3)),' nm3'));
disp(strcat('Volume = ',num2str(vol*(pixSize^3)*1E-27),' m3'));