% make a point cloud ellipsoid
SEMI_AXES=[1,2.0,3.0];
NPTS = 8800; % density of points per unit vol

p = rand(NPTS,3)*max(SEMI_AXES)*2 - max(SEMI_AXES);

% remove points outside the ellipsoid:
ss = SEMI_AXES.*SEMI_AXES;
pp = (p(:,1).*p(:,1)/ss(1))+(p(:,2).*p(:,2)/ss(2))+(p(:,3).*p(:,3)/ss(3));

coords = p(pp<=1,:);

scatter3(coords(:,1),coords(:,2),coords(:,3),'.'); axis equal
NPTS = size(coords,1);

% Dan's code:

%Find centroid of data - should be near zero
centroid = mean(coords,1);

%Compute inertial tensor matrix (Symmetric, pos definite or zero)
%===========
iMat = zeros(3,3);

%Compute diagonal terms (moment of inertia)
for iPt=1:NPTS 
  %Deltas from centroid 
  delta=coords(iPt,:) - centroid;
  for idx=1:3
      % Note stephenson matrix & sudbrack matrix don't match on main diagonal.
      %  Stephenon's matrix is wrong, sudbrack's as-written matrix might be wrong (missing sign - check units)
      % I think sudbrack's  code is OK
      a = mod(idx,3) +1;
      b = mod(idx+1,3) +1;
      
      v1 = delta(a)*delta(a);
      v2 = delta(b)*delta(b);
      vRes = v1 + v2;
      
      iMat(idx,idx)= iMat(idx,idx) + vRes;
  end  
end

%Compute off diagonal terms (for upper side - as symmetric, we don't need to compute lower)
% (product of interia)
xy = 0; xz = 0; yz = 0;
for iPt=1:NPTS
  %Deltas from centroid 
  delta = coords(iPt,:) - centroid;
  xy = xy - delta(1)*delta(2);
  yz = yz - delta(2)*delta(3);
  xz = xz - delta(1)*delta(3);
end

%Build off-diag terms around main diagonal (note ab = ba)
offTerms = [ 0 xy xz ; xy 0 yz;  xz yz 0];

%Generate final inertial matrix
iMat = iMat + offTerms;

iMat = 1.0/NPTS*iMat;
%===========


%Compute eigenvalues
[eigVec eigVal] = eig(iMat);
eigVal =diag(eigVal); %Matlab returns this in a silly matrix form, with off-axis zeros

% for a=1:3
%    %Normalise the eigevector
%    eigVec(a) = eigVec(a)./(eigVec(a)*eigVec(a)');
%    
%   %rescale it by the eigenvalues
%   eigVec(a) = eigVec(a)*eigVal(a); 
% end


%Check pos-definiteness
assert(min(eigVal) >=0)

%Now compute semi-axes from the eigenvalues
semiAxesFit = zeros(1,3);
for a=1:3
  b = mod(a,3)+1;
  c = mod(a+1,3)+1;
  %I think sudbrack multiplies by 2 here, which obntains the full axis (diameter),
  % Rather than the semi
  semiAxesFit(a) =  sqrt(5.0/2.0*( eigVal(b) + eigVal(c) - eigVal(a) ));
end

fprintf('Fitted semi axes ');
disp(semiAxesFit);