tofSlices = [0:2:40 60:40:260]; % ns
for i = 1:(length(tofSlices)-1)
    subd = d(d(:,3)>tofSlices(i) & d(:,3)<tofSlices(i+1),:);
    [uxd,~,ixd] = unique(subd(:,1));
    [uyd,~,iyd] = unique(subd(:,2));
    [n]=hist3(subd(:,1:2),[2200,2200]);imagesc(uyd,uxd,n); axis equal; xlim([-3 3]); ylim([-3 3]);
    imName = ['TOF slice ' num2str(tofSlices(i)) ' to ' num2str(tofSlices(i+1)) ' ns'];
    title(imName);
    saveas(gcf,[imName '.png']);
end
