% how does the standard deviation (in x & y) change as a function of n,
% does it follow the root(n) dependence as expected?

ions1 = [1,0,0;0,1,0;0,0,1;1,0,1;0,1,1];
ions2 = [1,0,0;0,1,0;0,0,1];

de = 0.37;
composition2 = [2 1 5];
composition1 = [2 2 7];

samples = 250;
%clusterSize = 40;
ind = 1;
for clusterSize = 25:100:525
    disp(clusterSize);
    for i=1:samples
        [~,~,~,~,x(i),y(i)] = ternSim(clusterSize,composition2,ions2);
    end
    sx(ind) = std(x);
    sy(ind) = std(y);
    % the total number of each element detected
    en = de*composition2*clusterSize/sum(composition2);
    A = en(1);
    B = en(2);
    T = sum(en);
    
    col1err = (A/T).*sqrt(((1-de)./A) + ((1-de)./T)); % actual error in Y fraction
    col2err = (B./T).*sqrt(((1-de)./B) + ((1-de)./T)); % actual error in Ti fraction

    ex(ind) = sqrt(col1err.^2 + (col2err/2).^2);
    ey(ind) = (col2err*0.866);
    mx(ind) = mean(x);
    my(ind) = mean(y);
    ind = ind + 1;
end