% ternSimScript
% this runs a number of simulations to show the statistical variation in
% the measured cluster composition
ions1 = [1,0,0;0,1,0;0,0,1;1,0,1;0,1,1];
rescale = 2;
terplot(6,1/rescale)
hold on
composition1 = [2 1 5];
composition2 = [2 2 7];
samples = 100;
%clusterSize = 100;

% simulate data
for i=1:samples
    [~,~,~,~,x(i),y(i)] = ternSim(clusterSize,composition1,ions1);
end
for i=1:samples
    [~,~,~,~,x2(i),y2(i)] = ternSim(clusterSize,composition2,ions1);
end

h=scatter(x*rescale+rand(1,length(x))/200,y*rescale+rand(1,length(x))/200,ones(1,length(x))*3,'bo');
h=scatter(x2*rescale+rand(1,length(x2))/200,y2*rescale+rand(1,length(x2))/200,ones(1,length(x2))*2.5,'ro');

% composition 1:
c1 = clusterSize*0.37*composition1./sum(composition1); % count composition
ec1 = sqrt(.63)*sqrt(1./(c1)); % fractional error
x = c1(1)/sum(c1)+c1(2)/(2*sum(c1));
y = c1(2)*0.866/sum(c1);
x = x*rescale; 
y = y*rescale; % rescale
c1 = rescale*c1/(clusterSize*0.37);
plot([x+c1(1)*ec1(1)*0.866 x-c1(1)*ec1(1)*0.866],[y-c1(1)*0.5*ec1(1) y+c1(1)*0.5*ec1(1)],'b-','linewidth',2);
plot([x x],[y-c1(2)*ec1(2) y+c1(2)*ec1(2)],'b-','linewidth',2);
plot([x+c1(3)*ec1(3)*.866 x-c1(3)*ec1(3)*.866],[y+c1(3)*0.5*ec1(3) y-c1(3)*0.5*ec1(3)],'b-','linewidth',2);
% composition 2:
c1 = clusterSize*0.37*composition2./sum(composition2); % count composition
ec1 = sqrt(.63)*sqrt(1./(c1)); % fractional error
x = c1(1)/sum(c1)+c1(2)/(2*sum(c1));
y = c1(2)*0.866/sum(c1);
x = x*rescale; 
y = y*rescale; % rescale
c1 = rescale*c1/(clusterSize*0.37);
plot([x+c1(1)*ec1(1)*0.866 x-c1(1)*ec1(1)*0.866],[y-c1(1)*0.5*ec1(1) y+c1(1)*0.5*ec1(1)],'r-','linewidth',2); % Y
plot([x x],[y-c1(2)*ec1(2) y+c1(2)*ec1(2)],'r-','linewidth',2); % Ti
plot([x+c1(3)*ec1(3)*.866 x-c1(3)*ec1(3)*.866],[y+c1(3)*0.5*ec1(3) y-c1(3)*0.5*ec1(3)],'r-','linewidth',2); % O

% scatter(x*2+rand(1,length(x))/100,y*2+rand(1,length(x))/100,'bx');
% scatter(x2*2+rand(1,length(x2))/100,y2*2+rand(1,length(x2))/100,'rx');
spacing = 0.1;
% axis labels
text(0.5,-spacing,'Y fraction','Rotation',0,'HorizontalAlignment','center');
text((.75)+spacing,(.866/2),'Ti fraction','Rotation',-60,'HorizontalAlignment','center');
text((.25)-spacing,(.866/2),'O fraction','Rotation',60,'HorizontalAlignment','center');
hold off