function [c,ce,dc,dce,x,y] = ternSim(n,composition,ions)
% function [c,ce,dc,dce,x,y] = ternSim(n,composition,ions)
% This function simulates the evaporation of a cluster of n total atoms
% with an average composition given by the matrix 'composition' (eg
% [2,2,7]) by ions [1,0,0;0,1,0;0,0,1;1,0,1;0,1,1]. The ions matrix is explained
% here:
% If the composition is [2,2,7], this is 3 elements, ions is therefore 3
% columns wide. Each column is one element and each row is the make up of
% that ion, if the elements are A,B,C and ions = [1,2,0] this is an ion of
% AB2.
% This returns the ions counts and the estimated standard deviation of
% those counts.
% You can bais the probability that an ion will be choosen by including
% multiple entries for it in the ions array, eg:
% ions =    1     0     0   Y
%           0     1     0   Ti
%           0     0     1   O
%           1     0     1   YO
%           0     1     1   TiO
%           1     0     1   YO
%           0     1     1   TiO
% Here the chance of picking YO or TiO at random is twice that of Y or Ti.
% When doing this YOU MUST MAKE SURE that the first rows are UNIQUE. This
% property is assumed by the code.

% check for unique initial rows
unii = ions(1:length(unique(ions,'rows')),:);

detectorEff = 0.37;

% the total number of each element
en = round(composition*n/sum(composition));
it = zeros(1,length(unii)); % total count of ions evaporated 
% total number of ions
ni = length(ions(:,1));
nr = en; % number of atoms remaining (matrix)

while sum(nr)>0
    searchList = find(sum(ions(:,find(nr)),2)); % list of ion indices
    % pick an ion to evaporate
    i = round(rand*(length(searchList)-1) + 1);
    i = searchList(i);
    e = ions(i,:); % e = elements in the ion
    % check that these elements are remaining
    if ~sum(abs(nr-e)-(nr-e))
       % remove e from nr
       nr = nr - e;
       % is it detected?
       if rand <= detectorEff
           % find the first unique entry for this ion
           i = find(ismember(ions,e,'rows'),1,'first');
           it(i) = it(i) + 1;
       end
    end
end
%disp(it);
dc = it*unii; % decomposed counts
%disp(dc); 
x = dc(1)/sum(dc) + 0.5*dc(2)/sum(dc);
y = 0.866*dc(2)/sum(dc);
c = it;
ce = sqrt(1-detectorEff).*sqrt(c); % expected error
dce = sqrt(sum(bsxfun(@times,ce',unii).^2,1)); % decomposed error
end