% ternPlotter
% this takes a single clusterstats file (from posgen) or a list of files
% and generates a tern plot based on their Y O and Ti contents
% A London Nov 2012

% to run this requires 'ternary2' package from the internet
% example run:
% $ clf; terplot(11);hold on
% $ zedn = 0;nmin='10';dmaxstr='1_40'; ternPlotter
% then press enter to cycle through nmin

% get file names
%filelist =  dir(strcat(posfile,'/',rrngfile,'cs*_',posgenNmin,'.txt'));
%fileNames = {filelist.name}';
% here the range percentage is a wild card
% need different dmax and nmin for each range percentage
% old fileNames = {strcat('C:\Users\andy\APT\posgen\R14_15867-v02c\r14_15867_FeCr_*cs',dmaxstr,'_03.txt')};
filelist = dir(strcat('C:\Users\andy\APT\posgen\R14_15065-v03c\r14_15065_',rrngstr,'cs*_03.txt'));
fileNames = {filelist.name}';
% select the core ions to count n
coreIons = cell(4,1);  % better to read the cluster ops xml file
% but that appears to tricky in matlab!
coreIons{1} = 'YO';coreIons{2} = 'Y';
coreIons{3} = 'TiO';coreIons{4} = 'Ti';
%coreIons{5} = 'O';
istart = 1;
iend = 0;
compositionResults = zeros(length(fileNames)-iend-istart+1,6); % HARD CODED = BAD
% loop through file names
for fileIndex=istart:length(fileNames)-iend
    
    % data file
    fileToRead1 = fileNames{fileIndex};
    % Import the file
    newData1 = importdata(fileToRead1);
    %fclose('all');
    % Create new variables in the base workspace from those fields.
    vars = fieldnames(newData1);
    for i = 1:length(vars)
        assignin('base', vars{i}, newData1.(vars{i}));
    end
    % the above produces colheadings (text), and data (double)
    
    % get the decomposed counts
    [elements decomposeCounts] = clusterStatsReader(fileNames{fileIndex});
    
    % alloc a results table
    nTable = zeros(length(data),1);
    
    % sum up core ions
    for c=4:length(textdata) % loop over columns checking for coreAtoms
        %starts at 4, cause the first 3 cols are x,y,z
        for i=1:length(coreIons) % loop over each core ion
            if(strcmp(coreIons{i},textdata{c}))
                % found a match, add to total
                nTable = nTable + data(:,c);
            end
        end
    end
    %clear 'legendtext'
    %[h hg htick] = terplot(11); hold on
    spacing = 0.05;
    text(0.5,-spacing,'Y fraction','Rotation',0,'HorizontalAlignment','center');
    text((.75)+spacing,(.866/2),'Ti fraction','Rotation',-60,'HorizontalAlignment','center');
    text((.25)-spacing,(.866/2),'O fraction','Rotation',60,'HorizontalAlignment','center');
    %nstart=5;nstep=5;nend=50; % use single nmin value
    %colour mapping
    cc=jet(length(fileNames)+2-istart-iend); % list of colours
    %legendtext = cell(1+ceil((nend-nstart)/nstep),1);
    %scatterh = zeros(1+ceil((nend-nstart)/nstep),1);
    dmaxcell =   textscan(fileNames{fileIndex},strcat('r14_15065_',rrngstr,'cs%c%c%c%c_03.txt'));
    dmaxnum = strcat(dmaxcell{1},'.',dmaxcell{3},dmaxcell{4});
    iindex = fileIndex-istart+1;
    compositionResults(iindex,1) = str2double(dmaxnum);
    legendtext{iindex} = strcat('dmax =',dmaxnum,' nm');
    legendtext(iindex)
    count = 1;
    if exist('clusters','var')
        clear 'clusters'
        %clf;
        %terplot(11); hold on
        %hold off;
    end
    %legend(strcat('nmin=',num2str(nmin)));
    
    %nmin = 50;
    % filter for nmin
    for cluster=1:length(nTable)
        if(nTable(cluster)>=nmin)
            % store cluster as a result
            clusters(count,1:3) = data(cluster,1:3); % x y z
            clusters(count,4) = nTable(cluster); % no. core atoms
            clusters(count,5) = data(cluster,length(textdata)); % radius
            % get content
            for e=1:length(elements)
                if(strcmp('Y',elements(e)))
                    % found Y
                    clusters(count,6) = decomposeCounts(cluster,e);
                elseif(strcmp('Ti',elements(e)))
                    % found Ti
                    clusters(count,7) = decomposeCounts(cluster,e);
                elseif(strcmp('O',elements(e)))
                    % found O
                    clusters(count,8) = decomposeCounts(cluster,e);
                elseif(strcmp('Cr',elements(e)))
                    % found Cr
                    clusters(count,9) = decomposeCounts(cluster,e);
                elseif(strcmp('Fe',elements(e)))
                    % found Fe
                    clusters(count,10) = decomposeCounts(cluster,e);
                end
            end
            count = count + 1;
        end
    end
    if exist('clusters','var')
    % get the number of clusters
    [noclusters ~]=size(clusters);
    else
        noclusters = 0;
        clusters = zeros(1,8);
    end
    % make the depth of the graph (zedn defined before run)
    %zed = ones(noclusters,1)*zedn; % no need for 3d here
    % normalise the cluster counts (to percentages)
    totalS = clusters(:,6)+clusters(:,7)+clusters(:,8); % solute
    total = clusters(:,6)+clusters(:,7)+clusters(:,8)+clusters(:,9)+clusters(:,10); % total
    clusters(:,11) = clusters(:,6)./total; % y
    clusters(:,12) = clusters(:,7)./total; % ti
    clusters(:,13) = clusters(:,8)./total; % o
    clusters(:,14) = clusters(:,9)./total; % cr
    clusters(:,15) = clusters(:,10)./total;% fe
    clusters(:,16) = clusters(:,6)./totalS; % y solute bias
    clusters(:,17) = clusters(:,7)./totalS; % ti solute bias
    clusters(:,18) = clusters(:,8)./totalS; % o solute bias
    % calculate the composition of each dmax
    compositionResults(iindex,2:end) = mean(clusters(:,11:15));
    % plot tern plot
    scatterh(iindex)=scatter(clusters(:,16)+clusters(:,17)/2,clusters(:,17)*0.866,clusters(:,5)*3,cc(iindex+1,:));
    hleg1 = legend(scatterh(iindex),legendtext(iindex));
    %pause on
    %pause
    clear decomposeCounts
    clear elements
    clear data
    clear nTable
end
legend(scatterh,legendtext);
%hold off;