function [gh] = ternPlotter_csv(cList)
% script for ternary data plotting
% takes a list of csv files and plots them on the same axes

% or run it for a single decomp.xls file:
clusterPlot=cell(1);

for fileN = 1:length(cList)
    [elements,countsDecomp,~,~,~,~,~,extentZ,~,~,~,~,~,~,~] = clusterExtent(cList{fileN});
    
    % generate tern-plot data
    inc = {'Y','Ti','O'}; % include which elements?
    % find the data for the plot
    for i = 1:length(inc)
        incp(i) = find(strcmp(elements,inc{i})); % column in elements
    end
    tot = sum(countsDecomp(:,incp),2);
    x = countsDecomp(:,incp(1))./tot + 0.5*countsDecomp(:,incp(2))./tot;
    y = 0.86603*countsDecomp(:,incp(2))./tot;
    clusterPlot{fileN} = [x y extentZ]; % only read last 3 columns
    % generate legend text
    S = textscan(cList{fileN},'R14_%s','delimiter','-');
    legendText{fileN} = S{1}{1};
end
gh = zeros(1,length(cList)); % array for graphics handles

% ternary plot
plotScale = 0.5;
terplot(6,plotScale,0.04,'%3.1f');
hold on;
spacing = 0.09; % text spacing
% place text
text(0.5,-spacing,'Y fraction','Rotation',0,'HorizontalAlignment','center');
text((.75)+spacing,(.866/2),'Ti fraction','Rotation',-60,'HorizontalAlignment','center');
text((.25)-spacing,(.866/2),'O fraction','Rotation',60,'HorizontalAlignment','center');

for p = 1:length(cList)
    gh(p) = scatter(clusterPlot{p}(:,1)/plotScale,clusterPlot{p}(:,2)/plotScale,(clusterPlot{p}(:,3)).^2,'filled');
end
legend(gh,legendText);

hold off;
end