% Plot a ternary diagram from a cluster file list
cfRoot='c:\users\andy\APT\clusterAnalysis\';
% get cluster and range files from database
[d,cols]=dataBase('run==19170',0); % get run data files from DB
xx = cell(1,size(d,1));
yy= xx;
r = xx;
for i=1:size(d,1)
    %get file name
    cf = [cfRoot d{i,strcmp('cf',cols)}];
    % read cluster file
    [elements,countsDecomp,counts,positions,ionType,radii,rz,extentZ,nTable,dmax,dbulk,derode,nmin,core,count] = clusterExtent(cf);
    % get Y, ti and O counts
    y = countsDecomp(:,strcmp(elements,'Y'));
    ti = countsDecomp(:,strcmp(elements,'Ti'));
    o = countsDecomp(:,strcmp(elements,'O'));
    r{i} = extentZ;
    figure
    [h,xx{i},yy{i}] = terPlotYTiO(y,ti,o,extentZ);
    figure
    scatter3(positions(:,1),positions(:,2),-1*positions(:,3),(extentZ*2).^2,clusterColour([y o ti]),'filled');
    axis equal
end