% script for ternary data plotting
% this uses an xls spreadsheet with the output of
% DataReader.m as separate sheets
% Original work by A. London, Jan 2013
% requires the ternary2 package for terplot
% (terplot modified by A. London 2012)

% example data read 'conversion' to an xls file:
%clusterDataReader('R14_16731-v01_YTiOYO.csv');
% the above outputs 'R14_*_decomp.xls'
% this can be copied into allClusterAnalysis using batchwrite.m
if(0)
    readRange = 'P2:R65'; % needs to be bigger than the data
    readFile = 'allClusterAnalysis_irrd.xls';
    r416 = xlsread(readFile,1,readRange);
    r421 = xlsread(readFile,2,readRange);
    r469 = xlsread(readFile,3,readRange);
    r559 = xlsread(readFile,4,readRange);
    r725 = xlsread(readFile,5,readRange);
    r731 = xlsread(readFile,6,readRange);
end

% or run it for a single decomp.xls file:
clusterPlot=cell(1);
if(1)
    %xlsFiles = {'R14_16416-v02_YO2YO_80_decomp.xls';'R14_15734-v02_YYOTiOO_80_09_decomp.xls'};
    for fileN = 1:length(xlsFiles)
        xlsData=xlsread(xlsFiles{fileN});
        solutePercent = sum(xlsData(:,3:5),2)./sum(xlsData(:,1:5),2);
        clusterPlot{fileN} = xlsData(solutePercent>0.001,(end-2):end); % only read last 3 columns
        % generate legend text
        S = textscan(xlsFiles{fileN},'R14_%s','delimiter','-');
        legendText{fileN} = S{1}{1};
    end
    gh = zeros(1,length(xlsFiles)); % array for graphics handles
end
% ternary plot
terplot(6,1,0.04,'%3.1f');
hold on;
spacing = 0.09; % text spacing
% place text
text(0.5,-spacing,'Y fraction','Rotation',0,'HorizontalAlignment','center');
text((.75)+spacing,(.866/2),'Ti fraction','Rotation',-60,'HorizontalAlignment','center');
text((.25)-spacing,(.866/2),'O fraction','Rotation',60,'HorizontalAlignment','center');
% plot scatter graphs
% gh(1) = scatter(r416(:,1),r416(:,2),r416(:,3)*5);
% gh(2) = scatter(r421(:,1),r421(:,2),r421(:,3)*5);
% gh(3) = scatter(r469(:,1),r469(:,2),r469(:,3)*5);
% gh(4) = scatter(r559(:,1),r559(:,2),r559(:,3)*5);
% gh(5) = scatter(r725(:,1),r725(:,2),r725(:,3)*5);
% gh(6) = scatter(r731(:,1),r731(:,2),r731(:,3)*5);
% legend(gh,'416','421','469','559','725','731');
for p = 1:length(xlsFiles)
    gh(p) = scatter(clusterPlot{p}(:,1),clusterPlot{p}(:,2),15*clusterPlot{p}(:,3));
end
legend(gh,legendText);

hold off;