%function ternErrors2(xlsfile,fullformat)
% function ternErrors(xlsfile,fullformat)
% generate errorbars (in a csv file) for x,y data generated for a ternary diagram based on
% the number of counts for that cluster. Uses data generated by IVAS that
% has been run through 'clusterDataReader' to decompose the cluster counts
% and produce an xls file
% the FULLFORMAT flag chooses between outputing all of the data (1) or just
% the x, xerr, y, yerr and radius of the clusters (0).
% This function assumes that rg is in the last column
comp1 = 'Y'; % component 1
comp2 = 'Ti';% component 2
comp3 = 'O'; % component 3

% read xls file
[ndata, text] = xlsread(xlsfile);

rg = ndata(:,end); % separate rg column
ndata = ndata(:,1:end-1);
text = text(1:end-1); % remove rg from the headers
% generate totals
%tot = sum(ndata(:,3:5),2); % see later

% found x column
pos = find(strcmp(text,'x'));
x = ndata(:,pos(1));

% found y column
pos = find(strcmp(text,'y'));
y = ndata(:,pos(1));


pos = find(strcmp(text,comp1));
if isempty(pos)
    disp(strcat('Component:',comp1,' not found'));
else
    col1 = ndata(:,pos(1));% found counts of Yttrium
end

pos = find(strcmp(text,comp2));
if isempty(pos)
    disp(strcat('Component:',comp2,' not found'));
else
    col2 = ndata(:,pos(1));% found counts of Titanium
end

pos = find(strcmp(text,comp3));
if isempty(pos)
    disp(strcat('Component:',comp3,' not found'));
else
    col3 = ndata(:,pos(1));% found counts of Titanium
end

[x,y,eb] = ternErr([col1 col2 col3]);
tot = col1+col2+col3;

if(0) % draw error bars?
hold on
for i = 1:length(eb(:,1))
    for j = 0:4:8
        plot([eb(i,j+1);eb(i,j+2)],[eb(i,j+3);eb(i,j+4)]); 
    end
end
hold off
end

%plot([x+c1(1)*ec1(1)*0.866 x-c1(1)*ec1(1)*0.866],[y-c1(1)*0.5*ec1(1) y+c1(1)*0.5*ec1(1)],'b-','linewidth',2);
%plot([x x],[y-c1(2)*ec1(2) y+c1(2)*ec1(2)],'b-','linewidth',2);
%plot([x+c1(3)*ec1(3)*.866 x-c1(3)*ec1(3)*.866],[y+c1(3)*0.5*ec1(3) y-c1(3)*0.5*ec1(3)],'b-','linewidth',2);

col1err = (col1./tot).*sqrt((1./col1) + (1./tot)); % actual error in Y fraction
col2err = (col2./tot).*sqrt((1./col2) + (1./tot)); % actual error in Ti fraction

col1err(isnan(col1err)) = 0; % check for clusters with 0 counts
col2err(isnan(col2err)) = 0;

xerr = sqrt(col1err.^2 + (col2err/2).^2);
yerr = (col2err*0.866);

% write file
filename = regexprep(xlsfile,'.xls','_errs.csv');
disp(strcat('Writing file:',filename));
fid = fopen(filename, 'w');

if(fullformat)
    % headers
    for s = 1:length(text)
        fprintf(fid,'%s,',text{s});
    end
    fprintf(fid,'xerr,yerr,rg\n');% end of line for headers
    
    for row=1:length(ndata(:,1))
        for col = 1:length(ndata(1,:))
            fprintf(fid, '%f,',ndata(row,col));
        end
        fprintf(fid, '%f,%f,%f\n',xerr(row),yerr(row),rg(row));
    end
else
    % use reduced format
    % Just print x,xerr,y,yerr,rg
    % headers
    fprintf(fid,'x,y,e1x1,e1x2,e1y1,e1y2,e2x1,e2x2,e2y1,e2y2,e3x1,e3x2,e3y1,e3y2,rg\n');
    for row = 1:length(ndata(:,1))
        fprintf(fid,'%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f\n',x(row),y(row),eb(row,:),rg(row));
    end
end
fclose(fid);
%end