function [x,y,eb] = ternErr(col)
% [x,y,eb] = ternErr(col)
% takes 3 solute count columns and returns the x,y coords of each composition's
% position on a ternary diagram as well as the coords of a hexagonal error
% bar of the format (e1x1 e1x2 e1y1 e1y2 .... etc)
tot = sum(col,2);%col1+col2+col3; % Total solute counts
%col = [col1 col2 col3]; % Solute ion counts
comp = col./[tot tot tot]; % % composition
% calculate errors
%cfe = sqrt(.63)*sqrt(1./(col)); % composition fractional error
%tfe = sqrt(.63)*sqrt(1./(tot)); % fractional error in the total

% coords for a terplot
x = col(:,1)./sum(col,2)+col(:,2)./(2*sum(col,2));
y = col(:,2)*0.866./sum(col,2);

% actual error in composition (errors of tot+each component:
ce = comp.*sqrt( 0.63./(col) + 0.63./([tot tot tot])); % comp error
% points for ploting the error bars
eb(:,1) = x + ce(:,1)*0.5;
eb(:,2) = x - ce(:,1)*0.5;
eb(:,3) = y - ce(:,1)*0.866;
eb(:,4) = y + ce(:,1)*0.866;
eb(:,5) = x;
eb(:,6) = x;
eb(:,7) = y - ce(:,2);
eb(:,8) = y + ce(:,2);
eb(:,9) = x + ce(:,3)*0.5;
eb(:,10) = x - ce(:,3)*0.5;
eb(:,11) = y + ce(:,3)*.866;
eb(:,12) = y - ce(:,3)*0.866;
end