function [h,xx,yy] = terPlotYTiO(y,ti,o,r)
%[h] = terPlotYTiO(y,ti,o,r)
% function for simple plotting of a ternary diagram, give it y, ti and o
% counts as well a size in nm.
% ternary plot
terplot(6,1,0.04,'%3.1f');
hold on;
spacing = 0.09; % text spacing
% place text
text(0.5,-spacing,'Y fraction','Rotation',0,'HorizontalAlignment','center');
text((.75)+spacing,(.866/2),'Ti fraction','Rotation',-60,'HorizontalAlignment','center');
text((.25)-spacing,(.866/2),'O fraction','Rotation',60,'HorizontalAlignment','center');
y_c = y./(y+ti+o);
ti_c = ti./(y+ti+o);
o_c = o./(y+ti+o);
xx = y_c+ti_c/2;
yy = ti_c*sqrt(3/4);
h = scatter(xx,yy,(2*r).^2,clusterColour([y_c o_c ti_c]),'filled');
hold off
end