% super naughts and crosses
clf
markers={'X','O','No one'};
% setup board
lines = [0 1 2 3];
marginSmall = [0.024 0.09];
marginBig = [0.175 0.35];
x = [lines(1) lines(4) nan lines(1) lines(4) nan lines(2) lines(2) nan lines(3) lines(3) nan];
y = [lines(2) lines(2) nan lines(3) lines(3) nan lines(1) lines(4) nan lines(1) lines(4) nan];
[X,Y]=meshgrid([1:4]);
X=(X-1)/3;
Y=flipud((Y-1)/3);
for i = 0:8
    r = floor((i)/3)+1;
    c = mod(i,3)+1;
    h(i+1)  = axes('Position',[X(1,c)+0.005 Y(r+1,1)+0.005 (1/3-0.01) (1/3-0.01)]);
    
    plot(x,y,'k-')
    xlim([lines(1) lines(4)]);ylim([lines(1) lines(4)]);
    set(h(i+1),'XTick',[]);
    set(h(i+1),'YTick',[]);
    %annotation('rectangle',[X(1,c) Y(r+1,1) 1/3 1/3],'LineWidth',3);
end


board = cell(3);
board(:) = {zeros(3)};
bigBoard = zeros(3);
turn = 2;
win = 0;
while win ~= 1
    
    % change turn
    if turn == 1
        turn = 2;
    else
        turn = 1;
    end
    
    [a,b]=ginput(1);
    % determine sub-box
    subbox = find(h==gca)
    
    % determine box
    if a<lines(2)
        box(1) = 1;
    elseif a>=lines(2) && a<lines(3)
        box(1) = 2;
    elseif a>=lines(3) && a<lines(4)
        box(1) = 3;
    else
        warning('Invalid position');
    end
    
    if b<lines(2)
        box(2) = 3;
    elseif b>=lines(2) && b<lines(3)
        box(2) = 2;
    elseif b>=lines(3) && b<lines(4)
        box(2) = 1;
    else
        warning('Invalid position');
    end
    
    % check move
    if board{subbox}(box(1),box(2)) == 0
        
        r = floor((3-subbox)/3)+3;
        c = mod(subbox-1,3)+1;
        disp(['subbox: ' num2str(subbox) ', (' num2str(r) ',' num2str(c) '), ' num2str(box)]);
        mx = marginSmall(1) + (c-1)*.33 + box(1)*0.111;
        my = marginSmall(2) + (r-1)*.33 + (4-box(2))*0.111;
        % place marker
        board{subbox}(box(1),box(2)) = turn;
        annotation(gcf,'textbox',[mx my 0 0],'string',markers{turn},'HorizontalAlignment','center','LineStyle','none','FontSize',16)
    else
        warning('Invalid move');
    end
    
    % check for win condition
    p{1} = board{subbox} == 1;
    p{2} = board{subbox} == 2;
    for i = 1:length(p)
        r = sum(p{i},1) == 3;
        c = sum(p{i},2) == 3;
        % diagonals
        if sum(diag(p{i})) == 3
            bigBoard(subbox) = turn;
            break
        elseif sum(r) || sum(c)
            bigBoard(subbox) = turn;
            break
        end
    end
    % check stale-mate
    if sum(sum(board{subbox}==0)) == 0
        bigBoard(subbox) = 3;
    end
    % check big board win conditions
end
disp(['player ' markers{turn} ' wins!'])