% after running clusterMassSpec you can use this script to plot stacked
% histograms of the cluster compositions.
ions = makeIon(rangeTable(:,3:end),rangeElements); % list of ions from rrng file
[ionq,ia,ic]= unique(ions,'stable'); % get uniquie ions
% get ionic composition
for i = 1:length(cubeRangeCounts(:,1))
ionicComp(i,:) = accumarray([ic ones(size(ic))],cubeRangeCounts(i,:));
end
% For solute percentage filtering
soluteP = sum(clusterCountsDecomp(:,3:5),2)./sum(clusterCountsDecomp,2);

%[sortedR, radiiI]=sort(radii); % generate a list of sorted radii to sort the plot with, this could be any index list though.
[sortedR, radiiI]=sort(ionicComp(:,find(strcmp('TiO',ionq))));
subplot(3,1,1)
ionselection = [find(strcmp('Y',ionq)) find(strcmp('YO',ionq)) find(strcmp('YO2',ionq)) find(strcmp('Ti',ionq)) find(strcmp('TiO',ionq)) find(strcmp('TiO2',ionq)) find(strcmp('O',ionq)) find(strcmp('FeO',ionq)) find(strcmp('CrO',ionq)) find(strcmp('Fe',ionq)) find(strcmp('Cr',ionq))];
bar(ionicComp(radiiI(soluteP>0.04),ionselection),'stacked')
legend(ionq(ionselection))
subplot(3,1,2)
ionicCompP=ionicComp(:,ionselection)./repmat(sum(ionicComp(:,ionselection),2),1,length(ionselection));
bar(ionicCompP(radiiI(soluteP>0.04),:),'stacked')
legend(ionq(ionselection))
subplot(3,1,3)
%ionselection=ionselection([1:end-2 end]);
ionselection=ionselection([1:end-1]);
ionicCompP=ionicComp(:,ionselection)./repmat(sum(ionicComp(:,ionselection),2),1,length(ionselection));
bar(ionicCompP(radiiI(soluteP>0.04),:),'stacked')
legend(ionq(ionselection))
