function [x,fe,fe1,fe2,y,ti,o]=srimImport2(file)
filename=file;
delimiter = ' ';
startRow = 41;

%% Format string for each line of text:
%   column1: text (%s)
%	column2: text (%s)
%   column3: text (%s)
%	column4: text (%s)
%   column5: text (%s)
%	column6: text (%s)
%   column7: text (%s)
% For more information, see the TEXTSCAN documentation.
formatSpec = '%s%s%s%s%s%s%s%*s%*s%*s%*s%*s%*s%*s%*s%[^\n\r]';

%% Open the text file.
fileID = fopen(filename,'r');

%% Read columns of data according to format string.
% This call is based on the structure of the file used to generate this
% code. If an error occurs for a different file, try regenerating the code
% from the Import Tool.
textscan(fileID, '%[^\n\r]', startRow-1, 'ReturnOnError', false);
dataArray = textscan(fileID, formatSpec, 'Delimiter', delimiter, 'MultipleDelimsAsOne', true, 'ReturnOnError', false);

%% Close the text file.
fclose(fileID);

%% Post processing for unimportable data.
% No unimportable data rules were applied during the import, so no post
% processing code is included. To generate code which works for
% unimportable data, select unimportable cells in a file and regenerate the
% script.

%% Allocate imported array to column variable names
DEPTH = dataArray{:, 1};
Fe = dataArray{:, 2};
Fe1 = dataArray{:, 3};
Y = dataArray{:, 4};
Ti = dataArray{:, 5};
O = dataArray{:, 6};
Fe2 = dataArray{:, 7};

%% Clear temporary variables
clearvars filename delimiter startRow formatSpec fileID dataArray ans;

x = cell2mat(cellfun(@str2double,DEPTH,'uni',0));
fe = cell2mat(cellfun(@str2double,Fe,'uni',0));
fe1 = cell2mat(cellfun(@str2double,Fe1,'uni',0));
fe2 = cell2mat(cellfun(@str2double,Fe2,'uni',0));
o = cell2mat(cellfun(@str2double,O,'uni',0));
ti = cell2mat(cellfun(@str2double,Ti,'uni',0));
y = cell2mat(cellfun(@str2double,Y,'uni',0));
end