function C = sphereDiffusion(x,h,rDT)
%C = sphereDiffusion(x,h,rDT)
% analytical result of a sphere dissolving. x is the radial coordinate
% h is the initial radius
% rDT = sqrt(D*t) the diffusion product
% C = C/C0 where C0 is the initial conc of the sphere

C = 0.5*(erf((h-x)./(2*rDT))+erf((h+x)./(2*rDT)));