% sphere cut

% init vars
mu = 3; sigma = .5; simulations = 1000;bins = 50;

% Normal distribution of spheres of radius a
% normally distributed random numbers:

a = normrnd(mu,sigma,simulations,1);
a(a<0)=0;
% Consider a sphere of radius a which is cut by the plane. The probability P_x(x) that
% the sphere centre is a distance x above the plane is uniform in - a < x < a , i.e.
% P_a(x) = 1/2a      -a<x<a
% P_a(x) = 0 otherwise.
x = rand(simulations,1);
%Now the radius s of the disc formed is given by
s = sqrt((a - x).*(a + x));

% sim real dist
subplot(2,1,1);
hist(a,bins); 
hold on;
% model:
x = 0:.1:7;
plot(x,(sum(a)/(bins*sqrt(bins)))*(sqrt(8*pi)/sigma)*exp((-(x-mu).^2)/(2*sigma*sigma)),'r');
plot(x,sum(a)/(bins*normpdf(0,0,sigma))*normpdf(x,mu,sigma),'kx'); hold off;

% sim measured dist
subplot(2,1,2);
hist(s,bins); 
hold on;
plot(x,(sum(s)/(bins*sqrt(bins)))*2*pi.*x.*exp((-(x-mu).^2)/(2*sigma*sigma)),'r'); hold off;