% Solute plotting 21/06/13
% Investigating the solute content as a function of cluster selection
% parameters.

% Read cluster stats file (generated by posgen)
if(0) % Set to 1 for running the first time
[elements, countsDecomp,counts,position,ionType,rg, nTable] =clusterStatsReader('c:\users\andy\APT\posgen\17183clusteredStats.txt',{'YO'});
[uelements, ucountsDecomp,ucounts,uposition,uionType,urg, unTable] =clusterStatsReader('c:\users\andy\APT\posgen\17183unclusteredStats.txt',{'YO'});
soluteP = sum(countsDecomp(:,3:5),2)./sum(countsDecomp(:,1:5),2);
usoluteP = sum(ucountsDecomp(:,3:5),2)./sum(ucountsDecomp(:,1:5),2);
end

if(0) % Plot histogram of solute fraction with two Nmin ranges
    hist(soluteP(nTable>1 & nTable<25))
    h1 = findobj(gca,'Type','patch');
    hold on;
    hist(soluteP(nTable>25));
    h = findobj(gca,'type','patch');
    h2 = setdiff(h,h1);
    set(h1,'FaceColor','w','EdgeColor','r');
    set(h2,'FaceColor','w','EdgeColor','b','faceAlpha',0.5);
    hold off
end

if(0) % how does the min and mean change with Nmin?
    x=1:100;
    index = 1;
    for n=x
        ymin(index)=min(soluteP(nTable>n));
        ymean(index)=mean(soluteP(nTable>n));
        index = index+1;
    end
    plot(x,ymin,x,ymean);
end

if(1) % filtering on Nmin and solute % based on un-clustered data
    % filter based on Nmin and solute fraction
    maxsolute = max(usoluteP);
    maxN = max(unTable);
    m = -maxsolute/(maxN-1); % slope of cut-off
    c = maxsolute-m; % intercept of cut-off
    clusterFilter = soluteP>(m.*nTable+c);
else
    clusterFilter = soluteP>=0;
end

% Plot 2D histograms of cluster numbers with solute % and Nmin
clustered = 1; % do you want to plot the clustered or unclustered data?
if(1)
    bincentres = 0:0.02:0.4;
    Nrange = 1:100;
    plot2d = zeros(length(bincentres),length(Nrange));
    if(clustered)
        for n=Nrange
            plot2d(:,n) = hist(soluteP(nTable==n & clusterFilter),bincentres)';
        end
    else
        for n=Nrange
            % You can't filter the unclustered data...
            plot2d(:,n) = hist(usoluteP(unTable==n),bincentres)';
        end
    end
    contourf(Nrange,bincentres,plot2d,[1:20 30:10:100]) % contour plot
    xlabel('N_{min}');
    ylabel('Solute fraction');
end
