% This script looks at a set of files and returns histograms of the solute
% percentage (Y, Ti, O)/(Fe + Cr +Y,Ti,O)
% Solute percentage as well as size can be used as critiria to distinguish
% between real and random clusters as identified by maximum separation
% A London June 2013

% subplot columns
subplotCols = 5;
histBins = 30; % number of bins in the histograms
% select cluster files
root = 'C:\Users\andy\APT\clusterAnalysis\';
% get list of list names
filelist =  dir(strcat(root,'*_decomp.xls'));
fileNames = {filelist.name}';
nfiles = length(fileNames);
% read cluster files
data = cell(nfiles,1);

for i = 1:nfiles
    % read decomposed cluster data file
%     if(0)
        xlsData=xlsread(strcat(root,fileNames{i}));
        data{i} = xlsData;
%     else
%         xlsData = data{i};
%     end
    % calculate solute percentage per cluster
    solutePercent = sum(xlsData(:,3:5),2)./sum(xlsData(:,1:5),2);
    %clusterPlot{fileN} = xlsData(solutePercent>0.001,(end-2):end); % only read last 3 columns
    % generate legend text
    S = textscan(fileNames{i},'R14_%s');
    legendText{i} = S{1}{1}; % get text relating to each file
    % render result
    subplot(ceil(nfiles/subplotCols),subplotCols,i);
    %hist(solutePercent,histBins);
    scatter(xlsData(:,end),solutePercent);
    title(legendText{i});
    xlim([0 5]);
    ylim([0 1]);
end


