function [im]=saxeyPlotter(m1,m2,maxm,binm)
%[h]=saxeyPlotter(m1,m2,maxm)
% plot a saxey plot from two lists of data (m/z ratios), maxm defines the
% maximum value to be considered. binm = binning size
% Note you may need to set colormap('default') before plotting other data
if size(m1) ~= size(m2)
   error('Dimensions of m1 and m2 are inconsistent');
end
if nargin<3
    maxm = max(max(m1), max(m2));
    disp(['max value set to ' num2str(maxm)]);
    binm = 0.02;
elseif nargin < 4
   binm = 0.02; 
end

p = m1<maxm | m2<maxm;

x=0:binm:maxm;
n=hist3([m2(p) m1(p)],{x,x});
im=imagesc(x,x,log(n))
axis equal tight

xlabel('1^{st} hit m/z Da'); ylabel('2^{nd} hit m/z Da')

% sort out axes (flip y axis)
set(gca,'YDir','normal')
% ylabs = get(gca,'YTickLabel');
% set(gca,'YTick',max(x)-max(ylabs)+ylabs);
% set(gca,'YTickLabel',fliplr(ylabs));

% set colour map
cm=colormap('jet');
cm(2:end+1,:) = cm;
cm(1,:) = 1; % set lowest level to white
colormap(cm);

end