% saxey plot script
% set init to 1 when you first run, and 0 subsequently for one MATLAB
% session, this avoids having to re-load the data.
init = 1;
if init
    %fileName = 'R14_21424-v01';
    [fileN,path]=uigetfile('.epos','Select epos file');
    fileN = regexprep(fileN,'\.epos','');
    [x,y,z,m,tof,vdc,vp,xd,yd,dP,nm,nb]=readepos([path fileN]);
    
    multiHit = (dP==0);
    
    p = (multiHit+[multiHit(2:end); 0])>0;
    
    firstHits = find(p-multiHit);
end

x=0:0.02:100;
n=hist3([m(firstHits) m(firstHits+1); m(firstHits+1) m(firstHits)],{x,x});
imagesc(x,x,log(n))
axis equal tight

xlabel('1^{st} hit m/z Da'); ylabel('2^{nd} hit m/z Da')

% sort out axes (flip y axis)
set(gca,'YDir','normal')
% ylabs = get(gca,'YTickLabel');
% set(gca,'YTick',max(x)-max(ylabs)+ylabs);
% set(gca,'YTickLabel',fliplr(ylabs));

% set colour map
cm=colormap('jet');
cm(2:end+1,:) = cm;
cm(1,:) = 1; % set lowest level to white
colormap(cm);