function save_tiff(fileName,timg)
% saves data to floating point tiff image

t = Tiff(fileName, 'w'); 
tagstruct.ImageLength = size(timg, 1); 
tagstruct.ImageWidth = size(timg, 2); 
tagstruct.Compression = Tiff.Compression.None; 
tagstruct.SampleFormat = Tiff.SampleFormat.IEEEFP; 
tagstruct.Photometric = Tiff.Photometric.MinIsBlack; 
tagstruct.BitsPerSample = 64; 
tagstruct.SamplesPerPixel = 1; 
tagstruct.PlanarConfiguration = Tiff.PlanarConfiguration.Chunky; 
t.setTag(tagstruct); 
t.write(timg); 
t.close();

end