% read cluster file
[elements,countsDecomp,counts,position,~,radii,extents,~,~,~,~,~,~,~,~,~,count] = clusterSizes('c:\users\andy\apt\clusterAnalysis\R14_19644-v01.csv');
% calc Y:O ratio
yorat = countsDecomp(:,strcmp(elements,'Y'))./countsDecomp(:,strcmp(elements,'O'));
% which clusters are on the gb? based on position in the data set
% x > 10.5 and z < 200 nm
p=position(:,1)>10.5 & position(:,3)<200;
% plot
scatter(radii(:,3)*sqrt(5),yorat,radii(:,3)*sqrt(5)*10,p,'filled')
hold on
plot([0 8],[0.66 .66],'k-.')
xlabel('r_Z nm');ylabel('Y:O ratio');
hold off
saveas(gca,'irrd500C_FeY2O3.png'); % save plot as image
% get carbon concentration in the clusters
carbon = countsDecomp(:,strcmp(elements,'C'))./sum(countsDecomp(:,2:end),2);
subplot(2,1,1);hist(carbon(p));xlim([0 0.14]);xlabel('C content, bulk clusters');
subplot(2,1,2);hist(carbon(~p));xlim([0 0.14]);xlabel('C content, GB clusters');

