%# type and size in byte of the record fields
recordType = {'float32' 'float32' 'float32' 'float32' 'float32' 'float32' 'float32' 'float32' 'float32' 'uint32' 'uint32'};
recordLen = [4 4 4 4 4 4 4 4 4 4 4];
R = cell(1,numel(recordType));

%# read column-by-column
fid = fopen('R14_15633-v03.epos','r','b');
for i=1:numel(recordType)
    %# seek to the first field of the first record
    fseek(fid, sum(recordLen(1:i-1)), 'bof');

    %# % read column with specified format, skipping required number of bytes
    R{i} = fread(fid, 22, ['*' recordType{i}], sum(recordLen)-recordLen(i));
end